/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.xml.editor;

import com.indy.file.xml.editor.ColorManager;
import com.indy.ui.custom.out.Activator;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class XmlTextListener
implements LineStyleListener {
    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        Color current = null;
        boolean withinTag = false;
        int startPos = 0;
        int i = 0;
        while (i < event.lineText.length()) {
            char c = event.lineText.charAt(i);
            if (c == '<') {
                current = Activator.getDefault().getColor(ColorManager.TAG);
                startPos = i;
                withinTag = true;
            } else if (c == '>') {
                if (current != Activator.getDefault().getColor(ColorManager.TAG)) {
                    styles.add(new StyleRange(event.lineOffset + startPos, i - startPos, current, null));
                    current = Activator.getDefault().getColor(ColorManager.TAG);
                    startPos = i;
                    styles.add(new StyleRange(event.lineOffset + startPos, 1, Activator.getDefault().getColor(ColorManager.TAG), null));
                } else {
                    styles.add(new StyleRange(event.lineOffset + startPos, i - startPos + 1, Activator.getDefault().getColor(ColorManager.TAG), null));
                }
                withinTag = false;
            } else if (withinTag) {
                if (Character.isWhitespace(c) && current == Activator.getDefault().getColor(ColorManager.TAG)) {
                    styles.add(new StyleRange(event.lineOffset + startPos, i - startPos, current, null));
                    current = Activator.getDefault().getColor(ColorManager.STRING);
                    startPos = i;
                }
            } else {
                current = null;
            }
            ++i;
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }
}

