/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc;

import com.indy.addons.Messages;
import com.indy.md.ui.editor.ui.MdControl;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.ReverseUtil;
import com.stambia.md.custom.exception.ReverseException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;

public class MdReverserNode {
    public static final ReverseJobManager MANAGER = new ReverseJobManager();
    public static final int STRING_COMBO_TYPE = 1;
    public static final int REF_COMBO_TYPE = 2;
    public static final int REF_TREE_TYPE = 3;
    public static final int STRING_TYPE = 4;
    private Object selection;
    private int type;
    private String codeFeature;
    private Object input;
    private MdReverse reverse;
    private Connection connection;
    private MdNode node;
    private Map<String, Boolean> incrementalDelete;
    private Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseMode;

    public static MdReverserNode createNode(MdControl control, MdReverse reverse, Connection connection, MdNode mdNode, Map<String, Boolean> incrementalDelete, Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseMode) {
        Object in = null;
        if (control.getControl() instanceof Viewer) {
            in = ((Viewer)control.getControl()).getInput();
        }
        MdReverserNode n = new MdReverserNode(control.getSelection(), control.getType(), control.getDefCodeFeature(), in);
        n.reverse = reverse;
        n.connection = connection;
        n.node = mdNode;
        n.incrementalDelete = incrementalDelete;
        n.reverseMode = reverseMode;
        return n;
    }

    private MdReverserNode(Object selection, int type, String codeFeature, Object input) {
        this.selection = selection;
        this.type = type;
        this.codeFeature = codeFeature;
        this.input = input;
    }

    protected Object getSelection() {
        return this.selection;
    }

    protected Object getInput() {
        return this.input;
    }

    protected int getType() {
        return this.type;
    }

    protected String getCodeFeature() {
        return this.codeFeature;
    }

    protected void reverse(MdReverse reverse, Object connection, MdNode parent) throws ReverseException {
        this.reverse(reverse, connection, parent, null);
    }

    protected void reverse(MdReverse reverse, Object connection, MdNode parent, Map<String, Boolean> incrementalDelete) throws ReverseException {
        this.reverse(reverse, connection, parent, incrementalDelete, null);
    }

    public void performReverse(IProgressMonitor monitor) throws ReverseException {
        this.reverse.setProgressMonitor(monitor);
        this.reverse(this.reverse, this.connection, this.node, this.incrementalDelete, this.reverseMode);
    }

    public List<MdNode> doReverse(IProgressMonitor monitor) throws ReverseException {
        this.reverse.setProgressMonitor(monitor);
        List list = null;
        Object[] obj = this.getUserSelectedNodeArray();
        if (obj != null) {
            list = ReverseUtil.doReverse((MdReverse)this.reverse, (Object)this.connection, (Object[])obj);
        }
        return list;
    }

    protected void reverse(MdReverse reverse, Object connection, MdNode parent, Map<String, Boolean> incrementalDelete, Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseMode) throws ReverseException {
        Object[] obj = this.getUserSelectedNodeArray();
        if (obj != null) {
            ReverseUtil.incrementalReverse((MdNode)parent, (MdReverse)reverse, (Object)connection, (Object[])obj, incrementalDelete, reverseMode);
        }
    }

    private Object[] getUserSelectedNodeArray() {
        Object[] obj = new Object[1];
        Object object = this.getSelection();
        String tt = "1";
        if (object instanceof List) {
            ArrayList<MdNode> toRemove = new ArrayList<MdNode>();
            List roots = (List)this.getInput();
            if (roots != null) {
                for (MdNode _p : roots) {
                    if (((List)object).contains(_p)) {
                        TreeIterator it = _p.eAllContents();
                        while (it.hasNext()) {
                            EObject _obj = (EObject)it.next();
                            if (!(_obj instanceof MdNode) || ((List)object).contains(_obj)) continue;
                            toRemove.add((MdNode)_obj);
                        }
                        continue;
                    }
                    toRemove.add(_p);
                }
                for (MdNode node : toRemove) {
                    if (roots.remove(node)) continue;
                    ((MdNode)node.eContainer()).getNode().remove((Object)node);
                }
                obj = roots.toArray();
            } else {
                obj = null;
            }
        } else {
            obj[0] = this.getSelection();
        }
        return obj;
    }

    public MdReverse getReverse() {
        return this.reverse;
    }

    public static abstract class ReverseJob
    extends Job {
        public ReverseJob(MdNode nodeToReverse) {
            super(Messages.MdReverserNode_0 + (nodeToReverse == null || nodeToReverse.getName() == null ? "" : nodeToReverse.getName()));
        }

        public void startJob() {
            MANAGER.add(this);
        }

        protected void stopJob() {
            MANAGER.remove(this);
        }
    }

    public static class ReverseJobManager {
        private List<ReverseJob> runnings = Collections.synchronizedList(new ArrayList());

        public void add(ReverseJob j) {
            this.runnings.add(j);
        }

        public void remove(ReverseJob j) {
            this.runnings.remove((Object)j);
        }

        public boolean isEmpty() {
            return this.runnings.isEmpty();
        }
    }
}

