/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.rdbms;

import com.indy.md.rdbms.Messages;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.Tech;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.jdom.NodeWrapper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class Xml2MdConverter {
    private final Logger logger = LogManager.getLogger(this.getClass());
    Map<String, MdNode> idMap = new HashMap<String, MdNode>();
    Map<Attribute, List<String>> attributeRefToResolve = new HashMap<Attribute, List<String>>();
    SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    private void addAttributeToResolve(Attribute att, String nodeId) {
        this.attributeRefToResolve.computeIfAbsent(att, k -> new ArrayList()).add(nodeId);
    }

    public Xml2MdConverter() throws Exception {
        this.parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        this.parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        this.parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        this.parserFactory.setFeature("http://xml.org/sax/features/validation", false);
        this.parserFactory.setNamespaceAware(true);
    }

    /*
     * WARNING - void declaration
     */
    public Result convert(InputStream xmlStream, MdNode substituteContainer, Level level) throws Exception {
        SAXParser parser = this.parserFactory.newSAXParser();
        XMLReader saxReader = parser.getXMLReader();
        EventHanlder handler = new EventHanlder(substituteContainer, level);
        saxReader.setContentHandler(handler);
        saxReader.parse(new InputSource(xmlStream));
        for (Attribute att : this.attributeRefToResolve.keySet()) {
            List<String> l = this.attributeRefToResolve.get(att);
            Property prop = att.getTechProperty();
            Assert.isTrue((prop.getType() == PropertyType.REFERENCE ? 1 : 0) != 0);
            if (l == null) continue;
            for (String string : l) {
                void var11_11;
                if (!string.contains("#")) {
                    String string2 = "#" + string;
                }
                URI uri = URI.createURI((String)var11_11);
                MdNode n = null;
                if (uri.isRelative()) {
                    String ID = CacheHelper.extractEltID((String)uri.fragment());
                    n = this.idMap.get(ID);
                } else {
                    MdNode ref = MdFactory.eINSTANCE.createMdNode();
                    ((InternalEObject)ref).eSetProxyURI(uri);
                    n = ref;
                }
                if (n == null) continue;
                if (prop.isUnbounded()) {
                    att.getRefs().add((Object)n);
                    continue;
                }
                att.setRef((EObject)n);
            }
        }
        return new Result(handler.problems, handler.rootNode);
    }

    public static String convertMd2XMLString(MdNode node, String encoding) throws Exception {
        ByteArrayOutputStream bos = null;
        bos = new ByteArrayOutputStream();
        StreamResult rs = new StreamResult(bos);
        Properties p = new Properties();
        p.setProperty("method", "xml");
        p.setProperty("encoding", encoding);
        p.setProperty("method", "xml");
        p.setProperty("indent", "yes");
        p.setProperty("media-type", "text");
        NodeWrapper doc = node.getNodeWrapper();
        Configuration config = doc.getConfiguration();
        SerializerFactory sf = config.getSerializerFactory();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        Receiver receiver = null;
        try (TreeReceiver tr = null;){
            Item item;
            receiver = sf.getReceiver((javax.xml.transform.Result)rs, pipe, p);
            tr = new TreeReceiver(receiver);
            tr.open();
            UnfailingIterator iterator = SingletonIterator.makeIterator((Item)doc);
            while ((item = iterator.next()) != null) {
                tr.append(item, 0, 0);
            }
        }
        return new String(bos.toByteArray(), encoding);
    }

    class EventHanlder
    implements ContentHandler {
        Tech tech = null;
        MdNode currentNode = null;
        MdNode rootNode = null;
        Level currentLevel = null;
        Level rootLevel = null;
        Attribute currentAttribute = null;
        StringBuilder tagContentBuffer = null;
        Locator locator;
        List<Problem> problems = new ArrayList<Problem>();
        Deque<String> skippedElements = new ArrayDeque<String>();
        MdNode substituteContainer;

        EventHanlder(MdNode substituteContainer, Level rootLevel) {
            this.tech = (Tech)rootLevel.eContainer();
            this.rootLevel = rootLevel;
            this.substituteContainer = substituteContainer;
        }

        private void addProblem(String message) {
            if (this.locator != null) {
                this.problems.add(new Problem(message, this.locator.getColumnNumber(), this.locator.getLineNumber()));
            } else {
                this.problems.add(new Problem(message));
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            Level lvl = this.findLevel(localName);
            if (lvl != null && this.currentLevel != null && !lvl.getParent().contains((Object)this.currentLevel.getCode())) {
                lvl = null;
            }
            boolean createdNode = false;
            if (lvl != null) {
                MdNode node = MdFactory.eINSTANCE.createMdNode();
                node.setDefType(lvl.getCode());
                if (this.rootNode == null) {
                    if (this.rootLevel == lvl) {
                        this.rootNode = node;
                        this.rootNode.setSubstituteContainer((EObject)this.substituteContainer);
                    } else {
                        this.skippedElements.push(localName);
                        return;
                    }
                }
                if (this.currentNode != null) {
                    this.currentNode.getNode().add((Object)node);
                }
                this.currentNode = node;
                this.currentLevel = lvl;
                createdNode = true;
                String id = null;
                int i = 0;
                while (i < atts.getLength()) {
                    String attName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    Property prop = this.findProp(attName, lvl);
                    if (prop == null) {
                        if (lvl.isHasName() && attName.equals("name")) {
                            node.setName(attValue);
                        } else if (!attName.equals("defType")) {
                            if (attName.equals("id")) {
                                id = attValue;
                            } else if (attName.equals("position")) {
                                try {
                                    node.setPosition(BigInteger.valueOf(Long.valueOf(attValue)));
                                }
                                catch (Exception ex) {
                                    Xml2MdConverter.this.logger.debug("unexpected", (Throwable)ex);
                                }
                            } else {
                                this.addProblem(NLS.bind((String)Messages.Xml2MdConverter_4, (Object)attName, (Object)lvl.getCode()));
                            }
                        }
                    } else if (!prop.isUnbounded()) {
                        Attribute att = this.currentNode.getAttributeByShortCode(prop.getCode());
                        if (att != null) {
                            this.addProblem(NLS.bind((String)Messages.Xml2MdConverter_6, (Object)attName, (Object)lvl.getCode()));
                        } else {
                            att = MdFactory.eINSTANCE.createAttribute();
                            this.currentNode.getAttribute().add((Object)att);
                            att.setDefType(this.currentLevel.getCode() + "." + prop.getCode());
                            if (prop.getType() == PropertyType.REFERENCE) {
                                Xml2MdConverter.this.addAttributeToResolve(att, attValue);
                            } else {
                                att.setValue(attValue);
                            }
                        }
                    } else {
                        this.addProblem(NLS.bind((String)Messages.Xml2MdConverter_9, (Object)attName, (Object)lvl.getCode()));
                    }
                    ++i;
                }
                if (createdNode && id != null) {
                    Xml2MdConverter.this.idMap.put(id, this.currentNode);
                }
            } else {
                boolean handled = false;
                Property p = this.findProp(localName, this.currentLevel);
                if (p != null) {
                    if (p.isUnbounded()) {
                        Attribute att = this.currentNode.getAttributeByShortCode(p.getCode());
                        if (att == null) {
                            att = MdFactory.eINSTANCE.createAttribute();
                            att.setDefType(this.currentLevel.getCode() + "." + p.getCode());
                            this.currentNode.getAttribute().add((Object)att);
                        }
                        if (p.isKeyValue()) {
                            String valueKey = null;
                            String value = null;
                            int i = 0;
                            while (i < atts.getLength()) {
                                if (atts.getLocalName(i).equals("key")) {
                                    valueKey = atts.getValue(i);
                                } else if (atts.getLocalName(i).equals("value")) {
                                    value = atts.getValue(i);
                                }
                                ++i;
                            }
                            if (p.getType() == PropertyType.REFERENCE) {
                                Xml2MdConverter.this.addAttributeToResolve(att, this.tagContentBuffer.toString());
                            } else {
                                att.getValueEntry().put(valueKey, value);
                            }
                        } else if (p.getType() == PropertyType.REFERENCE) {
                            Xml2MdConverter.this.addAttributeToResolve(att, this.tagContentBuffer.toString());
                        } else {
                            this.currentAttribute = att;
                        }
                        handled = true;
                    } else {
                        this.addProblem(NLS.bind((String)Messages.Xml2MdConverter_15, (Object)p.getCode(), (Object)this.currentLevel.getCode()));
                    }
                } else {
                    this.addProblem(NLS.bind((String)Messages.Xml2MdConverter_18, (Object)localName));
                }
                if (!handled) {
                    this.skippedElements.push(localName);
                }
            }
        }

        private Property findProp(String attName, Level lvl) {
            for (Property p : lvl.getAttribute()) {
                if (!attName.equals(p.getXmlName())) continue;
                return p;
            }
            return null;
        }

        private Level findLevel(String localName) {
            for (Level l : this.tech.getLevel()) {
                if (!l.getXmlName().equals(localName)) continue;
                return l;
            }
            return null;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.skippedElements.isEmpty() && localName.equals(this.skippedElements.peek())) {
                this.skippedElements.pop();
                return;
            }
            if (this.currentAttribute != null) {
                if (this.tagContentBuffer != null) {
                    if (this.currentAttribute.getTechProperty().getType() == PropertyType.REFERENCE) {
                        MdNode node = MdFactory.eINSTANCE.createMdNode();
                        Object s = this.tagContentBuffer.toString();
                        if (!((String)s).contains("#")) {
                            s = "#" + (String)s;
                        }
                        ((InternalEObject)node).eSetProxyURI(URI.createURI((String)s));
                        this.currentAttribute.getRefs().add((Object)node);
                    } else {
                        this.currentAttribute.getValues().add((Object)this.tagContentBuffer.toString());
                    }
                    this.tagContentBuffer = null;
                }
                this.currentAttribute = null;
            }
            if (this.currentNode != null) {
                this.currentNode = (MdNode)this.currentNode.eContainer();
                if (this.currentNode != null) {
                    this.currentLevel = this.currentNode.getLevel();
                }
            }
            if (this.tagContentBuffer != null) {
                this.addProblem(Messages.Xml2MdConverter_22 + localName);
                this.tagContentBuffer = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.tagContentBuffer == null) {
                String s = new String(ch, start, length);
                if (s.matches("\\s*")) {
                    return;
                }
                this.tagContentBuffer = new StringBuilder();
            }
            this.tagContentBuffer.append(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    class Problem {
        String message;
        int coloumn;
        int line;

        public Problem(String message) {
            this(message, -1, -1);
        }

        public Problem(String message, int coloumn, int line) {
            this.message = message;
            this.coloumn = coloumn;
            this.line = line;
        }
    }

    public class Result {
        private List<Problem> problems;
        private MdNode result;

        public Result(List<Problem> problems, MdNode result) {
            this.problems = problems;
            this.result = result;
        }

        public List<Problem> getProblems() {
            return this.problems;
        }

        public MdNode getResult() {
            return this.result;
        }
    }
}

