<?xml version="1.0" ?>
<xsl:stylesheet
	xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions"
	xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:ref="http://www.stambia.com/ref"
	xmlns:saxon="http://saxon.sf.net/"
	xmlns:tech="http://www.stambia.com/tech"
	xmlns:indyParse="http://www.stambia.com/indyParse"
	xmlns:ecore="http://www.eclipse.org/emf/2002/Ecore"
	xmlns:proc="http://www.example.org/proc"
	xmlns:func="http://www.stambia.com/func"
	xmlns:rdbms="http://www.stambia.com/rdbms"
	xmlns:md="http://www.stambia.com/md"
	xmlns:user="http://www.stambia.com/user"
	xmlns:UUID="java.util.UUID"
	xmlns:mds="java:com.semarchy.xdi.designer.generation.xsl.global.Strings"
	xmlns:map="http://www.stambia.com/map"
	xmlns:saxono="http://www.example.org/saxono"
	xmlns:xslo="http://www.example.org/xslo"
	xmlns:gen="java:com.semarchy.xdi.designer.generation.xsl.gene.GenerationEvaluator"
	version="2.0"
	extension-element-prefixes="saxon ref indyParse tech"
	exclude-result-prefixes="ecore tech UUID proc func md rdbms mds user mdj mdv tech map saxon gen">
	<xsl:output
		method="xml"
		encoding="UTF-8"
		cdata-section-elements="generationCondition executionCondition code step resultCode metaData">
	</xsl:output>
	<xsl:preserve-space elements="code CData resultCode" />
	<xsl:namespace-alias
		stylesheet-prefix="xslo"
		result-prefix="xsl" />
	<xsl:namespace-alias
		stylesheet-prefix="saxono"
		result-prefix="saxon" />
	<xsl:include href="global.xsl" />
	<xsl:include href="parse.xsl" />
	<xsl:param name="generationEvaluator"/>
	
	<!--  
	<xsl:template match="*">
		<xsl:variable name="currentNode" select="."/>
			<xsl:for-each select="@*">
				<xsl:message select="concat(./name(), '=', string(.))"/>
				<xsl:if test="matches(string(.), '.*%x\{.*\}x%.*') or matches(string(.), '.*%\{.*\}%.*')">
					<xsl:value-of select="gen:store($genMap, concat($currentNode/@id, '.parameter.', ./name()), mdj:evaluateX($currentNode, string(.)))"/>
				</xsl:if>
			</xsl:for-each>
		<xsl:apply-templates select="./node()"/>
	</xsl:template>
	-->
	
	<xsl:template match="/">
		<!--  <xsl:apply-templates/>-->
		<!--  <xsl:value-of select="gen:generateExpression($generationEvaluator, .)"/>-->
		<xsl:copy-of select="/"/>
		<xsl:value-of select="gen:generateExpression($generationEvaluator, .)"/>
	</xsl:template>
	
</xsl:stylesheet>