<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:set="http://exslt.org/sets" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:xdt="http://www.w3.org/2005/02/xpath-datatypes" xmlns:deliv="http://www.stambia.com/deliv">
	<xsl:output method="xml" encoding="UTF-8" cdata-section-elements="generationCondition executionCondition"/>
	<xsl:template match="/">
		<xsl:variable name="old">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:variable>
		<xsl:if test="1=2">
			<xsl:variable name="new">
				<xsl:apply-templates select="document(concat(base-uri(),'.new.deliv'))/@*|node()"/>
			</xsl:variable>
			<root>
				<xsl:for-each select="$old//process[@actionName=$new//process/@actionName]">
					<xsl:variable name="oldProc" select="."/>
					<xsl:variable name="newProc" select="$new//process[@actionName=$oldProc/@actionName]"/>
					<xsl:variable name="attributes">
						<xsl:call-template name="compareAttributes2">
							<xsl:with-param name="oldNode" select="$oldProc"/>
							<xsl:with-param name="newNode" select="$newProc"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="step">
						<xsl:for-each select="step">
							<xsl:variable name="oldStep" select="."/>
							<xsl:variable name="newStep" select="$newProc/step[@actionName=$oldStep/@actionName]"/>
							<xsl:variable name="attributes">
								<xsl:call-template name="compareAttributes2">
									<xsl:with-param name="oldNode" select="$oldStep"/>
									<xsl:with-param name="newNode" select="$newStep"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="$attributes/*">
								<step>
									<xsl:if test="$attributes/*">
										<old>
											<xsl:copy-of select="$oldStep/@*[name()=$attributes/*/@name]"/>
										</old>
										<new>
											<xsl:copy-of select="$newStep[name()=$attributes/*/@name]"/>
										</new>
									</xsl:if>
								</step>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:if test="$attributes/* or $step/*/*">
						<process>
							<xsl:if test="$attributes/*">
								<old>
									<xsl:copy-of select="$oldProc/@*[name()=$attributes/*/@name]"/>
								</old>
								<new>
									<xsl:copy-of select="$newProc[name()=$attributes/*/@name]"/>
								</new>
							</xsl:if>
							<xsl:copy-of select="$step[*/*]"/>
						</process>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="$old/process[not(@actionName=$new/process/@actionName)]">
					<oldProcess>
						<xsl:copy-of select="."/>
					</oldProcess>
				</xsl:for-each>
				<xsl:for-each select="$new/process[not(@actionName=$old/process/@actionName)]">
					<newProcess>
						<xsl:copy-of select="."/>
					</newProcess>
				</xsl:for-each>
				<old>
					<xsl:copy-of select="$old"/>
				</old>
				<new>
					<xsl:copy-of select="$new"/>
				</new>
			</root>
			<xsl:result-document href="{concat(base-uri(),'.new.comp.xml')}">
				<xsl:copy-of select="$new"/>
			</xsl:result-document>
			<xsl:result-document href="{concat(base-uri(),'.old.comp.xml')}">
				<xsl:copy-of select="$old"/>
			</xsl:result-document>
		</xsl:if>
		<xsl:apply-templates select="@*|node()"/>
	</xsl:template>
	<xsl:template name="compareAttributes2">
		<xsl:param name="oldNode"/>
		<xsl:param name="newNode"/>
		<xsl:for-each select="$oldNode/@*">
			<xsl:variable name="name" select="name()"/>
			<xsl:variable name="exists" select="$newNode/@*[name()=$name]"/>
			<xsl:choose>
				<xsl:when test="$exists!=''">
					<xsl:choose>
						<xsl:when test="$exists=."/>
						<xsl:otherwise>
							<diff name="{name()}"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<diff name="{name()}"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="compareAttributes">
		<xsl:param name="oldNode"/>
		<xsl:param name="newNode"/>
		<xsl:for-each select="$oldNode/@*">
			<xsl:variable name="name" select="name()"/>
			<xsl:variable name="exists" select="$newNode/@*[name()=$name]"/>
			<xsl:choose>
				<xsl:when test="$exists!=''">
					<xsl:choose>
						<xsl:when test="$exists=."/>
						<xsl:otherwise>
							<compare name="{name()}" oldValue="{.}" newValue="{$exists}"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<compare name="{name()}" oldValue="{.}"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="*">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="altId"/>
	<xsl:template match="@id"/>
	<xsl:template match="text()">
		<xsl:text>
</xsl:text>
		<xsl:value-of select=" replace(replace(.,'\s+$',''),'^\s+','')"/>
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template match="*" mode="compare">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*|node()" mode="compare"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*" mode="compare">
		<xsl:copy/>
	</xsl:template>
</xsl:stylesheet>
