REM echo off
REM #
REM # Copyright (c) Semarchy.  All rights reserved.
REM #
REM # PRODUCT Semarchy xDI Runtime
REM #   
REM #	This script initializes some of the variables that will be used in the startup scripts of the Runtime.
REM #	It will be executed at the beginning of the following scripts:
REM #		-	startcommand.bat
REM #		-	startdelivery.bat
REM #		-	startengine.bat / stopengine.bat
REM #

IF "%XDI_RUNTIME_HOME%" == "" (
  SET "XDI_RUNTIME_HOME=%~dp0"
)

IF %XDI_RUNTIME_HOME:~-1%==\ SET XDI_RUNTIME_HOME=%XDI_RUNTIME_HOME:~0,-1%

REM # Folder containing the Runtime configuration file (defaults the 'properties' folder that is inside the Runtime directory)
if "%XDI_RUNTIME_PROPERTIES_LOCATION%" == "" set "XDI_RUNTIME_PROPERTIES_LOCATION=%XDI_RUNTIME_HOME%\properties"

REM # Path to the Runtime Configuration file (engineParameters.xml)
set "XDI_RUNTIME_CONF_FILE_LOCATION=%XDI_RUNTIME_PROPERTIES_LOCATION%\engineParameters.xml"

set "XDI_RUNTIME_LIB_HOME=%XDI_RUNTIME_HOME%\lib"
set XDI_RUNTIME_CLASSPATH=.;"%XDI_RUNTIME_PROPERTIES_LOCATION%\."

set XDI_RUNTIME_BUILD_HOME=%XDI_RUNTIME_HOME%\build\lib
set XDI_RUNTIME_BUILD_CLASSPATH=%XDI_RUNTIME_CLASSPATH%;"%XDI_RUNTIME_LIB_HOME%\internal\commons-lang3-3.19.0.jar";"%XDI_RUNTIME_LIB_HOME%\internal\commons-io-2.21.0.jar";"%XDI_RUNTIME_LIB_HOME%\internal\commons-codec-1.18.0.jar";"%XDI_RUNTIME_LIB_HOME%\internal\commons-compress-1.28.0.jar";"%XDI_RUNTIME_BUILD_HOME%\ant-1.10.15.jar";"%XDI_RUNTIME_BUILD_HOME%\ant-launcher-1.10.15.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon9b-9.1.0.8-extended.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon-s9api-9.1.0.8b.jar";"%XDI_RUNTIME_BUILD_HOME%\ant-contrib-1.0b3.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon-xpath-9.1.0.8.jar";"%XDI_RUNTIME_BUILD_HOME%\stax2-api-4.2.2.jar";"%XDI_RUNTIME_BUILD_HOME%\woodstox-core-7.0.0.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon-jdom-9.1.0.8b.jar";"%XDI_RUNTIME_BUILD_HOME%\jsqlparser-4.5.jar";"%XDI_RUNTIME_BUILD_HOME%\com.semarchy.xdi.designer.generation.jar";"%XDI_RUNTIME_BUILD_HOME%\com.indy.libraries.build.jar";"%XDI_RUNTIME_LIB_HOME%\indyEngineCoreModule.jar";"%XDI_RUNTIME_LIB_HOME%\core\indyEngineCore.jar";"%XDI_RUNTIME_LIB_HOME%\core\indyEngineShared.jar";"%XDI_RUNTIME_LIB_HOME%\internal\indyEngineCommon.jar";"%XDI_RUNTIME_LIB_HOME%\internal\indyEngine.jar";"%XDI_RUNTIME_LIB_HOME%\core\jakarta.xml.bind-api-4.0.4.jar";"%XDI_RUNTIME_LIB_HOME%\internal\HikariCP-6.3.3.jar";"%XDI_RUNTIME_LIB_HOME%\internal\guava-33.5.0-jre.jar";"%XDI_RUNTIME_LIB_HOME%\core\log4j-api-2.24.3.jar";"%XDI_RUNTIME_LIB_HOME%\core\log4j-core-2.24.3.jar";"%XDI_RUNTIME_LIB_HOME%\core\log4j-jul-2.24.3.jar";"%XDI_RUNTIME_LIB_HOME%\internal\failureaccess-1.0.3.jar";"%XDI_RUNTIME_BUILD_HOME%\org.eclipse.osgi.jar";"%XDI_RUNTIME_BUILD_HOME%\org.eclipse.emf.common.jar";"%XDI_RUNTIME_BUILD_HOME%\org.eclipse.emf.ecore.jar";"%XDI_RUNTIME_BUILD_HOME%\org.eclipse.emf.ecore.xmi.jar";"%XDI_RUNTIME_BUILD_HOME%\com.semarchy.xdi.designer.core.jar"

set XDI_RUNTIME_CLASSPATH=%XDI_RUNTIME_CLASSPATH%;"%XDI_RUNTIME_LIB_HOME%\indyEngineLauncher.jar";"%XDI_RUNTIME_LIB_HOME%\indyEngineCoreModule.jar"
set "XDI_RUNTIME_CORE=%XDI_RUNTIME_LIB_HOME%\core\**\*.jar"
set "XDI_RUNTIME_INTERNAL=%XDI_RUNTIME_LIB_HOME%\internal\*.jar"
set "XDI_RUNTIME_MODULES_PATH=%XDI_RUNTIME_HOME%\modules"

REM # Java Properties to be added in all the Runtime scripts (startengine.bat / stopengine.bat, startdelivery.bat and startcommand.bat)
set XDI_RUNTIME_VM_PROPERTIES=-Djava.util.logging.manager=org.apache.logging.log4j.jul.LogManager -Dlog4j1.compatibility=true -Dlog4j2.julLoggerAdapter=org.apache.logging.log4j.jul.CoreLoggerAdapter -Dcom.indy.engine.installation.folder="%XDI_RUNTIME_HOME%" -Dorg.quartz.properties="%XDI_RUNTIME_PROPERTIES_LOCATION%\engineScheduler.properties" -Djava.system.class.loader.disable=com.indy.engine.StambiaSystemClassLoader -Dstambia.default.classpath.name=common -Dstambia.classpath.v1.core="%XDI_RUNTIME_CORE%";"%XDI_RUNTIME_MODULES_PATH%\core\*.jar" -Dstambia.classpath.v1.internal="%XDI_RUNTIME_INTERNAL%" -Dxdi.designer.module.path.v1="%XDI_RUNTIME_MODULES_PATH%"

if "%JAVA_HOME%" == "" GOTO DEFAULT

:NORMAL
set XDI_RUNTIME_JAVA_EXE="%JAVA_HOME%\bin\java.exe"
set XDI_RUNTIME_JAVA_EXE_WITHOUT_QUOTE=%JAVA_HOME%\bin\java.exe
GOTO END

:DEFAULT
set XDI_RUNTIME_JAVA_EXE="java.exe"
set XDI_RUNTIME_JAVA_EXE_WITHOUT_QUOTE=java.exe
GOTO END

:END

REM # Update XDI_RUNTIME_VM_PROPERTIES according to java major version

set "ADD_OPEN_OPTIONS=--add-opens=java.base/java.net=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/java.lang=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/java.io=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/java.util=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/java.util.concurrent=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.naming/com.sun.jndi.ldap=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.naming/javax.naming.directory=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/java.nio=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/sun.security.ssl=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/sun.security.util=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/sun.net.www.protocol.http=ALL-UNNAMED"
set "ADD_OPEN_OPTIONS=%ADD_OPEN_OPTIONS% --add-opens=java.base/sun.net.www.http=ALL-UNNAMED"