/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.delivery.repository.google.cloud.storage.impl;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.indy.engine.core.repository.CommonDeliveryRepositoryStore;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.io.IOException;
import java.io.InputStream;

public class GoogleCloudStorage
extends CommonDeliveryRepositoryStore {
    public static final String GOOGLE_TYPE = "Google Cloud Storage";
    public static final String PROJECT_ID = "projectId";
    public static final String BUCKET_NAME = "bucket";
    public static final String PATH_ATTR = "path";
    public static final String REFRESH_DELAY = "refreshDelay";
    public static final String FILE_EXTENSION = ".deliv";
    public static final String PATH_SEPARATOR = "/";
    private String projectId = null;
    private String bucket = null;
    private String path = null;
    private Storage service;
    private long refreshDelay = 1000L;

    GoogleCloudStorage(IPluginFactory.IPluginConfiguration conf, GoogleCredentials credentials) {
        super(conf);
        this.projectId = conf.getProperty(PROJECT_ID);
        this.bucket = conf.getProperty(BUCKET_NAME);
        if (conf.getProperty(PATH_ATTR) != null && !conf.getProperty(PATH_ATTR).isEmpty() && !PATH_SEPARATOR.equals(conf.getProperty(PATH_ATTR))) {
            Object confPath = conf.getProperty(PATH_ATTR);
            if (((String)confPath).startsWith(PATH_SEPARATOR)) {
                confPath = ((String)confPath).substring(1);
            }
            if (!((String)confPath).endsWith(PATH_SEPARATOR)) {
                confPath = (String)confPath + PATH_SEPARATOR;
            }
            this.path = confPath;
        } else {
            this.path = "";
        }
        if (conf.getProperty(REFRESH_DELAY) != null) {
            this.refreshDelay = Long.parseLong(conf.getProperty(REFRESH_DELAY));
        }
        this.service = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).setProjectId(this.projectId)).build().getService();
    }

    public String getType() {
        return GOOGLE_TYPE;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPath() {
        return this.path;
    }

    public Storage getService() {
        return this.service;
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public Page<Blob> getList() {
        return this.service.list(this.bucket, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)this.path)});
    }

    public Blob createDelivery(String deliveryFileName, InputStream inputStream) throws IOException {
        if (!deliveryFileName.endsWith(FILE_EXTENSION)) {
            throw new IOException("Delivery file name must end with .deliv");
        }
        String blobName = this.getBlobPath(deliveryFileName);
        return this.service.createFrom(BlobInfo.newBuilder((String)this.bucket, (String)blobName).build(), inputStream, new Storage.BlobWriteOption[0]);
    }

    public void removeDelivery(String deliveryName) throws IOException {
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            throw new IOException("File does not end with .deliv, it is not a delivery");
        }
        String blobPath = this.getBlobPath(deliveryName);
        this.service.delete(BlobId.of((String)this.bucket, (String)blobPath));
    }

    private String getBlobPath(String deliveryName) {
        StringBuilder sb = new StringBuilder(this.path);
        if (!(PATH_SEPARATOR.equals(this.path) || this.path.isEmpty() || this.path.endsWith(PATH_SEPARATOR))) {
            sb.append(PATH_SEPARATOR);
        }
        sb.append(deliveryName);
        return sb.toString();
    }
}

