/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.common;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonNull;
import com.couchbase.client.java.json.JsonObject;
import com.stambia.couchbase.common.Messages;
import com.stambia.couchbase.common.QueryType;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class CouchbaseUtil {
    public static final char COMMA = ',';
    public static final char COLON = ':';
    public static final char QUOTE = '\"';
    public static final String ID_NODE_NAME = "id";
    public static final String INDEX_NODE_NAME = "index";
    public static final String SCORE_NODE_NAME = "score";
    public static final String CONTENT_NODE_NAME = "content";
    public static final Pattern INTEGER_PATTERN = Pattern.compile("\\d+");
    public static final String NULL = "null";
    protected static final String JSON_BACKSLASH_NOT_ESCAPED = "\\\\";
    protected static final String JSON_BACKSLASH_ESCAPED = "\\\\\\\\";
    protected static final String JSON_QUOTE_NOT_ESCAPED = "\"";
    protected static final String JSON_QUOTE_ESCAPED = "\\\\\"";
    protected static final String NO_QUERY_TYPE = Messages.getString("NO_QUERY_TYPE");
    public static final byte[] NULL_BYTES = "null".getBytes();
    public static final Set<String> QUERY_EXCLUDE_PARAMETERS = new HashSet<String>();

    static {
        QUERY_EXCLUDE_PARAMETERS.add(ID_NODE_NAME);
        QUERY_EXCLUDE_PARAMETERS.add(INDEX_NODE_NAME);
        QUERY_EXCLUDE_PARAMETERS.add(SCORE_NODE_NAME);
    }

    public static void writeJsonValue(OutputStream outputStream, byte[] key, byte[] rawValue) throws Exception {
        outputStream.write(key);
        byte[] parsedValue = rawValue == null ? NULL_BYTES : rawValue;
        outputStream.write(parsedValue);
    }

    public static String enquote(String valueString) {
        return '\"' + valueString + '\"';
    }

    public static String escapeEnquote(String string) {
        string = string.replaceAll(JSON_BACKSLASH_NOT_ESCAPED, JSON_BACKSLASH_ESCAPED).replaceAll(JSON_QUOTE_NOT_ESCAPED, JSON_QUOTE_ESCAPED);
        string = CouchbaseUtil.enquote(string);
        return string;
    }

    public static QueryType setQueryType(String rawQueryType) throws Exception {
        if (rawQueryType == null) {
            throw new Exception(NO_QUERY_TYPE);
        }
        QueryType queryType = null;
        try {
            queryType = QueryType.valueOf(rawQueryType.toUpperCase());
        }
        catch (Exception exception) {
            throw CouchbaseUtil.unknownTypeException(exception, "UNKNOWN_QUERY_TYPE", rawQueryType);
        }
        return queryType;
    }

    public static Exception unknownTypeException(Exception exception, String errorMessage, String unknownType) {
        String operationError = String.format(Messages.getString(errorMessage), unknownType);
        Exception newException = new Exception(operationError);
        newException.setStackTrace(exception.getStackTrace());
        return newException;
    }

    public static boolean isJsonValueNull(Object jsonValue) {
        return jsonValue == null || jsonValue instanceof JsonNull;
    }

    public static Object copyJsonValue(Object originalJson) {
        Object copiedJson = null;
        if (originalJson != null) {
            if (originalJson instanceof JsonObject) {
                JsonObject originalJsonObject = (JsonObject)originalJson;
                JsonObject copiedJsonObject = JsonObject.create();
                for (String key : originalJsonObject.getNames()) {
                    Object originalValue = originalJsonObject.get(key);
                    Object copiedValue = CouchbaseUtil.copyJsonValue(originalValue);
                    copiedJsonObject.put(key, copiedValue);
                }
                copiedJson = copiedJsonObject;
            } else if (originalJson instanceof JsonArray) {
                JsonArray originalJsonArray = (JsonArray)originalJson;
                int size = originalJsonArray.size();
                JsonArray copiedJsonArray = JsonArray.create((int)size);
                for (Object originalElement : originalJsonArray) {
                    Object copiedElement = CouchbaseUtil.copyJsonValue(originalElement);
                    copiedJsonArray.add(copiedElement);
                }
                copiedJson = copiedJsonArray;
            } else {
                copiedJson = originalJson;
            }
        }
        return copiedJson;
    }
}

