/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.common;

public enum Operation {
    UPSERT,
    INSERT,
    REPLACE,
    REMOVE,
    GET,
    UPDATE;

    protected static final String COUCHBASE_UPSERT_STATISTIC = "COUCHBASE_UPSERT";
    protected static final String COUCHBASE_INSERT_STATISTIC = "COUCHBASE_INSERT";
    protected static final String COUCHBASE_REPLACE_STATISTIC = "COUCHBASE_REPLACE";
    protected static final String COUCHBASE_GET_STATISTIC = "COUCHBASE_GET";
    protected static final String COUCHBASE_REMOVE_STATISTIC = "COUCHBASE_REMOVE";
    protected static final String COUCHBASE_UPDATE_STATISTIC = "COUCHBASE_UPDATE";

    public boolean isReadOnly() {
        return GET == this;
    }

    public boolean needIdOnly() {
        return this.isReadOnly() || REMOVE == this;
    }

    public String statistic() {
        String statistic = null;
        switch (this) {
            case UPSERT: {
                statistic = COUCHBASE_UPSERT_STATISTIC;
                break;
            }
            case INSERT: {
                statistic = COUCHBASE_INSERT_STATISTIC;
                break;
            }
            case REPLACE: {
                statistic = COUCHBASE_REPLACE_STATISTIC;
                break;
            }
            case REMOVE: {
                statistic = COUCHBASE_REMOVE_STATISTIC;
                break;
            }
            case GET: {
                statistic = COUCHBASE_GET_STATISTIC;
                break;
            }
            case UPDATE: {
                statistic = COUCHBASE_UPDATE_STATISTIC;
            }
        }
        return statistic;
    }
}

