/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration;

import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.Cluster;
import com.stambia.couchbase.common.CouchbaseUtil;
import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class CouchbaseIntegrator
implements Closeable {
    public static final char OBJECT_OPEN = '{';
    public static final char OBJECT_CLOSE = '}';
    public static final char ARRAY_OPEN = '[';
    public static final char ARRAY_CLOSE = ']';
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final int COUCHBASE_NEW_DATA_LEVEL = 1;
    protected static final byte[] ID_KEY = (CouchbaseUtil.enquote("id") + ':').getBytes();
    protected static final byte[] INDEX_KEY = (CouchbaseUtil.enquote("index") + ':').getBytes();
    protected static final byte[] SCORE_KEY = (CouchbaseUtil.enquote("score") + ':').getBytes();
    protected static final byte[] CONTENT_KEY = (CouchbaseUtil.enquote("content") + ':').getBytes();
    protected JsonParser jsonParser = null;
    protected Cluster cluster = null;
    protected AsyncCluster asyncCluster = null;
    protected OutputStream outputStream = null;
    protected Map<String, Number> statistics = new HashMap<String, Number>();
    protected int depthLevel = 0;

    public CouchbaseIntegrator(InputStream inputStream, Cluster cluster, OutputStream outputStream) {
        this.jsonParser = Json.createParser((InputStream)inputStream);
        this.cluster = cluster;
        this.asyncCluster = cluster != null ? cluster.async() : null;
        this.outputStream = outputStream;
        this.initializeStatistics();
    }

    public abstract void initializeStatistics();

    public abstract void updateStatistics();

    protected abstract void startObject();

    public abstract void endObject() throws Exception;

    protected abstract void keyName(String var1);

    protected abstract void valueFalse();

    protected abstract void valueTrue();

    protected abstract void valueNumber(Number var1);

    protected abstract void valueString(String var1);

    protected abstract void endArray();

    protected abstract void startArray();

    protected abstract void valueNull();

    protected abstract void finalizeIntegration() throws Exception;

    public Map<String, Number> integrate() throws Exception {
        try {
            try {
                this.outputStream.write(91);
                while (this.jsonParser.hasNext()) {
                    JsonParser.Event event = this.jsonParser.next();
                    switch (event) {
                        case START_OBJECT: {
                            ++this.depthLevel;
                            this.startObject();
                            break;
                        }
                        case END_OBJECT: {
                            --this.depthLevel;
                            this.endObject();
                            break;
                        }
                        case KEY_NAME: {
                            String key = this.jsonParser.getString();
                            this.keyName(key);
                            break;
                        }
                        case VALUE_FALSE: {
                            this.valueFalse();
                            break;
                        }
                        case VALUE_TRUE: {
                            this.valueTrue();
                            break;
                        }
                        case VALUE_NUMBER: {
                            Number valueNumber = this.jsonParser.isIntegralNumber() ? Long.valueOf(this.jsonParser.getLong()) : this.jsonParser.getBigDecimal();
                            this.valueNumber(valueNumber);
                            break;
                        }
                        case VALUE_STRING: {
                            String valueString = this.jsonParser.getString();
                            this.valueString(valueString);
                            break;
                        }
                        case END_ARRAY: {
                            this.endArray();
                            break;
                        }
                        case START_ARRAY: {
                            this.startArray();
                            break;
                        }
                        case VALUE_NULL: {
                            this.valueNull();
                        }
                    }
                }
                this.finalizeIntegration();
                this.outputStream.write(93);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            this.close();
        }
        return this.statistics;
    }

    @Override
    public void close() throws IOException {
        if (this.jsonParser != null) {
            this.jsonParser.close();
        }
    }
}

