/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.crud;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonNull;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetResult;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.common.Operation;
import com.stambia.couchbase.integration.CouchbaseIntegrator;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class CouchbaseCrudIntegrator
extends CouchbaseIntegrator {
    protected static final String ARRAY_CLOSE_ = String.valueOf(']');
    protected static final String OBJECT_CLOSE_ = String.valueOf('}');
    private static final JsonObject EMPTY_CONTENT = JsonObject.create();
    protected Operation operation = null;
    protected Collection collection = null;
    private boolean isFirstLine = true;
    private long statistic = 0L;
    private StringBuilder jsonContent = null;
    private String id = null;
    private boolean readId = false;

    public CouchbaseCrudIntegrator(InputStream inputStream, Operation operation, Cluster cluster, Collection collection, OutputStream outputStream) {
        super(inputStream, cluster, outputStream);
        this.operation = operation;
        this.collection = collection;
    }

    @Override
    public void initializeStatistics() {
    }

    @Override
    public void updateStatistics() {
        this.statistics.put(null, this.statistic);
    }

    private static void removeLastComma(StringBuilder jsonContent) {
        int lastIndex;
        if (jsonContent != null && ',' == jsonContent.charAt(lastIndex = jsonContent.length() - 1)) {
            jsonContent.deleteCharAt(lastIndex);
        }
    }

    private static void appendCloseCharacter(StringBuilder jsonContent, boolean isArray) {
        CouchbaseCrudIntegrator.removeLastComma(jsonContent);
        CouchbaseCrudIntegrator.appendWith(jsonContent, isArray ? ARRAY_CLOSE_ : OBJECT_CLOSE_, ',');
    }

    private static void appendWith(StringBuilder jsonContent, String valueString, char termination) {
        if (jsonContent != null) {
            jsonContent.append(valueString).append(termination);
        }
    }

    private void addAndWrite(String id, JsonObject inputContent) throws Exception {
        JsonObject outputContent = this.add(id, inputContent);
        if (this.isFirstLine) {
            this.isFirstLine = false;
        } else {
            this.outputStream.write(44);
        }
        this.outputStream.write(123);
        CouchbaseUtil.writeJsonValue(this.outputStream, ID_KEY, id == null ? null : CouchbaseUtil.escapeEnquote(id).getBytes());
        this.outputStream.write(44);
        CouchbaseUtil.writeJsonValue(this.outputStream, CONTENT_KEY, outputContent == null ? null : outputContent.toBytes());
        this.outputStream.write(125);
        ++this.statistic;
    }

    protected JsonObject get(String id) {
        GetResult getResult = this.collection.get(id);
        JsonObject result = getResult.contentAsObject();
        return result;
    }

    protected static Object updateJsonObject(Object originalObject, Object updateObject) {
        String updateType;
        String originalType;
        Object newObject = JsonNull.INSTANCE;
        if (CouchbaseUtil.isJsonValueNull(updateObject)) {
            newObject = CouchbaseUtil.copyJsonValue(originalObject);
        } else if (!CouchbaseUtil.isJsonValueNull(originalObject) && (originalType = originalObject.getClass().toString()).equals(updateType = updateObject.getClass().toString())) {
            if (originalObject instanceof JsonObject) {
                JsonObject originalJsonObject = (JsonObject)originalObject;
                JsonObject updateJsonObject = (JsonObject)updateObject;
                JsonObject newJsonObject = (JsonObject)CouchbaseUtil.copyJsonValue(originalJsonObject);
                for (String key : updateJsonObject.getNames()) {
                    if (!originalJsonObject.containsKey(key)) continue;
                    Object originalChild = originalJsonObject.get(key);
                    Object updateChild = updateJsonObject.get(key);
                    Object newChild = CouchbaseCrudIntegrator.updateJsonObject(originalChild, updateChild);
                    newJsonObject.put(key, newChild);
                }
                newObject = newJsonObject;
            } else if (originalObject instanceof JsonArray) {
                Object originalElement;
                JsonArray originalJsonArray = (JsonArray)originalObject;
                JsonArray updateJsonArray = (JsonArray)updateObject;
                int originalSize = originalJsonArray.size();
                JsonArray newJsonArray = JsonArray.create((int)originalSize);
                int updateSize = updateJsonArray.size();
                int minimalSize = Math.min(originalSize, updateSize);
                int elementIndex = 0;
                while (elementIndex < minimalSize) {
                    originalElement = originalJsonArray.get(elementIndex);
                    Object updateElement = updateJsonArray.get(elementIndex);
                    Object newElement = CouchbaseCrudIntegrator.updateJsonObject(originalElement, updateElement);
                    newJsonArray.add(newElement);
                    ++elementIndex;
                }
                if (originalSize > updateSize) {
                    elementIndex = minimalSize;
                    while (elementIndex < originalSize) {
                        originalElement = originalJsonArray.get(elementIndex);
                        Object newElement = CouchbaseUtil.copyJsonValue(originalElement);
                        newJsonArray.add(newElement);
                        ++elementIndex;
                    }
                }
                newObject = newJsonArray;
            } else {
                newObject = updateObject;
            }
        }
        return newObject;
    }

    protected abstract JsonObject add(String var1, JsonObject var2) throws Exception;

    @Override
    protected void startObject() {
        if (1 < this.depthLevel && this.jsonContent != null) {
            this.jsonContent.append('{');
        }
    }

    @Override
    public void endObject() throws Exception {
        if (this.operation.needIdOnly()) {
            this.addAndWrite(this.id, null);
        } else if (1 <= this.depthLevel) {
            CouchbaseCrudIntegrator.appendCloseCharacter(this.jsonContent, false);
            if (1 == this.depthLevel && this.jsonContent != null) {
                CouchbaseCrudIntegrator.removeLastComma(this.jsonContent);
                JsonObject content = JsonObject.fromJson((String)this.jsonContent.toString());
                this.addAndWrite(this.id, content);
            }
        } else if (this.id != null && this.jsonContent == null) {
            this.addAndWrite(this.id, EMPTY_CONTENT);
        }
    }

    @Override
    protected void keyName(String key) {
        if (1 == this.depthLevel) {
            this.readId = "id".equals(key);
            if ("content".equals(key)) {
                this.jsonContent = new StringBuilder();
            }
        } else if (1 < this.depthLevel) {
            CouchbaseCrudIntegrator.appendWith(this.jsonContent, CouchbaseUtil.enquote(key), ':');
        }
    }

    @Override
    protected void valueFalse() {
        CouchbaseCrudIntegrator.appendWith(this.jsonContent, "false", ',');
    }

    @Override
    protected void valueTrue() {
        CouchbaseCrudIntegrator.appendWith(this.jsonContent, "true", ',');
    }

    @Override
    protected void valueNumber(Number valueNumber) {
        CouchbaseCrudIntegrator.appendWith(this.jsonContent, valueNumber.toString(), ',');
    }

    @Override
    protected void valueString(String valueString) {
        if (1 == this.depthLevel && this.readId) {
            this.id = valueString;
        } else if (1 < this.depthLevel) {
            CouchbaseCrudIntegrator.appendWith(this.jsonContent, CouchbaseUtil.escapeEnquote(valueString), ',');
        }
    }

    @Override
    protected void endArray() {
        if (1 < this.depthLevel) {
            CouchbaseCrudIntegrator.appendCloseCharacter(this.jsonContent, true);
        }
    }

    @Override
    protected void startArray() {
        if (1 < this.depthLevel && this.jsonContent != null) {
            this.jsonContent.append('[');
        }
    }

    @Override
    protected void valueNull() {
        CouchbaseCrudIntegrator.appendWith(this.jsonContent, "null", ',');
    }

    @Override
    protected void finalizeIntegration() throws Exception {
        this.updateStatistics();
    }
}

