/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.crud;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonObject;
import com.stambia.couchbase.common.Operation;
import com.stambia.couchbase.integration.crud.CouchbaseCrudIntegrator;
import java.io.InputStream;
import java.io.OutputStream;

public final class CouchbaseCrudIntegratorNoTransaction
extends CouchbaseCrudIntegrator {
    public CouchbaseCrudIntegratorNoTransaction(InputStream inputStream, Operation operation, Cluster cluster, Collection collection, OutputStream outputStream) {
        super(inputStream, operation, cluster, collection, outputStream);
    }

    @Override
    protected final JsonObject add(String id, JsonObject content) {
        JsonObject result = content;
        switch (this.operation) {
            case GET: {
                result = this.get(id);
                break;
            }
            case REMOVE: {
                this.collection.remove(id);
                break;
            }
            case UPSERT: {
                this.collection.upsert(id, (Object)content);
                break;
            }
            case INSERT: {
                this.collection.insert(id, (Object)content);
                break;
            }
            case REPLACE: {
                this.collection.replace(id, (Object)content);
                break;
            }
            case UPDATE: {
                JsonObject document = this.get(id);
                Object updated = CouchbaseCrudIntegratorNoTransaction.updateJsonObject(document, content);
                if (updated == null || !(updated instanceof JsonObject)) break;
                result = (JsonObject)updated;
                this.collection.replace(id, (Object)result);
            }
        }
        return result;
    }
}

