/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.query;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.result.SearchMetrics;
import com.couchbase.client.java.search.result.SearchResult;
import com.couchbase.client.java.search.result.SearchRow;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.common.FtsParameter;
import com.stambia.couchbase.common.QueryType;
import com.stambia.couchbase.common.handler.query.FtsUtil;
import com.stambia.couchbase.common.handler.query.QueryHandler;
import com.stambia.couchbase.integration.query.CouchbaseQueryIntegrator;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class CouchbaseFtsIntegrator
extends CouchbaseQueryIntegrator
implements QueryHandler<SearchRow> {
    public static final String TOOK_NS = "TOOK_NS";
    public static final String TOTAL_ROWS = "TOTAL_ROWS";
    public static final String SUCCESS_PARTITION_COUNT = "SUCCESS_PARTITION_COUNT";
    public static final String ERROR_PARTITION_COUNT = "ERROR_PARTITION_COUNT";
    public static final String TOTAL_PARTITION_COUNT = "TOTAL_PARTITION_COUNT";
    private String searchIndex = null;
    private QueryType queryType = null;
    private SearchOptions ftsOptions = null;
    private List<SearchRow> ftsRows = null;
    private SearchResult ftsResult = null;
    private FtsParameter ftsParameter = null;
    private SearchRow ftsRow = null;

    public CouchbaseFtsIntegrator(InputStream inputStream, String searchIndex, QueryType queryType, String fields, String queryString, Duration timeout, Cluster cluster, OutputStream outputStream) {
        super(inputStream, queryString, timeout, cluster, outputStream);
        this.searchIndex = searchIndex;
        this.queryType = queryType;
        this.ftsOptions = FtsUtil.getFtsOptions(fields);
        if (timeout != null) {
            this.ftsOptions = (SearchOptions)this.ftsOptions.timeout(timeout);
        }
    }

    @Override
    public void initializeStatistics() {
        this.statistics.put(TOOK_NS, 0);
        this.statistics.put(TOTAL_ROWS, 0L);
        this.statistics.put(SUCCESS_PARTITION_COUNT, 0L);
        this.statistics.put(ERROR_PARTITION_COUNT, 0L);
        this.statistics.put(TOTAL_PARTITION_COUNT, 0L);
    }

    @Override
    public void updateStatistics() {
        int oldTook = (Integer)((Number)this.statistics.get(TOOK_NS));
        long oldTotalRows = (Long)((Number)this.statistics.get(TOTAL_ROWS));
        long oldSuccessPartitionCount = (Long)((Number)this.statistics.get(SUCCESS_PARTITION_COUNT));
        long oldErrorPartitionCount = (Long)((Number)this.statistics.get(ERROR_PARTITION_COUNT));
        long oldTotalPartitionCount = (Long)((Number)this.statistics.get(TOTAL_PARTITION_COUNT));
        SearchMetrics ftsMetrics = this.ftsResult.metaData().metrics();
        int newTook = ftsMetrics.took().getNano();
        long newTotalRows = ftsMetrics.totalRows();
        long newSuccessPartitionCount = ftsMetrics.successPartitionCount();
        long newErrorPartitionCount = ftsMetrics.errorPartitionCount();
        long newTotalPartitionCount = ftsMetrics.totalPartitionCount();
        this.statistics.put(TOOK_NS, oldTook + newTook);
        this.statistics.put(TOTAL_ROWS, oldTotalRows + newTotalRows);
        this.statistics.put(SUCCESS_PARTITION_COUNT, oldSuccessPartitionCount + newSuccessPartitionCount);
        this.statistics.put(ERROR_PARTITION_COUNT, oldErrorPartitionCount + newErrorPartitionCount);
        this.statistics.put(TOTAL_PARTITION_COUNT, oldTotalPartitionCount + newTotalPartitionCount);
    }

    @Override
    public List<SearchRow> getQueryRows() {
        return this.ftsRows;
    }

    @Override
    public void processQueryRow(SearchRow queryRow) throws Exception {
        this.ftsRow = queryRow;
        if (this.isFirstLine) {
            this.isFirstLine = false;
        } else {
            this.outputStream.write(44);
        }
        this.outputStream.write(123);
        this.outputStream.write(DOCUMENT_KEY);
        this.outputStream.write(123);
        this.processQueryValue();
        this.outputStream.write(125);
        this.outputStream.write(125);
    }

    @Override
    public void putSpecificParameter(String rawValue) {
        if (1 == this.depthLevel && this.ftsParameter != null && rawValue != null) {
            int intValue = Integer.valueOf(rawValue);
            switch (this.ftsParameter) {
                case SKIP: {
                    this.ftsOptions.skip(intValue);
                    break;
                }
                case LIMIT: {
                    this.ftsOptions.limit(intValue);
                }
            }
        }
    }

    @Override
    public void processQueryValue() throws Exception {
        String id = this.ftsRow.id();
        CouchbaseUtil.writeJsonValue(this.outputStream, ID_KEY, id == null ? null : CouchbaseUtil.escapeEnquote(id).getBytes());
        this.outputStream.write(44);
        String resultIndex = this.ftsRow.index();
        CouchbaseUtil.writeJsonValue(this.outputStream, INDEX_KEY, resultIndex == null ? null : CouchbaseUtil.enquote(resultIndex).getBytes());
        this.outputStream.write(44);
        double score = this.ftsRow.score();
        CouchbaseUtil.writeJsonValue(this.outputStream, SCORE_KEY, String.valueOf(score).getBytes());
        this.outputStream.write(44);
        JsonObject outputContent = (JsonObject)this.ftsRow.fieldsAs(JsonObject.class);
        CouchbaseUtil.writeJsonValue(this.outputStream, CONTENT_KEY, outputContent == null ? null : outputContent.toBytes());
    }

    @Override
    protected String escapeValue(String value) {
        return value;
    }

    @Override
    protected void processRequest(String parametrizedQueryString) {
        this.ftsResult = FtsUtil.runFtsQuery(this.queryType, parametrizedQueryString, this.cluster, this.searchIndex, this.ftsOptions);
        this.ftsRows = this.ftsResult.rows();
    }

    @Override
    public void specificKeyName(String key) {
        this.ftsParameter = FtsParameter.fromString(key);
    }

    @Override
    public void endObject() throws Exception {
        if (1 == this.depthLevel) {
            String parametrizedQueryString = this.rawQueryString;
            if (!this.parameters.isEmpty()) {
                for (Map.Entry parameter : this.parameters.entrySet()) {
                    String name = (String)parameter.getKey();
                    String value = (String)parameter.getValue();
                    value = this.escapeValue(value);
                    parametrizedQueryString = this.parametrizedQuery(parametrizedQueryString, name, value);
                }
            }
            this.parameters.clear();
            this.runOnceOrMore = true;
            this.processRequest(parametrizedQueryString);
            this.processQueryRows();
            this.updateStatistics();
        }
    }

    @Override
    protected void finalizeIntegration() throws Exception {
        if (!this.runOnceOrMore) {
            this.processRequest(this.rawQueryString);
            this.processQueryRows();
            this.updateStatistics();
        }
    }
}

