/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.query.n1ql;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetrics;
import com.couchbase.client.java.query.QueryResult;
import com.stambia.couchbase.common.handler.query.QueryHandler;
import com.stambia.couchbase.integration.query.CouchbaseQueryIntegrator;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class CouchbaseN1qlIntegrator
extends CouchbaseQueryIntegrator
implements QueryHandler<JsonObject> {
    private static final String QUOTE = "'";
    private static final String ESCAPED_QUOTE = "''";
    public static final String ELAPSED_TIME = "ELAPSED_TIME";
    public static final String ERROR_COUNT = "ERROR_COUNT";
    public static final String EXECUTION_TIME = "EXECUTION_TIME";
    public static final String MUTATION_COUNT = "MUTATION_COUNT";
    public static final String RESULT_COUNT = "RESULT_COUNT";
    public static final String RESULT_SIZE = "RESULT_SIZE";
    public static final String SORT_COUNT = "SORT_COUNT";
    public static final String WARNING_COUNT = "WARNING_COUNT";
    protected JsonObject n1qlRow = null;
    private List<JsonObject> n1qlRows = null;
    private QueryResult n1qlResult = null;

    public CouchbaseN1qlIntegrator(InputStream inputStream, String queryString, Duration timeout, Cluster cluster, OutputStream outputStream) {
        super(inputStream, queryString, timeout, cluster, outputStream);
    }

    @Override
    public void initializeStatistics() {
        this.statistics.put(ELAPSED_TIME, 0);
        this.statistics.put(ERROR_COUNT, 0L);
        this.statistics.put(EXECUTION_TIME, 0);
        this.statistics.put(MUTATION_COUNT, 0L);
        this.statistics.put(RESULT_COUNT, 0L);
        this.statistics.put(RESULT_SIZE, 0L);
        this.statistics.put(SORT_COUNT, 0L);
        this.statistics.put(WARNING_COUNT, 0L);
    }

    @Override
    public void updateStatistics() {
        int oldElapsedTime = (Integer)((Number)this.statistics.get(ELAPSED_TIME));
        long oldErrorCount = (Long)((Number)this.statistics.get(ERROR_COUNT));
        int oldExecutionTime = (Integer)((Number)this.statistics.get(EXECUTION_TIME));
        long oldMutationCount = (Long)((Number)this.statistics.get(MUTATION_COUNT));
        long oldResultCount = (Long)((Number)this.statistics.get(RESULT_COUNT));
        long oldResultSize = (Long)((Number)this.statistics.get(RESULT_SIZE));
        long oldSortCount = (Long)((Number)this.statistics.get(SORT_COUNT));
        long oldWarningCount = (Long)((Number)this.statistics.get(WARNING_COUNT));
        Optional optionalMetrics = this.n1qlResult.metaData().metrics();
        if (optionalMetrics.isPresent()) {
            QueryMetrics n1qlMetrics = (QueryMetrics)optionalMetrics.get();
            int newElapsedTime = n1qlMetrics.elapsedTime().getNano();
            long newErrorCount = n1qlMetrics.errorCount();
            int newExecutionTime = n1qlMetrics.executionTime().getNano();
            long newMutationCount = n1qlMetrics.mutationCount();
            long newResultCount = n1qlMetrics.resultCount();
            long newResultSize = n1qlMetrics.resultSize();
            long newSortCount = n1qlMetrics.sortCount();
            long newWarningCount = n1qlMetrics.warningCount();
            this.statistics.put(ELAPSED_TIME, oldElapsedTime + newElapsedTime);
            this.statistics.put(ERROR_COUNT, oldErrorCount + newErrorCount);
            this.statistics.put(EXECUTION_TIME, oldExecutionTime + newExecutionTime);
            this.statistics.put(MUTATION_COUNT, oldMutationCount + newMutationCount);
            this.statistics.put(RESULT_COUNT, oldResultCount + newResultCount);
            this.statistics.put(RESULT_SIZE, oldResultSize + newResultSize);
            this.statistics.put(SORT_COUNT, oldSortCount + newSortCount);
            this.statistics.put(WARNING_COUNT, oldWarningCount + newWarningCount);
        }
    }

    @Override
    public List<JsonObject> getQueryRows() {
        return this.n1qlRows;
    }

    @Override
    protected void keyName(String key) {
        if (1 < this.depthLevel) {
            this.key = key;
        }
    }

    @Override
    public void putSpecificParameter(String rawValue) {
    }

    @Override
    protected String escapeValue(String value) {
        value = value.replaceAll(QUOTE, ESCAPED_QUOTE);
        return value;
    }

    @Override
    protected void processRequest(String parametrizedQueryString) throws Exception {
        this.n1qlResult = (QueryResult)this.asyncCluster.query(parametrizedQueryString, this.queryOptions).get();
        this.n1qlRows = this.n1qlResult.rowsAsObject();
    }

    @Override
    public void specificKeyName(String key) {
    }

    @Override
    public void endObject() throws Exception {
        if (1 == this.depthLevel) {
            String parametrizedQueryString = this.rawQueryString;
            if (!this.parameters.isEmpty()) {
                for (Map.Entry parameter : this.parameters.entrySet()) {
                    String name = (String)parameter.getKey();
                    String value = (String)parameter.getValue();
                    value = this.escapeValue(value);
                    parametrizedQueryString = this.parametrizedQuery(parametrizedQueryString, name, value);
                }
            }
            this.parameters.clear();
            this.runOnceOrMore = true;
            this.processRequest(parametrizedQueryString);
            this.processQueryRows();
            this.updateStatistics();
        }
    }

    @Override
    protected void finalizeIntegration() throws Exception {
        if (!this.runOnceOrMore) {
            this.processRequest(this.rawQueryString);
            this.processQueryRows();
            this.updateStatistics();
        }
    }
}

