/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.query.n1ql.json;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.json.JsonObject;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.integration.query.n1ql.CouchbaseN1qlIntegrator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;

public abstract class CouchbaseN1qlJsonIntegrator
extends CouchbaseN1qlIntegrator {
    protected static final String JSON_ID_SEPARATOR = ".";
    protected static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";
    protected static final String INCREMENT_FORMAT = "%09d";
    protected static final String EMPTY_FILE_PREFIX = "";
    protected static long LAST_TIMESTAMP = 0L;
    protected static int LAST_INCEREMENT = 0;

    public CouchbaseN1qlJsonIntegrator(InputStream inputStream, String queryString, Duration timeout, Cluster cluster, OutputStream outputStream) {
        super(inputStream, queryString, timeout, cluster, outputStream);
    }

    @Override
    public void processQueryRow(JsonObject queryRow) throws Exception {
        this.n1qlRow = queryRow;
        this.processQueryValue();
    }

    protected void writeJson(OutputStream jsonFileStream) throws Exception {
        byte[] rawData = this.n1qlRow == null ? CouchbaseUtil.NULL_BYTES : this.n1qlRow.toBytes();
        jsonFileStream.write(rawData == null ? CouchbaseUtil.NULL_BYTES : rawData);
    }

    protected static synchronized String getFileName(String exportFolder, String exportedFilesPrefix, String extension) throws Exception {
        String prefix = exportedFilesPrefix == null || exportedFilesPrefix.trim().isEmpty() ? EMPTY_FILE_PREFIX : exportedFilesPrefix + JSON_ID_SEPARATOR;
        long timestamp = Instant.now().toEpochMilli();
        int increment = timestamp == LAST_TIMESTAMP ? LAST_INCEREMENT + 1 : 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String dateSuffix = dateFormat.format(new Date(new Timestamp(timestamp).getTime()));
        String incrementSuffix = String.format(INCREMENT_FORMAT, increment);
        String suffix = dateSuffix + incrementSuffix;
        String fileName = exportFolder + File.separator + prefix + suffix + extension;
        LAST_TIMESTAMP = timestamp;
        LAST_INCEREMENT = increment;
        return fileName;
    }
}

