/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.transformation.crud;

import com.couchbase.client.java.Collection;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.common.Messages;
import com.stambia.couchbase.common.Operation;
import com.stambia.couchbase.integration.crud.CouchbaseCrudIntegrator;
import com.stambia.couchbase.integration.crud.CouchbaseCrudIntegratorNoTransaction;
import com.stambia.couchbase.integration.crud.CouchbaseCrudIntegratorWithTransaction;
import com.stambia.couchbase.transformation.CouchbaseTransformer;
import java.util.Map;

public class CouchbaseCrudTransformer
extends CouchbaseTransformer {
    protected static final String COUCHBASE_OPERATION = "couchbaseOperation";
    protected static final String BATCH_SIZE = "batchSize";
    private static final String NO_OPERATION = Messages.getString("NO_OPERATION");

    @Override
    public void integrate() throws Exception {
        String rawBatchSize = this.getProperty(BATCH_SIZE);
        int batchSize = rawBatchSize != null && CouchbaseUtil.INTEGER_PATTERN.matcher(rawBatchSize).matches() ? Integer.valueOf(rawBatchSize) : 0;
        String couchbaseOperation = this.getProperty(COUCHBASE_OPERATION);
        if (couchbaseOperation == null) {
            throw new Exception(NO_OPERATION);
        }
        Operation operation = null;
        try {
            operation = Operation.valueOf(couchbaseOperation.toUpperCase());
        }
        catch (Exception exception) {
            throw CouchbaseUtil.unknownTypeException(exception, "UNKNOWN_OPERATION", couchbaseOperation);
        }
        Collection collection = this.cluster.bucket(this.bucketName).scope(this.scopeName).collection(this.collectionName);
        CouchbaseCrudIntegrator couchbaseCrudIntegrator = this.transactionalMode ? new CouchbaseCrudIntegratorWithTransaction(this.inputStream, operation, this.cluster, collection, this.outputStream, batchSize) : new CouchbaseCrudIntegratorNoTransaction(this.inputStream, operation, this.cluster, collection, this.outputStream);
        Map<String, Number> statistics = couchbaseCrudIntegrator.integrate();
        OutputStreamTransformer.OutputStreamTransformerStatisticHandler statHandler = this.getStatisticHandler();
        String statisticName = operation.statistic();
        long statisticNumber = (Long)statistics.get(null);
        statHandler.handle(statisticName, statisticNumber);
    }
}

