/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.transformation.query;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.common.QueryType;
import com.stambia.couchbase.integration.query.CouchbaseFtsIntegrator;
import com.stambia.couchbase.integration.query.CouchbaseQueryIntegrator;
import com.stambia.couchbase.transformation.query.CouchbaseQueryTransformer;
import java.time.Duration;
import java.util.Map;

public class CouchbaseFtsTransformer
extends CouchbaseQueryTransformer {
    protected static final String QUERY_TYPE = "queryType";
    protected static final String FIELDS = "fields";
    protected static final String INDEX = "index";
    private String searchIndex = null;
    private QueryType queryType = null;
    private String rawFields = null;

    @Override
    protected void getExtraProperties() throws Exception {
        super.getExtraProperties();
        this.searchIndex = this.getProperty(INDEX);
        String rawQueryType = this.getProperty(QUERY_TYPE);
        this.queryType = CouchbaseUtil.setQueryType(rawQueryType);
        this.rawFields = this.getProperty(FIELDS);
    }

    @Override
    public CouchbaseQueryIntegrator setQueryIntegrator(String queryString, Duration timeout) {
        CouchbaseFtsIntegrator couchbaseFtsIntegrator = new CouchbaseFtsIntegrator(this.inputStream, this.searchIndex, this.queryType, this.rawFields, queryString, timeout, this.cluster, this.outputStream);
        return couchbaseFtsIntegrator;
    }

    @Override
    protected void handleStatistics(OutputStreamTransformer.OutputStreamTransformerStatisticHandler statisticHandler, Map<String, Number> statistics) throws Exception {
        int took = (Integer)statistics.get("TOOK_NS");
        long totalRows = (Long)statistics.get("TOTAL_ROWS");
        long successPartitionCount = (Long)statistics.get("SUCCESS_PARTITION_COUNT");
        long errorPartitionCount = (Long)statistics.get("ERROR_PARTITION_COUNT");
        long totalPartitionCount = (Long)statistics.get("TOTAL_PARTITION_COUNT");
        statisticHandler.handle("TOOK_NS", (long)took);
        statisticHandler.handle("TOTAL_ROWS", totalRows);
        statisticHandler.handle("SUCCESS_PARTITION_COUNT", successPartitionCount);
        statisticHandler.handle("ERROR_PARTITION_COUNT", errorPartitionCount);
        statisticHandler.handle("TOTAL_PARTITION_COUNT", totalPartitionCount);
    }
}

