/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.transformation.query;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.integration.query.CouchbaseQueryIntegrator;
import com.stambia.couchbase.transformation.CouchbaseTransformer;
import java.time.Duration;
import java.util.Map;

public abstract class CouchbaseQueryTransformer
extends CouchbaseTransformer {
    private static final String TIMEOUT_MS = "timeoutMs";
    protected static final String QUERYSTRING = "queryString";
    private String queryString;
    private Duration timeout;

    @Override
    public void integrate() throws Exception {
        this.getExtraProperties();
        CouchbaseQueryIntegrator queryIntegrator = this.setQueryIntegrator(this.queryString, this.timeout);
        Map<String, Number> statistics = queryIntegrator.integrate();
        OutputStreamTransformer.OutputStreamTransformerStatisticHandler statisticHandler = this.getStatisticHandler();
        this.handleStatistics(statisticHandler, statistics);
    }

    protected void getExtraProperties() throws Exception {
        this.queryString = this.getProperty(QUERYSTRING);
        String rawTimeoutMs = this.getProperty(TIMEOUT_MS);
        int timoutMs = rawTimeoutMs != null && CouchbaseUtil.INTEGER_PATTERN.matcher(rawTimeoutMs).matches() ? Integer.valueOf(rawTimeoutMs) : 0;
        this.timeout = timoutMs > 0 ? Duration.ofMillis(timoutMs) : null;
    }

    public abstract CouchbaseQueryIntegrator setQueryIntegrator(String var1, Duration var2) throws Exception;

    protected abstract void handleStatistics(OutputStreamTransformer.OutputStreamTransformerStatisticHandler var1, Map<String, Number> var2) throws Exception;
}

