/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.snowflake.runtime;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.component.snowflake.runtime.Messages;
import com.semarchy.xdi.component.snowflake.runtime.SnowpipeStreamingChannelHandler;
import com.semarchy.xdi.component.snowflake.runtime.SnowpipeStreamingChannelHandlerBuilder;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.logging.log4j.LogManager;

public class SnowpipeStreamingActionCodeI
extends ActionCodeTypeI {
    String accountUrl;
    String user;
    String privateKeyPath;
    ISecretValue privateKeyPassword;
    private String targetTableName;
    private String targetSchemaName;
    private String targetDbName;
    private String channelName;
    private OnErrorBehavior onErrorBehavior;
    private boolean processErrors = false;
    private SnowpipeStreamingChannelHandler channelHandler;
    private Integer batchSize;
    private String offsetColumnName;
    private OffsetTokenComparison offsetTokenComparison;
    private IPreparedStatementToResultSet errorPreparedStatement;
    private String privateKeyPasswordUncrypted;

    public SnowpipeStreamingActionCodeI() {
        super("Snowpipe Streaming", true);
        this.actionClassName = "SnowpipeStreamingActionCodeI";
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    public int executeSimpleCode() throws EngineExceptionI {
        throw new EngineExceptionI(Messages.getString("SnowpipeStreamingActionCodeI.0"));
    }

    public int prepareDirectBindedFetch(ResultSet sourceRSet) throws EngineExceptionI {
        this.setStandardConnectionParameters(sourceRSet);
        this.accountUrl = this.getLocalStringBindedParameter(sourceRSet, "SNOWFLAKE_ACCOUNT_URL");
        this.user = this.getLocalStringBindedParameter(sourceRSet, "SNOWPIPE_USER");
        this.privateKeyPath = this.getLocalStringBindedParameter(sourceRSet, "PRIVATE_KEY_PATH");
        this.privateKeyPassword = this.getLocalSecretBindedParameter(sourceRSet, "PRIVATE_KEY_PASSWORD", null);
        this.targetTableName = this.getLocalStringBindedParameter(sourceRSet, "TARGET_TABLE_NAME");
        this.channelName = this.getLocalStringBindedParameter(sourceRSet, "SNOWPIPE_CHANNEL_NAME", "Semarchy xDI Channel");
        this.onErrorBehavior = OnErrorBehavior.parse(this.getLocalStringBindedParameter(sourceRSet, "ON_ERROR_BEHAVIOR", "Abort Execution"));
        this.batchSize = this.getLocalIntegerBindedParameter(sourceRSet, "BATCH_SIZE", 1000);
        this.targetSchemaName = this.getLocalStringBindedParameter(sourceRSet, "TARGET_SCHEMA_NAME");
        this.targetDbName = this.getLocalStringBindedParameter(sourceRSet, "TARGET_DB_NAME");
        this.offsetColumnName = this.getLocalStringBindedParameter(sourceRSet, "OFFSET_TOKEN_COLUMN_NAME", "SNOWPIPE_OFFSET_TOKEN");
        this.offsetTokenComparison = OffsetTokenComparison.parse(this.getLocalStringBindedParameter(sourceRSet, "OFFSET_TOKEN_COMPARISON", "Enable"));
        this.processErrors = this.onErrorBehavior == OnErrorBehavior.CONTINUE_EXECUTION;
        this.connectionName = this.getLocalStringBindedParameter(sourceRSet, "SQL_CONNECTION", "");
        this.privateKeyPasswordUncrypted = (String)this.secret((ISecretStatement)new ISecretStatement<String>(){

            public String execute(ISecretContext context) throws Throwable {
                return SnowpipeStreamingActionCodeI.this.privateKeyPassword.decryptString(context);
            }
        });
        return 0;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws Exception {
        int ret = 0;
        if (this.processErrors && !this.getActionContext().isSrcBindedAction()) {
            throw new EngineExceptionI(Messages.getString("SnowpipeStreamingActionCodeI.1"));
        }
        if (this.processErrors) {
            this.errorPreparedStatement = (IPreparedStatementToResultSet)this.getActionContext().createBindePreparedStatement();
            this.getActionContext().bindWithTarget(this.errorPreparedStatement.getNotFetchedResultSetBindI());
        }
        this.channelHandler = new SnowpipeStreamingChannelHandlerBuilder().setAccountUrl(this.accountUrl).setUser(this.user).setPrivateKeyPath(this.privateKeyPath).setPrivateKeyPassword(this.privateKeyPasswordUncrypted).setTargetTableName(this.targetTableName).setTargetSchemaName(this.targetSchemaName).setTargetDatabase(this.targetDbName).setOnErrorBehavior(this.onErrorBehavior).setChannelName(this.channelName).setBatchSize(this.batchSize).setOffsetColumnName(this.offsetColumnName).setStatisticPublisher(entry -> this.publishStatistic(entry.name(), entry.value(), false)).setVariablePublisher(entry -> this.publishVariable(entry.name(), entry.value(), entry.type())).setErrorPreparedStatement(this.errorPreparedStatement).setOffsetComparison(this.offsetTokenComparison).build();
        ret = this.channelHandler.processResultSet(sourceRSet, sourceRSMD);
        return ret;
    }

    public boolean isBindedAction() {
        return this.actionContext.isTrgBindedAction();
    }

    public int finalizeExecuteCode() throws EngineExceptionI {
        try {
            this.channelHandler.close();
        }
        catch (Exception e) {
            this.logger.warn("Error while closing Snowpipe Streaming Channel Handler", (Throwable)e);
        }
        return 0;
    }

    protected static enum OffsetTokenComparison {
        ENABLE,
        DISABLE;


        public static OffsetTokenComparison parse(String displayName) {
            return switch (displayName) {
                case "Enable" -> ENABLE;
                case "Disable" -> DISABLE;
                default -> ENABLE;
            };
        }
    }

    protected static enum OnErrorBehavior {
        ABORT_EXECUTION,
        CONTINUE_EXECUTION;


        public static OnErrorBehavior parse(String displayName) {
            return switch (displayName) {
                case "Abort Execution" -> ABORT_EXECUTION;
                case "Continue Execution" -> CONTINUE_EXECUTION;
                default -> ABORT_EXECUTION;
            };
        }
    }
}

