/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.google.wizard;

import com.indy.addons.AttributeUtil;
import com.indy.addons.google.wizard.CredentialBean;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.tech.provider.wizard.IBeanLinker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeanMdLinker
implements IBeanLinker {
    private MdNode node;
    private CredentialBean credentialBean = new CredentialBean();
    private final Logger logger = LogManager.getLogger(this.getClass());

    public void setNode(MdNode node) {
        this.node = node;
        this.setCredential();
    }

    private void setCredential() {
        List<? extends MdNode> resultNodes = this.getCredentials(true);
        if (resultNodes == null || resultNodes.isEmpty()) {
            resultNodes = this.getCredentials(false);
        }
        if (resultNodes != null && !resultNodes.isEmpty()) {
            MdNode node = resultNodes.get(0);
            this.credentialBean.setCredential(node);
        }
    }

    private List<? extends MdNode> getCredentials(boolean plural) {
        List resultNodes = null;
        try {
            Object evalResult = this.node.evaluateMdSet("@credential" + (plural ? "s" : "") + "/internal:getRef()");
            if (evalResult != null) {
                resultNodes = (List)evalResult;
            }
        }
        catch (XPathExpressionException e) {
            this.logger.warn("Unable to evaluate xpath expression", (Throwable)e);
        }
        return resultNodes;
    }

    public CredentialBean getBean() {
        return this.credentialBean;
    }

    public MdNode updateMdNode() throws Exception {
        MdNode dummyNode = this.node.copy(0);
        dummyNode.setName(dummyNode.getName());
        dummyNode.setSubstituteContainer(this.node.getSubstituteContainer());
        AttributeUtil.setAttribute((String)"credential", (Object)this.credentialBean.credential, (MdNode)dummyNode, (MdNode)this.node);
        HashMap<MdNode, MdNode> reversedObject = new HashMap<MdNode, MdNode>();
        reversedObject.put(dummyNode, this.node);
        IncrementalReverser ir = new IncrementalReverser(this.node.eContainer(), reversedObject, new ArrayList(), false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
        return dummyNode;
    }

    public List<MdNode> refreshCredentialPickerViewer() {
        ArrayList<MdNode> credentialNodes = new ArrayList<MdNode>();
        try {
            Collection credentialCollection = (Collection)this.node.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_GOOGLE_CREDENTIALS_REF");
            if (credentialCollection != null) {
                credentialNodes.addAll(credentialCollection);
            }
        }
        catch (XPathExpressionException e) {
            this.logger.warn("Unable to evaluate xpath expression", (Throwable)e);
        }
        return credentialNodes;
    }
}

