/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.google.wizard;

import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.addons.google.wizard.BeanMdLinker;
import com.indy.addons.google.wizard.Messages;
import com.stambia.md.MdNode;
import com.stambia.md.impl.MdNodeImpl;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CredentialsPage
extends WizardPage {
    private BeanMdLinker linker;
    private ComboViewer credentialPickerViewer;

    public CredentialsPage(BeanMdLinker linker) {
        super(Messages.GoogleCredentialsPage_0);
        this.setTitle(Messages.GoogleCredentialsPage_0);
        this.linker = linker;
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite((Composite)parent);
        Composite main = new Composite((Composite)scrolled, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new GridLayout(1, false));
        this.createContent(main);
        ScrolledCompositeWizardHelper.adaptToContent((ScrolledComposite)scrolled, (Composite)main);
        this.setControl((Control)scrolled);
        this.hookListeners();
    }

    private void createContent(Composite parent) {
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(4, 1, true, false));
        l.setText(Messages.GoogleCredentialsPage_1);
        l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(4, 1, true, false));
        l.setText(Messages.GoogleCredentialsPage_2);
        Group g = new Group(parent, 0);
        g.setLayoutData((Object)new GridData(4, 1, true, false));
        g.setLayout((Layout)new GridLayout(2, false));
        g.setText(Messages.GoogleCredentialsPage_3);
        this.credentialPickerViewer = new ComboViewer((Composite)g, 8);
        this.credentialPickerViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
        this.credentialPickerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.credentialPickerViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                MdNode mdNode = (MdNode)element;
                return mdNode.getName();
            }
        });
        List<MdNode> mdNodes = this.linker.refreshCredentialPickerViewer();
        this.credentialPickerViewer.setInput(mdNodes);
        this.setCredentialSelection();
    }

    private void setCredentialSelection() {
        MdNode credentialNode = this.linker.getBean().getCredential();
        if (credentialNode != null) {
            this.credentialPickerViewer.setSelection((ISelection)new StructuredSelection((Object)credentialNode));
        }
    }

    private void hookListeners() {
        this.credentialPickerViewer.addSelectionChangedListener(event -> {
            this.linker.getBean().credential = (MdNodeImpl)((IStructuredSelection)event.getSelection()).getFirstElement();
            this.getWizard().getContainer().updateButtons();
        });
    }

    public boolean isPageComplete() {
        return this.check();
    }

    private boolean check() {
        String errorMessage = this.computeErrorMessage();
        if (errorMessage == null) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(errorMessage);
        return false;
    }

    private String computeErrorMessage() {
        if (this.linker.getBean().credential == null) {
            return Messages.GoogleCredentialsPage_4;
        }
        return null;
    }
}

