/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.vault;

import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LifecycleAwareSessionManager;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.web.client.RestTemplate;

public class VaultTemplateCustom
extends VaultTemplate {
    private String namespace;
    private LifecycleAwareSessionManager lifecycleSessionManager;

    public VaultTemplateCustom(VaultEndpoint vaultEndpoint, ClientAuthentication clientAuthentication, String namespace, LifecycleAwareSessionManager lifecycleSessionManager) {
        super(vaultEndpoint, clientAuthentication);
        this.namespace = namespace;
        this.lifecycleSessionManager = lifecycleSessionManager;
        this.setSessionManager((SessionManager)this.lifecycleSessionManager);
    }

    protected RestTemplate doCreateRestTemplate(VaultEndpointProvider endpointProvider, ClientHttpRequestFactory requestFactory) {
        RestTemplate restTemplate = super.doCreateRestTemplate(endpointProvider, requestFactory);
        if (this.namespace != null) {
            restTemplate.getInterceptors().add((request, body, execution) -> {
                request.getHeaders().add("X-Vault-Namespace", this.namespace);
                return execution.execute(request, body);
            });
        }
        return restTemplate;
    }

    protected RestTemplate doCreateSessionTemplate(VaultEndpointProvider endpointProvider, ClientHttpRequestFactory requestFactory) {
        RestTemplate restTemplate = super.doCreateRestTemplate(endpointProvider, requestFactory);
        restTemplate.getInterceptors().add((request, body, execution) -> {
            if (this.namespace != null) {
                request.getHeaders().add("X-Vault-Namespace", this.namespace);
            }
            request.getHeaders().add("X-Vault-Token", this.lifecycleSessionManager.getSessionToken().getToken());
            request.getHeaders().add("X-Vault-Request", "true");
            return execution.execute(request, body);
        });
        return restTemplate;
    }

    public LifecycleAwareSessionManager getSessionManager() {
        return this.lifecycleSessionManager;
    }
}

