/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.couchbase.action;

import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonNull;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.QueryIndexManager;
import com.couchbase.client.java.query.QueryResult;
import com.indy.addons.json.JSONReverser;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.semarchy.xdi.designer.core.models.MetaDataLinkCapability;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.engine.common.exceptions.SecretStatementException;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.common.handler.ClusterHandler;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdFactoryHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public abstract class ReverseCouchbaseAction
implements IExecute,
ClusterHandler {
    protected static final String SCOPE_DEF_TYPE = "com.stambia.couchbase.scope";
    protected static final String COLLECTION_DEF_TYPE = "com.stambia.couchbase.collection";
    protected static final String DOCUMENT_DEF_TYPE = "com.stambia.couchbase.document";
    protected static final String ROOT_OBJECT_DEF_TYPE = "com.stambia.json.rootObject";
    private static final String ROOT_ARRAY_DEF_TYPE = "com.stambia.json.rootArray";
    private static final String ROOT_VALUE_DEF_TYPE = "com.stambia.json.rootValue";
    private static final String OBJECT_DEF_TYPE = "com.stambia.json.object";
    private static final String ARRAY_DEF_TYPE = "com.stambia.json.array";
    private static final String VALUE_DEF_TYPE = "com.stambia.json.value";
    protected static final String JSON_VALUE_DEF_TYPE = "com.stambia.json.value";
    private static final String SCOPE_PHYSICAL_NAME = "scopePhysicalName";
    private static final String COLLECTION_PHYSICAL_NAME = "collectionPhysicalName";
    protected static final String DOCUMENT_NAME = "document";
    protected static final String TYPE_FIELD_NAME = "type";
    protected static final String STRING_TYPE_VALUE = "string";
    private static final String SELECT_DOCUMENTS_QUERY = "SELECT * FROM `%s`.`%s`.`%s`";
    private static final String LIMIT_DOCUMENTS_QUERY = " LIMIT %d";
    protected static final String EMPTY_DOCUMENT = "{}";
    private static final String CONNECTION_URL_PARAMETER = "ancestor-or-self::cluster/@connectionURL";
    private static final String AUHENTICATION_METHOD = "ancestor-or-self::cluster/@auhenticationMethod";
    private static final String USER_PARAMETER = "ancestor-or-self::cluster/@user";
    public static final String PASSWORD_PARAMETER = "ancestor-or-self::cluster/@password";
    private static final String ONLY_ENABLE_PLAIN_SASL_MECHANISM_PARAMETER = "ancestor-or-self::cluster/@onlyEnablePlainSaslMechanism";
    private static final String CERTIFICATE_PATH_PARAMETER = "ancestor-or-self::cluster/@certificatePath";
    private static final String REVERSE_ENGINEERING_SAMPLE_SIZE = "ancestor-or-self::cluster/@reverseEngineeringSampleSize";
    private static final String REVERSE_ENGINEERING_AUTOMATIC_INDEX_CREATION_METHOD = "ancestor-or-self::cluster/@reverseEngineeringAutomaticIndexCreationMethod";
    private static final String REVERSE_ENGINEERING_AUTOMATIC_INDEX_CLEANUP = "ancestor-or-self::cluster/@reverseEngineeringAutomaticIndexCleanup";
    private static final String DOCUMENT_ENCODING = "UTF-8";
    private static final String AUTOMATICALLY_CREATE_NECESSARY_INDEXES = "Automatically create necessary indexes";
    private static final String REMOVE_THE_AUTOMATICALLY_CREATED_INDEXES = "Remove the automatically created indexes";
    protected Cluster cluster = null;
    protected AsyncCluster asyncCluster = null;
    private ClusterEnvironment clusterEnvironment = null;
    protected MdNode rootNode = null;
    protected MdNode parentMdNode = null;
    protected int reverseEngineeringSampleSize = 10;
    private boolean reverseEngineeringAutomaticIndexCreationMethod = false;
    private boolean reverseEngineeringAutomaticIndexCleanup = true;

    public final Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MetaDataLinkCapability mdlc;
        MdNode mdNode;
        this.rootNode = (MdNode)object;
        this.parentMdNode = this.getRoot(this.rootNode);
        while ((mdNode = this.parentMdNode) instanceof MetaDataLinkCapability && (mdlc = (MetaDataLinkCapability)mdNode).getMetaDataLinkBaseRef() != this.parentMdNode) {
            this.parentMdNode = this.getRoot((MdNode)mdlc.getMetaDataLinkBaseRef());
        }
        try {
            try {
                final String connectionURL = this.parentMdNode.evaluate(CONNECTION_URL_PARAMETER);
                final String auhenticationMethod = this.parentMdNode.evaluate(AUHENTICATION_METHOD);
                final String user = this.parentMdNode.evaluate(USER_PARAMETER);
                final String cryptedPassword = this.parentMdNode.evaluate(PASSWORD_PARAMETER);
                final String onlyEnablePlainSaslMechanism = this.parentMdNode.evaluate(ONLY_ENABLE_PLAIN_SASL_MECHANISM_PARAMETER);
                final String certificatePath = this.parentMdNode.evaluate(CERTIFICATE_PATH_PARAMETER);
                String rawReverseEngineeringSampleSize = this.parentMdNode.evaluate(REVERSE_ENGINEERING_SAMPLE_SIZE);
                this.reverseEngineeringSampleSize = rawReverseEngineeringSampleSize != null && CouchbaseUtil.INTEGER_PATTERN.matcher(rawReverseEngineeringSampleSize).matches() ? Integer.valueOf(rawReverseEngineeringSampleSize) : 0;
                String rawReverseEngineeringAutomaticIndexCreationMethod = this.parentMdNode.evaluate(REVERSE_ENGINEERING_AUTOMATIC_INDEX_CREATION_METHOD);
                this.reverseEngineeringAutomaticIndexCreationMethod = AUTOMATICALLY_CREATE_NECESSARY_INDEXES.equals(rawReverseEngineeringAutomaticIndexCreationMethod);
                String rawReverseEngineeringAutomaticIndexCleanup = this.parentMdNode.evaluate(REVERSE_ENGINEERING_AUTOMATIC_INDEX_CLEANUP);
                this.reverseEngineeringAutomaticIndexCleanup = REMOVE_THE_AUTOMATICALLY_CREATED_INDEXES.equals(rawReverseEngineeringAutomaticIndexCleanup);
                final SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                String clearPassword = semaphoreManager.getStringAsciiInfo(cryptedPassword);
                final IExternalValueResolver resolver = (IExternalValueResolver)E4InjectorHelper.getService(IExternalValueResolver.class);
                if (resolver.needResolution(new String[]{this.parentMdNode.evaluate(CONNECTION_URL_PARAMETER), this.parentMdNode.evaluate(USER_PARAMETER), this.parentMdNode.evaluate(PASSWORD_PARAMETER)})) {
                    resolver.executeSecured(new IExternalValueResolver.SecuredRunner(){

                        public void run() throws Exception {
                            String securedConnectionUrl = resolver.resolve(connectionURL);
                            String securedUser = resolver.resolve(user);
                            String securedPassword = resolver.resolve(cryptedPassword);
                            securedPassword = semaphoreManager.getStringAsciiInfo(securedPassword);
                            ReverseCouchbaseAction.this.connect(securedConnectionUrl, auhenticationMethod, securedUser, securedPassword, onlyEnablePlainSaslMechanism, certificatePath, null);
                        }

                        public Exception getFailure() {
                            return new SecretStatementException();
                        }
                    });
                } else {
                    this.connect(connectionURL, auhenticationMethod, user, clearPassword, onlyEnablePlainSaslMechanism, certificatePath, null);
                }
                Map<MdNode, MdNode> reversedNodes = this.reverse();
                IncrementalReverser incrementalReverser = new IncrementalReverser((EObject)this.rootNode, reversedNodes, Collections.emptyList(), false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
                incrementalReverser.reverse();
            }
            catch (Exception e) {
                throw new ExecuteException(e);
            }
        }
        finally {
            this.disconnect();
        }
        return null;
    }

    private MdNode getRoot(MdNode node) {
        while (node.eContainer() instanceof MdNode) {
            node = (MdNode)node.eContainer();
        }
        return node;
    }

    protected abstract Map<MdNode, MdNode> reverse() throws Exception;

    protected MdNode reverseScope(MdNode bucketNode, ScopeSpec scopeSpec, boolean isBase) throws Exception {
        String bucketName = bucketNode.getName();
        String scopeName = scopeSpec.name();
        MdNode scopeNode = ReverseCouchbaseAction.createNode(SCOPE_DEF_TYPE, scopeName, bucketNode, isBase);
        scopeNode.setAttribute(SCOPE_PHYSICAL_NAME, scopeName, false);
        Set collectionSpecs = scopeSpec.collections();
        for (CollectionSpec collectionSpec : collectionSpecs) {
            String collectionName = collectionSpec.name();
            this.reverseCollection(bucketName, scopeNode, collectionName, false);
        }
        return scopeNode;
    }

    protected MdNode reverseCollection(String bucketName, MdNode scopeNode, String collectionName, boolean isBase) throws Exception {
        MdNode collectionNode = ReverseCouchbaseAction.createNode(COLLECTION_DEF_TYPE, collectionName, scopeNode, isBase);
        collectionNode.setAttribute(COLLECTION_PHYSICAL_NAME, collectionName, false);
        String scopeName = scopeNode.getName();
        this.reverseDocument(bucketName, scopeName, collectionNode, false);
        return collectionNode;
    }

    protected MdNode reverseDocument(String bucketName, String scopeName, MdNode collectionNode, boolean isBase) throws Exception {
        String collectionName = collectionNode.getName();
        QueryIndexManager queryIndexManager = new QueryIndexManager(this.asyncCluster.queryIndexes());
        boolean createdIndex = false;
        MdNode documentNode = ReverseCouchbaseAction.createNode(DOCUMENT_DEF_TYPE, DOCUMENT_NAME, collectionNode, isBase);
        ReverseCouchbaseAction.createDocumentValue("id", STRING_TYPE_VALUE, documentNode);
        if (this.reverseEngineeringAutomaticIndexCreationMethod) {
            try {
                CreatePrimaryQueryIndexOptions createPrimaryQueryIndexOptions = CreatePrimaryQueryIndexOptions.createPrimaryQueryIndexOptions().ignoreIfExists(false).scopeName(scopeName).collectionName(collectionName);
                queryIndexManager.createPrimaryIndex(bucketName, createPrimaryQueryIndexOptions);
                createdIndex = true;
            }
            catch (IndexExistsException e) {
                createdIndex = false;
            }
            catch (Exception e) {
                throw e;
            }
        }
        StringBuilder selectQuery = new StringBuilder(String.format(SELECT_DOCUMENTS_QUERY, bucketName, scopeName, collectionName));
        if (this.reverseEngineeringSampleSize > 0) {
            selectQuery.append(String.format(LIMIT_DOCUMENTS_QUERY, this.reverseEngineeringSampleSize));
        }
        QueryResult selectResult = this.cluster.query(selectQuery.toString());
        List documents = selectResult.rowsAsObject();
        JsonObject mergedJsonContent = JsonObject.create();
        if (!documents.isEmpty()) {
            for (JsonObject document : documents) {
                JsonObject toMergeJsonContent;
                Object mergedResult;
                Object documentContent = document.get(collectionName);
                if (!(documentContent instanceof JsonObject) || !((mergedResult = ReverseCouchbaseAction.mergeJsonObject(toMergeJsonContent = document.getObject(collectionName), mergedJsonContent)) instanceof JsonObject)) continue;
                mergedJsonContent = (JsonObject)mergedResult;
            }
        }
        ReverseCouchbaseAction.addContentNode(documentNode, mergedJsonContent);
        if (this.reverseEngineeringAutomaticIndexCleanup && createdIndex) {
            DropPrimaryQueryIndexOptions dropPrimaryQueryIndexOptions = DropPrimaryQueryIndexOptions.dropPrimaryQueryIndexOptions().scopeName(scopeName).collectionName(collectionName);
            queryIndexManager.dropPrimaryIndex(bucketName, dropPrimaryQueryIndexOptions);
        }
        return documentNode;
    }

    protected static void createDocumentValue(String nodeName, String nodeType, MdNode documentNode) {
        MdNode documentValue = ReverseCouchbaseAction.createNode("com.stambia.json.value", nodeName, documentNode, false);
        documentValue.setAttribute(TYPE_FIELD_NAME, nodeType, false);
    }

    protected static MdNode createNode(String defType, String name, MdNode parent, boolean isBase) {
        MdNode node = MdFactoryHelper.createMdNode((String)defType);
        if (isBase) {
            node.setSubstituteContainer((EObject)parent);
        } else {
            parent.getNode().add((Object)node);
        }
        node.setName(name);
        return node;
    }

    protected static void addContentNode(MdNode parent, Object jsonRawData) throws Exception {
        block13: {
            MdNode contentNode;
            block14: {
                JSONReverser jsonReverser = new JSONReverser();
                jsonReverser.setParentNode(parent);
                if (jsonRawData == null) break block13;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonRawData.toString().getBytes());
                contentNode = jsonReverser.reverse((InputStream)inputStream, DOCUMENT_ENCODING);
                contentNode.setName("content");
                String originalDefType = contentNode.getDefType();
                if (originalDefType == null) break block14;
                contentNode.setDefType(switch (originalDefType) {
                    case ROOT_OBJECT_DEF_TYPE -> OBJECT_DEF_TYPE;
                    case ROOT_ARRAY_DEF_TYPE -> ARRAY_DEF_TYPE;
                    case ROOT_VALUE_DEF_TYPE -> "com.stambia.json.value";
                    default -> originalDefType;
                });
            }
            contentNode.setSubstituteContainer((EObject)parent);
            parent.getNode().add((Object)contentNode);
        }
    }

    protected static Object mergeJsonObject(Object toMergeObject, Object alreadyMergedObject) {
        Object mergedObject = JsonNull.INSTANCE;
        if (CouchbaseUtil.isJsonValueNull((Object)toMergeObject) && !CouchbaseUtil.isJsonValueNull((Object)alreadyMergedObject)) {
            mergedObject = CouchbaseUtil.copyJsonValue((Object)alreadyMergedObject);
        } else if (!CouchbaseUtil.isJsonValueNull((Object)toMergeObject)) {
            if (CouchbaseUtil.isJsonValueNull((Object)alreadyMergedObject)) {
                mergedObject = CouchbaseUtil.copyJsonValue((Object)toMergeObject);
            } else {
                String alreadyMergedType;
                String toMergeType = toMergeObject.getClass().toString();
                if (toMergeType.equals(alreadyMergedType = alreadyMergedObject.getClass().toString())) {
                    if (toMergeObject instanceof JsonObject) {
                        JsonObject toMergeJsonObject = (JsonObject)toMergeObject;
                        JsonObject alreadyMergedJsonObject = (JsonObject)alreadyMergedObject;
                        JsonObject mergedJsonObject = (JsonObject)CouchbaseUtil.copyJsonValue((Object)alreadyMergedJsonObject);
                        for (String key : toMergeJsonObject.getNames()) {
                            Object toMergeValue = toMergeJsonObject.get(key);
                            if (!alreadyMergedJsonObject.containsKey(key)) {
                                Object copiedValue = CouchbaseUtil.copyJsonValue((Object)toMergeValue);
                                mergedJsonObject.put(key, copiedValue);
                            } else {
                                Object alreadyMergedValue = alreadyMergedJsonObject.get(key);
                                Object mergedChild = ReverseCouchbaseAction.mergeJsonObject(toMergeValue, alreadyMergedValue);
                                mergedJsonObject.put(key, mergedChild);
                            }
                            mergedObject = mergedJsonObject;
                        }
                    } else if (toMergeObject instanceof JsonArray) {
                        JsonArray toMergeJsonArray = (JsonArray)toMergeObject;
                        JsonArray alreadyMergedJsonArray = (JsonArray)alreadyMergedObject;
                        Object mergedJsonElement = JsonNull.INSTANCE;
                        for (Object alreadyMergedElement : alreadyMergedJsonArray) {
                            mergedJsonElement = ReverseCouchbaseAction.mergeJsonObject(alreadyMergedElement, mergedJsonElement);
                        }
                        for (Object toMergeElement : toMergeJsonArray) {
                            mergedJsonElement = ReverseCouchbaseAction.mergeJsonObject(toMergeElement, mergedJsonElement);
                        }
                        JsonArray mergedJsonArray = JsonArray.create((int)1);
                        mergedJsonArray.add(mergedJsonElement);
                        mergedObject = mergedJsonArray;
                    } else {
                        mergedObject = toMergeObject;
                    }
                }
            }
        }
        return mergedObject;
    }

    public final void setClusterAndAsync(Cluster cluster) {
        this.cluster = cluster;
        this.asyncCluster = cluster.async();
    }

    public final Cluster getCluster() {
        return this.cluster;
    }

    public final AsyncCluster getAsyncCluster() {
        return this.asyncCluster;
    }

    public final void setClusterEnvironment(ClusterEnvironment clusterEnvironment) {
        this.clusterEnvironment = clusterEnvironment;
    }

    public final ClusterEnvironment getClusterEnvironment() {
        return this.clusterEnvironment;
    }
}

