/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.couchbase.action.hierarchy;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.manager.collection.CollectionManager;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.indy.addons.couchbase.action.ReverseCouchbaseAction;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ReverseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReverseScopeAction
extends ReverseCouchbaseAction {
    @Override
    protected final Map<MdNode, MdNode> reverse() throws Exception {
        HashMap<MdNode, MdNode> reversedNodes = new HashMap<MdNode, MdNode>();
        String scopeName = this.rootNode.getName();
        if (!(this.rootNode.getMetaDataLinkBaseRef().eContainer() instanceof MdNode)) {
            throw new ReverseException("Error when reversing scope.The parent bucket node is not instance of MdNode. Please contact the support team for more information.");
        }
        MdNode bucketNode = (MdNode)this.rootNode.getMetaDataLinkBaseRef().eContainer();
        String bucketName = bucketNode.getName();
        Bucket bucket = this.cluster.bucket(bucketName);
        CollectionManager collectionManager = bucket.collections();
        List scopes = collectionManager.getAllScopes();
        ScopeSpec scopeSpec = null;
        for (ScopeSpec scopeSpecCandidate : scopes) {
            if (!scopeName.equalsIgnoreCase(scopeSpecCandidate.name())) continue;
            scopeSpec = scopeSpecCandidate;
            break;
        }
        if (scopeSpec != null) {
            Set collectionSpecs = scopeSpec.collections();
            for (CollectionSpec collectionSpec : collectionSpecs) {
                String collectionName = collectionSpec.name();
                MdNode oldCollectionNode = this.rootNode.getNodeByName("com.stambia.couchbase.collection", collectionName);
                MdNode newCollectionNode = this.reverseCollection(bucketName, this.rootNode, collectionName, true);
                reversedNodes.put(newCollectionNode, oldCollectionNode);
            }
        }
        return reversedNodes;
    }
}

