/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.couchbase.action.query;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.result.SearchResult;
import com.couchbase.client.java.search.result.SearchRow;
import com.indy.addons.couchbase.action.query.ReverseQueryAction;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.common.QueryType;
import com.stambia.couchbase.common.handler.query.FtsUtil;
import com.stambia.couchbase.common.handler.query.QueryHandler;
import com.stambia.md.MdNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReverseFtsAction
extends ReverseQueryAction
implements QueryHandler<SearchRow> {
    private static final String INDEX_PARAMETER = "ancestor-or-self::ftsQuery/@index";
    private static final String QUERY_TYPE_PARAMETER = "ancestor-or-self::ftsQuery/@queryType";
    private static final String FIELDS_PARAMETER = "ancestor-or-self::ftsQuery/@fields";
    private static final String FTS_QUERY_PARAMETER = "ancestor-or-self::ftsQuery/@queryString";
    private static final String NUMBER_TYPE_VALUE = "number";
    private static final String NAME_ATTRIBUT_EXCLUSE = "' and @name!='";
    private static final String FTS_MAPPING_PARAMETERS = "./document/*[name()='value" + "' and @name!='" + String.join((CharSequence)"' and @name!='", CouchbaseUtil.QUERY_EXCLUDE_PARAMETERS) + "']";
    private String index = null;
    private QueryType queryType = null;
    private SearchOptions ftsOptions = null;
    private List<SearchRow> searchRows = null;

    @Override
    protected final Map<MdNode, MdNode> reverse() throws Exception {
        HashMap<MdNode, MdNode> reversedNodes = new HashMap<MdNode, MdNode>();
        this.getUserParameters();
        this.queryString = this.getQueryString();
        List<MdNode> mappingParameters = this.getMappingParameters();
        if (!mappingParameters.isEmpty()) {
            for (MdNode mappingParameter : mappingParameters) {
                String value = mappingParameter.evaluate("@reverseValue");
                if (value == null) continue;
                String name = mappingParameter.getName();
                this.queryString = this.parametrizedQuery(this.queryString, name, value);
            }
        }
        MdNode oldDocumentNode = this.rootNode.getNodeByName("com.stambia.couchbase.document", "document");
        this.newDocumentNode = ReverseFtsAction.createNode("com.stambia.couchbase.document", "document", this.rootNode, true);
        this.createExtraNodes();
        this.setSearchRows();
        String jsonRawData = "{}";
        this.processQueryRows();
        if (this.mergedContentNode != null) {
            jsonRawData = this.mergedContentNode;
        }
        ReverseFtsAction.addContentNode(this.newDocumentNode, jsonRawData);
        reversedNodes.put(this.newDocumentNode, oldDocumentNode);
        return reversedNodes;
    }

    public List<SearchRow> getQueryRows() {
        return this.searchRows;
    }

    public void processQueryRow(SearchRow queryRow) throws Exception {
        JsonObject toMergeContentNode = (JsonObject)queryRow.fieldsAs(JsonObject.class);
        this.mergedContentNode = (JsonObject)ReverseFtsAction.mergeJsonObject(toMergeContentNode, this.mergedContentNode);
    }

    @Override
    protected String getQueryString() throws Exception {
        String ftsQuery = this.rootNode.evaluate(FTS_QUERY_PARAMETER);
        return ftsQuery;
    }

    @Override
    protected void getUserParameters() throws Exception {
        this.index = this.rootNode.evaluate(INDEX_PARAMETER);
        String rawQueryType = this.rootNode.evaluate(QUERY_TYPE_PARAMETER);
        this.queryType = CouchbaseUtil.setQueryType((String)rawQueryType);
        String fields = this.rootNode.evaluate(FIELDS_PARAMETER);
        this.ftsOptions = FtsUtil.getFtsOptions((String)fields);
        if (this.reverseEngineeringSampleSize > 0) {
            this.ftsOptions = this.ftsOptions.limit(this.reverseEngineeringSampleSize);
        }
    }

    @Override
    protected List<MdNode> getMappingParameters() throws Exception {
        List ftsParameters = (List)this.rootNode.evaluateMdSet(FTS_MAPPING_PARAMETERS);
        return ftsParameters;
    }

    @Override
    protected void createExtraNodes() {
        if (this.newDocumentNode != null) {
            ReverseFtsAction.createDocumentValue("id", "string", this.newDocumentNode);
            ReverseFtsAction.createDocumentValue("index", "string", this.newDocumentNode);
            ReverseFtsAction.createDocumentValue("score", NUMBER_TYPE_VALUE, this.newDocumentNode);
        }
    }

    @Override
    protected void setSearchRows() throws Exception {
        SearchResult ftsResult = FtsUtil.runFtsQuery((QueryType)this.queryType, (String)this.queryString, (Cluster)this.cluster, (String)this.index, (SearchOptions)this.ftsOptions);
        this.searchRows = ftsResult.rows();
    }
}

