/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.salesforce.properties;

import com.indy.addons.salesforce.Messages;
import com.indy.addons.salesforce.core.IReverser;
import com.indy.addons.salesforce.core.ISalesForceConnection;
import com.indy.addons.salesforce.reverse.SalesForceLoadReverser;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.md.ui.editor.ui.MdControlManager;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdNode;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class SalesForceConnectionComposite
extends Composite {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private MdControlManager mcm;
    private Text nameField;
    private MdNode sfServer;
    private Text host;
    private Text login;
    private Text password;
    private Text securityToken;
    private static final Logger LOGGER = Logger.getLogger(SalesForceConnectionComposite.class.getName());
    private Button connect;

    public abstract void handleErrorMessage(String var1);

    public SalesForceConnectionComposite(Composite parent, int style, MdNode _sfServer) {
        super(parent, style);
        this.sfServer = _sfServer;
        SalesForceConnectionComposite composite = this;
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        composite.setFont(parent.getFont());
        Composite nameGroup = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        nameGroup.setLayoutData((Object)data);
        this.mcm = new MdControlManager();
        Label label = new Label(nameGroup, 64);
        label.setText("Name");
        this.nameField = new Text(nameGroup, 2048);
        this.nameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (SalesForceConnectionComposite.this.nameField.getText() != null) {
                    if (SalesForceConnectionComposite.this.nameField.getText().matches("[A-Za-z][A-Za-z0-9]*")) {
                        SalesForceConnectionComposite.this.handleErrorMessage(null);
                    } else {
                        SalesForceConnectionComposite.this.handleErrorMessage(Messages.SalesForceConnectionComposite_1);
                    }
                }
                if (SalesForceConnectionComposite.this.nameField.getText() == null || SalesForceConnectionComposite.this.nameField.getText().isEmpty()) {
                    SalesForceConnectionComposite.this.handleErrorMessage(Messages.SalesForceConnectionComposite_2);
                }
            }
        });
        this.mcm.addControl((Control)this.nameField, this.sfServer, null, 3, true, false);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.nameField.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sfServer, "authEndPoint", 0, true, false);
        this.host = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.host, this.sfServer, "authEndPoint", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.host.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sfServer, "login", 0, true, false);
        this.login = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.login, this.sfServer, "login", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.login.setLayoutData((Object)data);
        MdControlManager.MdControl mc = this.mcm.addControl((Control)new Label(nameGroup, 64), this.sfServer, "password", 0, true, false);
        this.password = new Text(nameGroup, 0x400800);
        this.mcm.addControl((Control)this.password, this.sfServer, "password", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.password.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sfServer, "securityToken", 0, true, false);
        this.securityToken = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.securityToken, this.sfServer, "securityToken", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.securityToken.setLayoutData((Object)data);
        this.connect = new Button(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.connect.setLayoutData((Object)data);
        this.connect.setText(Messages.SalesForceConnectionComposite_11);
        this.connect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (!SalesForceConnectionComposite.isConnected(SalesForceConnectionComposite.this.sfServer)) {
                        SalesForceConnectionComposite.connect(SalesForceConnectionComposite.this.sfServer, true, true);
                        SalesForceConnectionComposite.this.connectOrDisconnect();
                        MessageDialog.openInformation((Shell)SalesForceConnectionComposite.this.getShell(), (String)Messages.SalesForceConnectionComposite_12, (String)Messages.SalesForceConnectionComposite_13);
                    } else {
                        SalesForceConnectionComposite.disConnect(SalesForceConnectionComposite.this.sfServer);
                        SalesForceConnectionComposite.this.connectOrDisconnect();
                    }
                }
                catch (Throwable e) {
                    Throwable t = e;
                    if (t.getCause() != null && t.getCause() != t) {
                        t = t.getCause();
                    }
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons.salesforce", Messages.SalesForceConnectionComposite_14, t), 4);
                }
            }
        });
        this.mcm.init();
    }

    public static void printException(Throwable t, Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.SalesForceConnectionComposite_15, (String)t.toString());
    }

    public static boolean isConnected(MdNode sfServer) throws Exception {
        return sfServer.getConnection() != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.connectOrDisconnect();
            }
            catch (Throwable e) {
                SalesForceConnectionComposite.printException(e, this.getShell());
            }
        }
    }

    public void dispose() {
        super.dispose();
        try {
            SalesForceConnectionComposite.disConnect(this.sfServer);
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
    }

    public void connectOrDisconnect() throws Exception {
        boolean _connect = SalesForceConnectionComposite.isConnected(this.sfServer);
        if (_connect) {
            this.connect.setText(Messages.SalesForceConnectionComposite_21);
        } else {
            this.connect.setText(Messages.SalesForceConnectionComposite_22);
        }
        this.host.setEnabled(!_connect);
        this.password.setEnabled(!_connect);
        this.login.setEnabled(!_connect);
        this.securityToken.setEnabled(!_connect);
        this.handleConnection(_connect);
    }

    public abstract void handleConnection(boolean var1);

    public static synchronized void connect(final MdNode sfServer, boolean reinit, boolean forceReconnection) throws Exception {
        final IExternalValueResolver resolver = (IExternalValueResolver)E4InjectorHelper.getService(IExternalValueResolver.class);
        final String login = sfServer.evaluate("@login");
        String password = sfServer.evaluate("@password");
        if (password != null && !password.isEmpty()) {
            try {
                String decrypt;
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                password = decrypt = semaphoreManager.getStringAsciiInfo(password);
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
            }
        }
        final String securityToken = sfServer.evaluate("@securityToken");
        String authenticationEndPoint = sfServer.evaluate("@authEndPoint");
        if (authenticationEndPoint != null && authenticationEndPoint.isEmpty()) {
            authenticationEndPoint = null;
        }
        String maxRowPerBatch = sfServer.evaluate("@maxRowPerBatch");
        String timeOut = sfServer.evaluate("@timeOut");
        String tickTime = sfServer.evaluate("@sleepingTime");
        String authenticationProperties = null;
        try {
            authenticationProperties = sfServer.evaluate("@authentication/ref:getRef()/internal:toJavaProperties()");
        }
        catch (XPathExpressionException e) {
            LOGGER.warning(e.getMessage());
        }
        String module = null;
        try {
            module = sfServer.evaluateXpathExpression("INTERNAL_MODULE");
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        final IReverser reverser = SalesForceLoadReverser.INSTANCE.loadReverser(module);
        ISalesForceConnection conn = null;
        final String proxyHost = sfServer.evaluate("@proxyHost");
        final String proxyPort = sfServer.evaluate("@proxyPort");
        final String proxyUser = sfServer.evaluate("@proxyUser");
        String proxyPassword = sfServer.evaluate("@proxyPassowrd");
        if (resolver.needResolution(new String[]{sfServer.evaluate("@login"), sfServer.evaluate("@password"), sfServer.evaluate("@securityToken"), sfServer.evaluate("@authEndPoint"), sfServer.evaluate("@proxyHost"), sfServer.evaluate("@proxyPort"), sfServer.evaluate("@proxyUser"), sfServer.evaluate("@proxyPassowrd")})) {
            final String passwordToresolve = password;
            final String authenticationToResolve = authenticationEndPoint;
            final String authenticationPropertiesEnclosingScope = authenticationProperties;
            final String proxyPasswordToResolve = proxyPassword;
            resolver.executeSecured(new IExternalValueResolver.SecuredRunner(){

                public void run() throws Exception {
                    String securedPort;
                    String securedHost;
                    String passwd;
                    String user;
                    ISalesForceConnection connToResolve = null;
                    String securedLogin = resolver.resolve(login);
                    String securedPassword = resolver.resolve(passwordToresolve);
                    String securedSecurityToken = resolver.resolve(securityToken);
                    String securedAuthEndpoint = resolver.resolve(authenticationToResolve);
                    connToResolve = reverser.connect(securedLogin, securedPassword, securedSecurityToken, securedAuthEndpoint);
                    if (authenticationPropertiesEnclosingScope != null && !authenticationPropertiesEnclosingScope.isEmpty()) {
                        connToResolve.setAuthenticationProperties(authenticationPropertiesEnclosingScope);
                    }
                    if ((user = resolver.resolve(proxyUser)) != null && !user.isEmpty()) {
                        connToResolve.setProxyUsername(user);
                    }
                    if ((passwd = resolver.resolve(proxyPasswordToResolve)) != null && !passwd.isEmpty()) {
                        try {
                            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                            connToResolve.setProxyPassword(semaphoreManager.getStringAsciiInfo(passwd));
                        }
                        catch (Exception e) {
                            LOGGER.warning(e.getMessage());
                        }
                    }
                    if ((securedHost = resolver.resolve(proxyHost)) != null && !securedHost.isEmpty()) {
                        connToResolve.setProxyHost(securedHost);
                    }
                    if ((securedPort = resolver.resolve(proxyPort)) != null && !securedPort.isEmpty()) {
                        try {
                            connToResolve.setProxyPort(Integer.valueOf(securedPort).intValue());
                        }
                        catch (Exception e) {
                            LOGGER.warning(e.getMessage());
                        }
                    }
                    connToResolve.login();
                    sfServer.setConnection((Object)connToResolve);
                }

                public Exception getFailure() {
                    return new Exception(Messages.SalesForceConnectionComposite_6);
                }
            });
        } else {
            conn = reverser.connect(login, password, securityToken, authenticationEndPoint);
            if (authenticationProperties != null && !authenticationProperties.isEmpty()) {
                conn.setAuthenticationProperties(authenticationProperties);
            }
            if (proxyHost != null && !proxyHost.isEmpty()) {
                conn.setProxyHost(proxyHost);
            }
            if (proxyPort != null && !proxyPort.isEmpty()) {
                try {
                    conn.setProxyPort(Integer.valueOf(proxyPort).intValue());
                }
                catch (Exception e) {
                    LOGGER.warning(e.getMessage());
                }
            }
            if (proxyUser != null && !proxyUser.isEmpty()) {
                conn.setProxyUsername(proxyUser);
            }
            if (proxyPassword != null && !proxyPassword.isEmpty()) {
                try {
                    String decrypt;
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    proxyPassword = decrypt = semaphoreManager.getStringAsciiInfo(proxyPassword);
                    conn.setProxyPassword(proxyPassword);
                }
                catch (Exception e) {
                    LOGGER.warning(e.getMessage());
                }
            }
            conn.login();
            sfServer.setConnection((Object)conn);
        }
    }

    private static synchronized String decryptString(String expression) {
        if (expression != null && !expression.isEmpty()) {
            try {
                String decrypt;
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                expression = decrypt = semaphoreManager.getStringAsciiInfo(expression);
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
            }
        }
        return expression;
    }

    public static synchronized void disConnect(MdNode sapServer) {
        ISalesForceConnection destination = (ISalesForceConnection)sapServer.getConnection();
        if (destination != null) {
            try {
                destination.logout();
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
            }
        }
        sapServer.setConnection(null);
    }
}

