/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.salesforce.properties;

import com.indy.addons.salesforce.Messages;
import com.indy.addons.salesforce.properties.SalesForceConnectionComposite;
import com.indy.md.ui.editor.ui.MdControl;
import com.indy.md.ui.editor.ui.ReverseProvider;
import com.indy.ui.custom.out.Util;
import com.stambia.md.MdNode;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.ReverseEvent;
import com.stambia.md.custom.ReverseListener;
import com.stambia.md.custom.exception.ReverseException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class SalesForceReverseComposite
extends Composite {
    int count = 0;
    private Text filterName;
    private ReverseProvider reverseProvider;
    private MdControl datastores;
    private Label selectedObjectCount;
    private CheckboxTreeViewer ctv;
    private final Logger logger = LogManager.getLogger(SalesForceReverseComposite.class);

    public SalesForceReverseComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Group filtergroup = new Group((Composite)this, 0);
        filtergroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        filtergroup.setLayoutData((Object)gd);
        Label l = new Label((Composite)filtergroup, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.SalesForceReverseComposite_0);
        this.filterName = new Text((Composite)filtergroup, 2048);
        gd = new GridData(4, 1, true, false);
        this.filterName.setLayoutData((Object)gd);
        this.reverseProvider = new ReverseProvider(){

            public Object getConnection() throws Exception {
                return SalesForceReverseComposite.this.getConnection();
            }

            public MdNode getParent() {
                return SalesForceReverseComposite.this.getNode();
            }

            public void handleEvent() {
                if (!((List)SalesForceReverseComposite.this.datastores.getSelection()).isEmpty()) {
                    SalesForceReverseComposite.this.handePageComplete(true);
                } else {
                    SalesForceReverseComposite.this.handePageComplete(false);
                }
                SalesForceReverseComposite.this.handleEvent();
            }
        };
        this.reverseProvider.createRefresh((Composite)filtergroup);
        Composite selectionButtonC = new Composite((Composite)this, 0);
        selectionButtonC.setLayout((Layout)new GridLayout(2, false));
        Button selectAll = new Button(selectionButtonC, 0);
        selectAll.setText(Messages.SalesForceReverseComposite_1);
        Button deselectAll = new Button(selectionButtonC, 0);
        deselectAll.setText(Messages.SalesForceReverseComposite_2);
        this.ctv = MdControl.createTreeViewer((Composite)this, (int)8, (boolean)false);
        this.ctv.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String f = SalesForceReverseComposite.this.filterName.getText();
                boolean ret = true;
                ret = f.trim().isEmpty() ? true : Pattern.matches(f.replace("*", ".*").replace("%", ".*"), ((MdNode)element).getName());
                if (ret) {
                    ++SalesForceReverseComposite.this.count;
                }
                return ret;
            }
        });
        this.datastores = new MdControl(this.ctv, null, 3){

            public void handleInputChanged(List elements) {
                SalesForceReverseComposite.this.count = elements != null ? elements.size() : 0;
                SalesForceReverseComposite.this.refreshCountLabels();
            }
        };
        this.reverseProvider.addControl(this.datastores, new String[]{"com.stambia.appl.salesforce.sobject"});
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.ctv.getTree().setLayoutData((Object)gridData);
        this.selectedObjectCount = new Label((Composite)this, 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 4;
        this.selectedObjectCount.setLayoutData((Object)gridData);
        this.selectedObjectCount.setText("0 item selected /0");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = SalesForceReverseComposite.this.ctv.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem i = treeItemArray[n2];
                    i.setChecked(true);
                    ++n2;
                }
                SalesForceReverseComposite.this.refreshCountLabels();
                SalesForceReverseComposite.this.handePageComplete(true);
            }
        });
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = SalesForceReverseComposite.this.ctv.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem i = treeItemArray[n2];
                    i.setChecked(false);
                    ++n2;
                }
                SalesForceReverseComposite.this.refreshCountLabels();
                SalesForceReverseComposite.this.handePageComplete(false);
            }
        });
        this.ctv.addCheckStateListener(event -> {
            this.refreshCountLabels();
            this.handePageComplete(this.ctv.getCheckedElements().length > 0);
        });
        this.filterName.addModifyListener(e -> {
            this.count = 0;
            if (this.ctv.getInput() != null) {
                this.ctv.refresh();
            }
            this.refreshCountLabels();
        });
    }

    public ReverseProvider getReverseProvider() {
        return this.reverseProvider;
    }

    private void refreshCountLabels() {
        int count2 = this.ctv.getCheckedElements().length;
        this.selectedObjectCount.setText(Integer.toString(count2) + " item" + (count2 > 1 ? "s" : "") + " selected / " + Integer.toString(this.count));
    }

    public abstract void handleEvent();

    public abstract void handePageComplete(boolean var1);

    public abstract MdNode getNode();

    public void reverse(ReverseListener listener, IProgressMonitor monitor) throws ReverseException {
        MdReverse reverse = this.reverseProvider.getMdReverse();
        if (listener != null) {
            reverse.addReverseListener(listener);
            reverse.setProgressMonitor(monitor);
        }
        try {
            this.datastores.reverse(reverse, this.getConnection(), this.getNode());
        }
        catch (ReverseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReverseException((Throwable)e);
        }
    }

    public Object getConnection() throws Exception {
        if (!SalesForceConnectionComposite.isConnected(this.getNode())) {
            SalesForceConnectionComposite.connect(this.getNode(), false, false);
        }
        return this.getNode().getConnection();
    }

    public void reverse() {
        try {
            final MessageConsole console = Util.findConsole((String)Messages.SalesForceReverseComposite_12);
            console.activate();
            final ReverseListener listener = new ReverseListener(){

                public void objectReverseStart(ReverseEvent event) throws ReverseException {
                    String msg = Messages.SalesForceReverseComposite_13 + event.objectType + " : " + String.valueOf(event.data);
                    if (event.monitor != null) {
                        event.monitor.subTask(msg);
                    }
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (MessageConsoleStream msc = console.newMessageStream();){
                            msc.println(msg);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new ReverseException((Throwable)e);
                    }
                }

                public void reverseStart(ReverseEvent event) throws ReverseException {
                    if (event.monitor != null) {
                        event.monitor.beginTask(event.objectType, ((Object[])event.data).length);
                    }
                }

                public void objectReverseEnd(ReverseEvent event) throws ReverseException {
                    if (event.monitor != null) {
                        event.monitor.worked(1);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            SalesForceReverseComposite.this.reverse(listener, monitor);
                        }
                        catch (ReverseException e) {
                            MessageDialog.openError((Shell)SalesForceReverseComposite.this.getShell(), (String)Messages.SalesForceReverseComposite_15, (String)e.getCause().getMessage());
                            SalesForceReverseComposite.this.logger.warn("Unexpected", (Throwable)e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e1) {
                this.logger.warn("Unexpected", (Throwable)e1);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                this.logger.warn("Interrupted", (Throwable)e1);
            }
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
    }
}

