/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.salesforce.reverse;

import com.indy.addons.salesforce.Activator;
import com.indy.addons.salesforce.Messages;
import com.indy.addons.salesforce.core.ISalesForceConnection;
import com.indy.addons.salesforce.core.SFEntity;
import com.indy.addons.salesforce.core.SFField;
import com.indy.addons.salesforce.core.SFMetaData;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class SalesForceReverse
extends MdReverse {
    public static final String SF_FIELD = "com.stambia.appl.salesforce.field";
    public static final String SF_SOBJECTS = "com.stambia.appl.salesforce.sobject";
    public static final String SF_SERVER = "com.stambia.appl.salesforce.server";
    public static final String SF_EXCHANGE_NODE = "com.stambia.appl.salesforce.exchangeNode";
    public static final String SF_EXTERNALID = "com.stambia.appl.salesforce.externalId";
    private final Logger logger = LogManager.getLogger(SalesForceReverse.class);
    private Configuration product;
    private ISalesForceConnection connection;
    private MdNode currentNode;
    private Map<Attribute, List<ReferenceResolver>> referenceResolver;

    public void setConnection(Object connection) throws ReverseException {
        try {
            this.connection = (ISalesForceConnection)connection;
        }
        catch (ClassCastException exeption) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.addons.salesforce", Messages.SalesForceReverse_5, (Throwable)exeption));
            throw new ReverseException(exeption.getCause());
        }
    }

    public void setNode(MdNode node) {
        this.currentNode = node;
        try {
            Configuration server = node.evaluateMdNode("ancestor-or-self::server[1]");
            this.product = server.evaluateMdNode("ancestor::product[1]");
        }
        catch (XPathExpressionException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.addons.salesforce", Messages.SalesForceReverse_0, (Throwable)e));
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    public void setConf(String conf) {
    }

    public List<String> getChildren(String type, String parentName, String nameFilter, String ... typesFilter) throws ReverseException {
        return null;
    }

    public List<MdNode> getMdNodeChildren(String type, String parentName, String nameFilter, String ... typesFilter) throws ReverseException {
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        if (SF_SOBJECTS.equals(type)) {
            this.createSObjectNode(nodes);
        }
        return nodes;
    }

    public List<MdNode> doReverse(Object[] selectedChildren) throws ReverseException {
        this.referenceResolver = new HashMap<Attribute, List<ReferenceResolver>>();
        ArrayList<MdNode> reversedNodes = new ArrayList<MdNode>();
        ArrayList<MdNode> sObjectNames = new ArrayList<MdNode>();
        Object[] objectArray = selectedChildren;
        int n = selectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof MdNode) {
                MdNode node = (MdNode)o;
                if (SF_SERVER.equals(node.getDefType())) {
                    this.createSObjectNode(reversedNodes);
                } else if (SF_SOBJECTS.equals(node.getDefType())) {
                    try {
                        sObjectNames.add(node);
                    }
                    catch (Exception ex) {
                        this.logger.warn("unexpected", (Throwable)ex);
                    }
                }
            }
            ++n2;
        }
        try {
            this.addFields(this.connection.getMetaData(), sObjectNames);
            this.addExchangeNodes(sObjectNames);
        }
        catch (Exception ex) {
            this.logger.warn("unexpected", (Throwable)ex);
        }
        List<Object> result = Arrays.asList(selectedChildren);
        return result;
    }

    private void addExchangeNodes(List<MdNode> sObjectNames) {
        for (MdNode sObject : sObjectNames) {
            MdNode exOutputNode = this.addExchangeNode(sObject, "SForceExchangeOutput", null, null);
            this.addExchangeNode(exOutputNode, "Id", "string", "50");
            this.addExchangeNode(exOutputNode, "Status", "string", "50");
            this.addExchangeNode(exOutputNode, "IsSuccess", "boolean", "1");
            this.addExchangeNode(exOutputNode, "IsCreated", "boolean", "1");
            MdNode errorNode = this.addExchangeNode(exOutputNode, "Error", null, null);
            this.addExchangeNode(errorNode, "StatusCode", "string", "50");
            this.addExchangeNode(errorNode, "Message", "string", null);
            MdNode fieldNode = this.addExchangeNode(errorNode, "Field", null, null);
            this.addExchangeNode(fieldNode, "FieldName", "string", "80");
        }
    }

    private MdNode addExchangeNode(MdNode parent, String name, String type, String size) {
        MdNode node = MdFactoryHelper.createMdNode((String)SF_EXCHANGE_NODE);
        node.setSubstituteContainer((EObject)parent);
        node.setName(name);
        if (type != null) {
            node.setAttribute("type", type, false);
            if (size != null) {
                node.setAttribute("length", size, false);
            }
        }
        node.setPosition(new BigInteger(String.valueOf(parent.getNode().size() + 1)));
        parent.getNode().add((Object)node);
        return node;
    }

    private void createSObjectNode(List<MdNode> reversedNodes) throws ReverseException {
        try {
            SFMetaData sfmd = this.connection.getMetaData();
            for (SFEntity e : sfmd.getEntities()) {
                MdNode tableNode = MdFactoryHelper.createMdNode((String)SF_SOBJECTS);
                tableNode.setSubstituteContainer((EObject)this.currentNode);
                tableNode.setName(e.getName());
                tableNode.setAttribute("label", e.getLabel(), false);
                tableNode.setAttribute("pluralLabel", e.getPluralLabel(), false);
                tableNode.setAttribute("keyPrefix", e.getKeyprefix(), false);
                tableNode.setAttribute("createable", "" + e.isCreateable(), false);
                tableNode.setAttribute("custom", "" + e.isCustom(), false);
                tableNode.setAttribute("deletable", "" + e.isDeletable(), false);
                tableNode.setAttribute("updatable", "" + e.isUpdatable(), false);
                reversedNodes.add(tableNode);
            }
        }
        catch (Exception ex) {
            throw new ReverseException(Messages.SalesForceReverse_1 + ex.getMessage(), ex);
        }
    }

    private boolean addReferenceResolver(Attribute attr, ReferenceResolver rr) {
        if (attr != null && attr.getTechProperty().getReverseUpdateXpathQuery() != null && !attr.getTechProperty().getReverseUpdateXpathQuery().isEmpty()) {
            List<ReferenceResolver> list = this.referenceResolver.get(attr);
            if (list == null) {
                list = new ArrayList<ReferenceResolver>();
                this.referenceResolver.put(attr, list);
            }
            list.add(rr);
            return true;
        }
        return false;
    }

    private void addFields(SFMetaData sfmd, List<MdNode> tableNodes) throws ReverseException {
        try {
            ArrayList<String> sObjectNodes = new ArrayList<String>(100);
            int i = 0;
            while (i < tableNodes.size()) {
                boolean gatherFields = false;
                sObjectNodes.add(tableNodes.get(i).getName());
                if (i == tableNodes.size() - 1 || sObjectNodes.size() % 100 == 0) {
                    gatherFields = true;
                }
                if ((sObjectNodes.size() % 100 != 0 || i == tableNodes.size() - 1) && i == tableNodes.size() - 1) {
                    sObjectNodes.add(tableNodes.get(i).getName());
                }
                if (gatherFields) {
                    Map fields = sfmd.getFields(sObjectNodes);
                    for (MdNode tableNode : tableNodes) {
                        if (fields.get(tableNode.getName()) == null) continue;
                        ArrayList<MdNode> list = new ArrayList<MdNode>();
                        int position = 1;
                        for (SFField f : (List)fields.get(tableNode.getName())) {
                            if (f.getType().equals("location")) continue;
                            MdNode fieldNode = MdFactoryHelper.createMdNode((String)SF_FIELD);
                            fieldNode.setSubstituteContainer((EObject)tableNode);
                            fieldNode.setName(f.getName());
                            fieldNode.setPosition(new BigInteger(String.valueOf(position++)));
                            fieldNode.setAttribute("label", f.getLabel(), false);
                            fieldNode.setAttribute("type", f.getType().replaceFirst("_", ""), false);
                            fieldNode.setAttribute("updateable", "" + f.isUpdateable(), false);
                            fieldNode.setAttribute("sortable", "" + f.isSortable(), false);
                            fieldNode.setAttribute("nillable", "" + f.isNillable(), false);
                            fieldNode.setAttribute("creatable", "" + f.isCreateable(), false);
                            fieldNode.setAttribute("groupable", "" + f.isGroupable(), false);
                            fieldNode.setAttribute("filterable", "" + f.isFilterable(), false);
                            fieldNode.setAttribute("custom", "" + f.isCustom(), false);
                            fieldNode.setAttribute("caseSensitive", "" + f.isCaseSensitive(), false);
                            fieldNode.setAttribute("externalId", "" + f.isExternalId(), false);
                            fieldNode.setAttribute("nameField", "" + f.isNameField(), false);
                            fieldNode.setAttribute("autoNumber", "" + f.isAutoNumber(), false);
                            fieldNode.setAttribute("unique", "" + f.isUnique(), false);
                            fieldNode.setAttribute("calculated", "" + f.isCalculated(), false);
                            fieldNode.setAttribute("byteLength", "" + f.getByteLength(), false);
                            fieldNode.setAttribute("defaultOnCreate", "" + f.isDefaultOnCreate(), false);
                            fieldNode.setAttribute("defaultValueFormula", f.getDefaultValueFormula(), false);
                            fieldNode.setAttribute("deleteOnCascade", "" + f.isDeleteOnCascade(), false);
                            fieldNode.setAttribute("dependPickList", "" + f.isDependPickList(), false);
                            fieldNode.setAttribute("digits", "" + f.getDigits(), false);
                            fieldNode.setAttribute("displayLocationInDecimal", "" + f.isDisplayLocationInDecimal(), false);
                            fieldNode.setAttribute("formula", f.getFormula(), false);
                            fieldNode.setAttribute("htmlFormated", "" + f.isHtmlFormatted(), false);
                            fieldNode.setAttribute("idLookup", "" + f.isIdLookup(), false);
                            fieldNode.setAttribute("inlineHelpText", f.getInlineHelpText(), false);
                            fieldNode.setAttribute("length", "" + f.getLength(), false);
                            fieldNode.setAttribute("precision", "" + f.getPrecision(), false);
                            fieldNode.setAttribute("relationshipName", f.getRelationshipName(), false);
                            fieldNode.setAttribute("relationshipOrder", "" + f.getRelationshipOrder(), false);
                            fieldNode.setAttribute("restrictedDelete", "" + f.isRestrictedDelete(), false);
                            fieldNode.setAttribute("restrictedPicklist", "" + f.isRestrictedPicklist(), false);
                            fieldNode.setAttribute("scale", "" + f.getScale(), false);
                            fieldNode.setAttribute("soapType", f.getSoapType(), false);
                            fieldNode.setAttribute("writeRequiresMasterRead", "" + f.isWriteRequiresMasterRead(), false);
                            list.add(fieldNode);
                            for (String ref : f.getReferences()) {
                                Property prop = fieldNode.getPropertyByShortCode("ref");
                                Attribute refAttr = fieldNode.getAttributeByShortCode("ref");
                                if (refAttr == null) {
                                    refAttr = MdFactory.eINSTANCE.createAttribute();
                                    refAttr.setDefType(prop.getFullCode());
                                    fieldNode.getAttribute().add((Object)refAttr);
                                }
                                HashMap<String, String> properties = new HashMap<String, String>();
                                properties.put("SOBJECT_NAME", ref);
                                this.addReferenceResolver(refAttr, new ReferenceResolver(properties, prop, null));
                            }
                        }
                        tableNode.getNode().addAll(list);
                    }
                    sObjectNodes.clear();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ReverseException(Messages.SalesForceReverse_113 + ex.getMessage(), ex);
        }
    }

    private void addExternalId(SFMetaData sfmd, List<MdNode> tableNodes) throws ReverseException {
        try {
            ArrayList<String> sObjectNodes = new ArrayList<String>(100);
            int i = 0;
            while (i < tableNodes.size()) {
                boolean gatherFields = false;
                sObjectNodes.add(tableNodes.get(i).getName());
                if (i == tableNodes.size() - 1 || sObjectNodes.size() % 100 == 0) {
                    gatherFields = true;
                }
                if ((sObjectNodes.size() % 100 != 0 || i == tableNodes.size() - 1) && i == tableNodes.size() - 1) {
                    sObjectNodes.add(tableNodes.get(i).getName());
                }
                if (gatherFields) {
                    Map fields = sfmd.getFields(sObjectNodes);
                    for (MdNode tableNode : tableNodes) {
                        if (fields.get(tableNode.getName()) == null) continue;
                        ArrayList<MdNode> list = new ArrayList<MdNode>();
                        for (SFField f : (List)fields.get(tableNode.getName())) {
                            if (!f.isExternalId()) continue;
                            MdNode fieldNode = MdFactoryHelper.createMdNode((String)SF_EXTERNALID);
                            fieldNode.setSubstituteContainer((EObject)tableNode);
                            fieldNode.setName(f.getName());
                            list.add(fieldNode);
                        }
                        tableNode.getNode().addAll(list);
                    }
                    sObjectNodes.clear();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ReverseException(Messages.SalesForceReverse_114 + ex.getMessage(), ex);
        }
    }

    public AttributeRefResolver getAttributeRefResolver() {
        return new AttributeRefResolver(){

            public List<Object> resolve(MdNode context, Attribute attribute) {
                Property prop = attribute.getTechProperty();
                ArrayList<Object> result = new ArrayList<Object>();
                List<ReferenceResolver> rrs = SalesForceReverse.this.referenceResolver.get(attribute);
                if (rrs != null) {
                    for (ReferenceResolver rr : rrs) {
                        if (rr == null) continue;
                        String query = prop.getReverseUpdateXpathQuery();
                        Pattern pDeb = Pattern.compile("\\{reverse:([A-Za-z0-9_]*)\\(\\)\\}");
                        Matcher mDeb = pDeb.matcher(query);
                        if (rr.properties != null) {
                            while (mDeb.find()) {
                                String grp1 = mDeb.group(1);
                                String replaceBy = rr.properties.get(grp1);
                                replaceBy = replaceBy == null ? "" : replaceBy;
                                query = query.replaceAll("\\{reverse:" + grp1 + "\\(\\)\\}", replaceBy);
                            }
                        }
                        try {
                            List list;
                            if (prop.getType().equals((Object)PropertyType.REFERENCE)) {
                                list = (List)context.evaluateMdSet(query);
                                for (Object elt : list) {
                                    result.add(elt);
                                }
                                continue;
                            }
                            list = (List)context.evaluateMdStringList(query);
                            for (Object elt : list) {
                                result.add(elt);
                            }
                        }
                        catch (XPathExpressionException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.addons.salesforce", Messages.SalesForceReverse_119, (Throwable)e));
                            SalesForceReverse.this.logger.warn("unexpected", (Throwable)e);
                        }
                    }
                }
                return result;
            }
        };
    }

    public List<Attribute> getMandatoryField() {
        return null;
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.logout();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.addons.salesforce", Messages.SalesForceReverse_120, (Throwable)e));
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    private class ReferenceResolver {
        Property property;
        Map<String, String> properties;
        MdNode node;

        public ReferenceResolver(Map<String, String> properties, Property property, MdNode node) {
            this.property = property;
            this.properties = properties;
            this.node = node;
        }
    }
}

