/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.table.storage.runtime;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableServiceClient;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.data.tables.models.ListEntitiesOptions;
import com.azure.data.tables.models.TableEntity;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.common.tools.impl.JavaRealObjectHandler;
import com.semarchy.xdi.component.azure.table.storage.runtime.AzureTableQueryMetadata;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AzureTableQueryTransformer
implements JavaRealObjectHandler<Map<String, Object>, AzureTableQueryMetadata> {
    private TableServiceClient tableServiceClient;
    private TableClient tableClient;

    public int batchSize() {
        return 0;
    }

    public void handleObject(Map<String, Object> exchange, AzureTableQueryMetadata metadata, OutputStreamTransformer.StatisticHandler sh) throws Exception {
        ListEntitiesOptions query = new ListEntitiesOptions();
        if (metadata.getFilter() != null && !metadata.getFilter().isEmpty()) {
            query.setFilter(metadata.getFilter());
        }
        if (metadata.getTop() != null && !metadata.getTop().isEmpty()) {
            Integer top = Integer.parseInt(metadata.getTop());
            query.setTop(top);
        }
        if (metadata.getSelect() != null && !metadata.getSelect().isEmpty()) {
            query.setSelect(Arrays.asList(metadata.getSelect().split(",")));
        }
        Duration timeout = null;
        if (metadata.getTimeout() != null && !metadata.getTimeout().isEmpty()) {
            timeout = Duration.ofMillis(Long.parseLong(metadata.getTimeout()));
        }
        PagedIterable entities = this.tableClient.listEntities(query, timeout, null);
        ArrayList results = new ArrayList();
        PagedResponse firstPage = (PagedResponse)entities.iterableByPage().iterator().next();
        for (TableEntity entity : firstPage.getElements()) {
            HashMap<String, String> mapEntity = new HashMap<String, String>();
            mapEntity.put("rowKey", entity.getRowKey());
            mapEntity.put("partitionKey", entity.getPartitionKey());
            for (Map.Entry entry : entity.getProperties().entrySet()) {
                mapEntity.put((String)entry.getKey(), entry.getValue().toString());
            }
            results.add(mapEntity);
        }
        exchange.put("result", results);
    }

    public void close() throws Exception {
    }

    public void init(AzureTableQueryMetadata metadata, JavaObjectHandler.InitHandler handler) throws Exception {
        this.tableServiceClient = new TableServiceClientBuilder().connectionString(metadata.getConnectionString()).buildClient();
        this.tableClient = this.tableServiceClient.getTableClient(metadata.getTableName());
    }
}

