/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.elasticsearch;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.internal.JsonNodeToObject;
import com.stambia.elasticsearch.Messages;
import com.stambia.elasticsearch.client.IClient;
import com.stambia.elasticsearch.objects.HitWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;

public abstract class ElasticSearchOperation {
    boolean interrupt = false;
    List<InternalTransportAddresse> transportAddresses = new ArrayList<InternalTransportAddresse>();
    private String query;
    private String[] indexes;
    protected String[] types;
    private int searchSize;
    private SearchType searchType;
    private int keepAlive;
    private int searchFrom;
    protected Class<?> pluginClass;
    private final Logger logger = LogManager.getLogger(ElasticSearchOperation.class);
    int batchSize;
    String index;
    String type;
    protected IClient client;
    BulkRequest bulkRequest;
    boolean already = false;
    List<Object> items;
    Map<String, Object> mapItems;
    JsonNodeToObject.JsonNodeToObjectHandler internalSearchHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){

        private void addField(String key, Object value) {
            ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)key));
            if (value instanceof String) {
                ElasticSearchOperation.this.jew.add(JSonEvent.createString((String)((String)value)));
            } else {
                ElasticSearchOperation.this.jew.add(JSonEvent.createValue((String)String.valueOf(value)));
            }
        }

        private void searchSourceBuilder(SearchRequest sr, Map<String, Object> map) {
            Object o;
            Object currentObject;
            SearchSourceBuilder ssb = ElasticSearchOperation.this.getSearchSourceBuilder(sr);
            try {
                ssb.from(((BigInteger)map.get("from")).intValue());
            }
            catch (Exception e) {
                try {
                    ssb.from(((Integer)map.get("from")).intValue());
                }
                catch (Exception e2) {
                    ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e2);
                }
            }
            try {
                ssb.size(((BigInteger)map.get("size")).intValue());
            }
            catch (Exception e) {
                try {
                    ssb.size(((Integer)map.get("size")).intValue());
                }
                catch (Exception e2) {
                    ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e2);
                }
            }
            try {
                ElasticSearchOperation.this.setTimeout(ssb, map.get("timeout"));
            }
            catch (Exception e) {
                ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e);
            }
            try {
                ssb.terminateAfter(((BigInteger)map.get("terminate_after")).intValue());
            }
            catch (Exception e) {
                try {
                    ssb.terminateAfter(((Integer)map.get("terminate_after")).intValue());
                }
                catch (Exception e2) {
                    ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e2);
                }
            }
            try {
                currentObject = map.get("query");
                if (currentObject != null) {
                    ElasticSearchOperation.this.setQuery(ssb, (Map)map.get("query"));
                }
            }
            catch (Exception e) {
                ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e);
            }
            try {
                currentObject = map.get("post_filter");
                if (currentObject != null) {
                    ElasticSearchOperation.this.setPostFilter(ssb, (Map)map.get("post_filter"));
                }
            }
            catch (Exception e) {
                ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e);
            }
            try {
                ssb.minScore((float)((BigInteger)map.get("min_score")).intValue());
            }
            catch (Exception e) {
                try {
                    ssb.minScore((float)((Integer)map.get("min_score")).intValue());
                }
                catch (Exception e2) {
                    ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e2);
                }
            }
            try {
                currentObject = map.get("version");
                if (currentObject != null) {
                    ssb.version((Boolean)map.get("version"));
                }
            }
            catch (Exception e) {
                ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e);
            }
            try {
                Object currentOject = map.get("explain");
                if (currentOject != null) {
                    ssb.explain((Boolean)map.get("explain"));
                }
            }
            catch (Exception e) {
                ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e);
            }
            if ((currentObject = map.get("_source")) != null) {
                try {
                    ssb.fetchSource(((Boolean)map.get("_source")).booleanValue());
                }
                catch (Exception e) {
                    ssb.fetchSource(true);
                    Map currentSource = (Map)map.get("_source");
                    Object currentIncludes = currentSource.get("includes");
                    Object currentExcludes = currentSource.get("excludes");
                    String[] includes = new String[]{};
                    String[] excludes = new String[]{};
                    if (currentIncludes instanceof String) {
                        includes = new String[]{(String)currentIncludes};
                    } else if (currentIncludes instanceof List) {
                        includes = new String[((List)currentIncludes).size()];
                        ((List)currentIncludes).toArray(includes);
                    }
                    if (currentExcludes instanceof String) {
                        excludes = new String[]{(String)currentExcludes};
                    } else if (currentExcludes instanceof List) {
                        excludes = new String[((List)currentExcludes).size()];
                        ((List)currentExcludes).toArray(excludes);
                    }
                    ssb.fetchSource(includes, excludes);
                }
            }
            if ((o = map.get("fields")) instanceof String) {
                ElasticSearchOperation.this.setFields(ssb, (String)o);
            } else if (o instanceof List) {
                ElasticSearchOperation.this.setFields(ssb, (List)o);
            }
            try {
                Object localObject = map.get("track_scores");
                if (localObject != null) {
                    ssb.trackScores(((Boolean)map.get("track_scores")).booleanValue());
                }
            }
            catch (Exception e) {
                ElasticSearchOperation.this.logger.debug("unexpected", (Throwable)e);
            }
        }

        public void handleNode(Object node) throws IOException {
            boolean newMode = true;
            Map map = (Map)node;
            ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Object val;
                if (((String)entry.getKey()).equals("query") || ((String)entry.getKey()).equals("hints") || ((String)entry.getKey()).equals("aggregations") || (val = entry.getValue()) == null) continue;
                this.addField((String)entry.getKey(), val);
                if (val instanceof String) {
                    inputParams.put((String)entry.getKey(), "\"" + String.valueOf(val) + "\"");
                    continue;
                }
                inputParams.put((String)entry.getKey(), val.toString());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                JsonUtils.convertJsonToXml((InputStream)new ByteArrayInputStream(ElasticSearchOperation.this.query.getBytes(StandardCharsets.UTF_8)), (OutputStream)os, (String)StandardCharsets.UTF_8.toString(), (String)StandardCharsets.UTF_8.toString(), (boolean)false, inputParams);
                ByteArrayOutputStream os2 = new ByteArrayOutputStream();
                JsonUtils.convertXmlToJson((InputStream)new ByteArrayInputStream(os.toByteArray()), (OutputStream)os2, (String)StandardCharsets.UTF_8.toString(), (String)StandardCharsets.UTF_8.toString());
                String currentQuery = new String(os2.toByteArray());
                Map currentSource = (Map)JsonUtils.jsonNodeToObject((String)currentQuery);
                boolean hasAggegations = currentSource.get("aggregations") != null || currentSource.get("aggs") != null;
                boolean scroll = true;
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.indices(ElasticSearchOperation.this.indexes);
                this.searchSourceBuilder(searchRequest, currentSource);
                if (ElasticSearchOperation.this.getVersion() < 7) {
                    searchRequest.types(ElasticSearchOperation.this.types);
                }
                if (scroll) {
                    searchRequest.scroll(new TimeValue((long)ElasticSearchOperation.this.keepAlive));
                    if (ElasticSearchOperation.this.searchSize <= -1) {
                        boolean bl;
                        boolean bl2 = bl = currentSource.get("size") != null;
                    }
                    if (ElasticSearchOperation.this.searchType == null) {
                        if (!hasAggegations) {
                            searchRequest.searchType(ElasticSearchOperation.this.getSearchType());
                        }
                    } else {
                        searchRequest.searchType(ElasticSearchOperation.this.searchType);
                    }
                }
                searchRequest.searchType(ElasticSearchOperation.this.getSearchType());
                searchRequest.indices(ElasticSearchOperation.this.indexes);
                SearchResponse searchResponse = ElasticSearchOperation.this.getClient().search(searchRequest);
                if (!newMode) {
                    ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)"response"));
                    ElasticSearchOperation.this.jew.add(JSonEvent.createStartArray());
                }
                boolean hitsOpen = false;
                Object[] nextHits = null;
                long hits = 0L;
                do {
                    if (ElasticSearchOperation.this.isInterrupt()) {
                        throw new InterruptedException();
                    }
                    if (!newMode) {
                        ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
                    }
                    if (!newMode) {
                        this.addField("took", searchResponse.getTook().getMillis());
                        this.addField("timed_out", searchResponse.isTimedOut());
                        ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)"_shards"));
                        ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
                        this.addField("total", searchResponse.getTotalShards());
                        this.addField("successful", searchResponse.getSuccessfulShards());
                        this.addField("failed", searchResponse.getFailedShards());
                        ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
                    }
                    if (nextHits == null) {
                        nextHits = ElasticSearchOperation.this.getHits(searchResponse);
                    }
                    int currentHits = 0;
                    if (nextHits.length > 0) {
                        if (!newMode) {
                            ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)"hits"));
                            ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
                        }
                        if (!newMode) {
                            this.addField("total", nextHits.length);
                        }
                        if (!newMode || newMode && !hitsOpen) {
                            ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)"hits"));
                            ElasticSearchOperation.this.jew.add(JSonEvent.createStartArray());
                            hitsOpen = true;
                        }
                        HitWrapper hitWrapper = ElasticSearchOperation.this.getHitWrapper();
                        Object[] objectArray = nextHits;
                        int n = nextHits.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object hit = objectArray[n2];
                            if (ElasticSearchOperation.this.hitLimtSize == -1 || ++hits <= (long)ElasticSearchOperation.this.hitLimtSize) {
                                ++currentHits;
                                hitWrapper.setHit(hit);
                                if (ElasticSearchOperation.this.isInterrupt()) {
                                    throw new InterruptedException();
                                }
                                if (!hitWrapper.isSourceEmpty()) {
                                    ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
                                    this.addField("index", hitWrapper.getIndex());
                                    this.addField("type", hitWrapper.getType());
                                    this.addField("id", hitWrapper.getId());
                                    this.addField("score", Float.valueOf(hitWrapper.getScore()));
                                    ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)"document"));
                                    if (ElasticSearchOperation.this.parseHit) {
                                        ElasticSearchOperation.this.writeHandler.handleNode((Object)JsonNode.parse((String)new String(hitWrapper.source(), StandardCharsets.UTF_8), (String)StandardCharsets.UTF_8.toString()));
                                    } else {
                                        ElasticSearchOperation.this.jew.add(JSonEvent.createValue((String)new String(hitWrapper.source(), StandardCharsets.UTF_8)));
                                    }
                                    ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
                                }
                            }
                            ++n2;
                        }
                    }
                    if (!newMode) {
                        ElasticSearchOperation.this.jew.add(JSonEvent.createEndArray());
                    }
                    if (!newMode) {
                        ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
                    }
                    ElasticSearchOperation.this.getHandler().handle("ESEARCH_HIT", (long)currentHits);
                    Aggregations aggrs = searchResponse.getAggregations();
                    if (aggrs != null) {
                        List aggrss = aggrs.asList();
                        if (!aggrss.isEmpty()) {
                            ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)"aggregations"));
                            ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
                            for (Aggregation aggr : aggrs.asList()) {
                                Terms term = (Terms)aggr;
                                ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)term.getName()));
                                ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
                                this.addField("doc_count_error_upper_bound", term.getDocCountError());
                                this.addField("sum_other_doc_count", term.getSumOfOtherDocCounts());
                                ElasticSearchOperation.this.jew.add(JSonEvent.createMember((String)"buckets"));
                                ElasticSearchOperation.this.jew.add(JSonEvent.createStartArray());
                                for (Terms.Bucket bucket : term.getBuckets()) {
                                    ElasticSearchOperation.this.jew.add(JSonEvent.createStartObject());
                                    this.addField("key", bucket.getKey());
                                    this.addField("doc_count", bucket.getDocCount());
                                    ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
                                }
                                ElasticSearchOperation.this.jew.add(JSonEvent.createEndArray());
                                ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
                                if (!ElasticSearchOperation.this.isInterrupt()) continue;
                                throw new InterruptedException();
                            }
                        }
                        ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
                    }
                    if (!newMode) {
                        ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
                    }
                    if (searchResponse.getAggregations() != null || ElasticSearchOperation.this.hitLimtSize > -1 && hits >= (long)ElasticSearchOperation.this.hitLimtSize) break;
                    searchResponse = ElasticSearchOperation.this.getClient().scroll(searchResponse);
                } while (scroll && (nextHits = ElasticSearchOperation.this.getHits(searchResponse)).length != 0);
                if (newMode && hitsOpen) {
                    ElasticSearchOperation.this.jew.add(JSonEvent.createEndArray());
                }
                if (!newMode) {
                    ElasticSearchOperation.this.jew.add(JSonEvent.createEndArray());
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            ElasticSearchOperation.this.jew.add(JSonEvent.createEndObject());
        }

        public void handleEnd() {
        }
    };
    JsonNodeToObject.JsonNodeToObjectHandler currentDeleteHandler = new BaseJsonNodeToObjectHandler(this){

        @Override
        protected void batch(boolean last) throws Exception {
            if (items.size() == batchSize || last && !items.isEmpty()) {
                BulkResponse bulkResponse = this.getClient().bulk(bulkRequest);
                if (bulkResponse.hasFailures()) {
                    throw new RuntimeException(bulkResponse.buildFailureMessage());
                }
                int delete = 0;
                BulkItemResponse[] bulkItemResponseArray = bulkResponse.getItems();
                int n = bulkItemResponseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BulkItemResponse item = bulkItemResponseArray[n2];
                    String id = item.getId();
                    Object _o = items.get(item.getItemId());
                    ((Map)_o).put("id", id);
                    ((Map)_o).put("index", item.getIndex());
                    ((Map)_o).put("type", item.getType());
                    ((Map)_o).put("version", item.getVersion());
                    boolean isFound = this.isDeletedFound(item);
                    ((Map)_o).put("found", isFound);
                    if (isFound) {
                        ++delete;
                    }
                    writeHandler.handleNode(_o);
                    ++n2;
                }
                this.getHandler().handle("ESEARCH_DELETE", (long)delete);
                items.clear();
                if (bulkRequest != null && bulkRequest.requests() != null) {
                    bulkRequest.requests().clear();
                }
            }
        }

        @Override
        protected void doHandleNode(Object node, Map source, String key, String currentIndex, String currentType, String currentRouting) throws Exception {
            DeleteRequest deleteRequest = new DeleteRequest();
            deleteRequest.id(key);
            deleteRequest.index(currentIndex);
            deleteRequest.type(currentType);
            deleteRequest.routing(currentRouting);
            if (bulkRequest == null) {
                bulkRequest = new BulkRequest();
            }
            bulkRequest.add(deleteRequest);
            items.add(node);
        }
    };
    JsonNodeToObject.JsonNodeToObjectHandler currentGetHandler = new BaseJsonNodeToObjectHandler(this){

        @Override
        protected void batch(boolean last) throws Exception {
            if (mapItems.size() == batchSize || last && mapItems.size() > 0) {
                MultiGetResponse multiGetResponse = this.getClient().multiGet(multiGetRequest);
                int found = 0;
                MultiGetItemResponse[] multiGetItemResponseArray = multiGetResponse.getResponses();
                int n = multiGetItemResponseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MultiGetItemResponse item = multiGetItemResponseArray[n2];
                    Object currentObject = mapItems.get(item.getId());
                    GetResponse gr = item.getResponse();
                    if (gr.isExists()) {
                        if (currentObject == null) {
                            throw new RuntimeException(Messages.getString("ElasticSearchOperation.4"));
                        }
                        ((Map)currentObject).put("index", item.getIndex());
                        ((Map)currentObject).put("type", item.getType());
                        ((Map)currentObject).put("version", gr.getVersion());
                        ((Map)currentObject).put("found", gr.isExists());
                        if (gr.isExists()) {
                            ++found;
                        }
                        ((Map)currentObject).put("document", gr.getSource());
                    }
                    writeHandler.handleNode(currentObject);
                    ++n2;
                }
                this.getHandler().handle("ESEARCH_GET", (long)found);
                mapItems.clear();
                if (multiGetRequest != null && multiGetRequest.getItems() != null) {
                    multiGetRequest.getItems().clear();
                }
            }
        }

        @Override
        protected void doHandleNode(Object node, Map source, String key, String currentIndex, String currentType, String currentRouting) throws Exception {
            if (multiGetRequest == null) {
                multiGetRequest = new MultiGetRequest();
            }
            if (currentRouting != null) {
                MultiGetRequest.Item getItem = new MultiGetRequest.Item(index, type, key);
                getItem.routing(currentRouting);
                multiGetRequest.add(getItem);
            } else {
                multiGetRequest.add(currentIndex, currentType, key);
            }
            mapItems.put(key, node);
        }
    };
    JsonNodeToObject.JsonNodeToObjectHandler currentInsertHandler = new BaseJsonNodeToObjectHandler(this){

        @Override
        public void handleNode(Object o) throws Exception {
            Map map = (Map)o;
            String key = (String)map.get("id");
            String _index = (String)map.get("index");
            String _type = (String)map.get("type");
            String _routing = (String)map.get("routing");
            if (_index == null) {
                _index = index;
            }
            if (_type == null) {
                _type = type;
            }
            if (this.getVersion() >= 7) {
                _type = null;
            }
            String parent = (String)map.get("parent");
            Map source = (Map)map.get("document");
            IndexRequest indexRequest = new IndexRequest();
            indexRequest.id(key);
            indexRequest.index(_index);
            indexRequest.type(_type);
            indexRequest.routing(_routing);
            indexRequest.source(source, XContentType.JSON);
            if (bulkRequest == null) {
                bulkRequest = new BulkRequest();
            }
            bulkRequest.add(indexRequest);
            items.add(o);
            this.batch(false);
        }

        @Override
        protected void batch(boolean last) throws Exception {
            if (items.size() == batchSize || last && !items.isEmpty()) {
                BulkResponse bulkResponse = this.getClient().bulk(bulkRequest);
                if (bulkResponse.hasFailures()) {
                    for (Object _o : items) {
                        writeHandler.handleNode(_o);
                    }
                    throw new RuntimeException(bulkResponse.buildFailureMessage());
                }
                int created = 0;
                int updated = 0;
                BulkItemResponse[] bulkItemResponseArray = bulkResponse.getItems();
                int n = bulkItemResponseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BulkItemResponse item = bulkItemResponseArray[n2];
                    String id = item.getId();
                    Object currentObject = items.get(item.getItemId());
                    ((Map)currentObject).put("id", id);
                    ((Map)currentObject).put("index", item.getIndex());
                    ((Map)currentObject).put("type", item.getType());
                    ((Map)currentObject).put("version", item.getVersion());
                    boolean isCreated = this.isIndexCreated(item);
                    ((Map)currentObject).put("created", isCreated);
                    if (isCreated) {
                        ++created;
                    } else {
                        ++updated;
                    }
                    writeHandler.handleNode(currentObject);
                    ++n2;
                }
                this.getHandler().handle("ESEARCH_INSERT", (long)created);
                this.getHandler().handle("ESEARCH_UPDATE", (long)updated);
                items.clear();
                if (bulkRequest != null && bulkRequest.requests() != null) {
                    bulkRequest.requests().clear();
                }
            }
        }

        @Override
        protected void doHandleNode(Object node, Map source, String key, String currentIndex, String currentType, String currentRouting) throws Exception {
            IndexRequest indexRequest = new IndexRequest();
            indexRequest.id(key);
            indexRequest.index(currentIndex);
            indexRequest.type(currentType);
            indexRequest.routing(currentRouting);
            indexRequest.source(source, XContentType.JSON);
            if (bulkRequest == null) {
                bulkRequest = new BulkRequest();
            }
            bulkRequest.add(indexRequest);
            items.add(node);
        }
    };
    JsonNodeToObject.JsonNodeToObjectHandler currentUpdateHandler = new BaseJsonNodeToObjectHandler(this){

        @Override
        protected void batch(boolean last) throws Exception {
            if (items.size() == batchSize || last && !items.isEmpty()) {
                BulkResponse bulkResponse = this.getClient().bulk(bulkRequest);
                if (bulkResponse.hasFailures()) {
                    for (Object _o : items) {
                        writeHandler.handleNode(_o);
                    }
                    throw new RuntimeException(bulkResponse.buildFailureMessage());
                }
                int created = 0;
                int updated = 0;
                BulkItemResponse[] bulkItemResponseArray = bulkResponse.getItems();
                int n = bulkItemResponseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BulkItemResponse item = bulkItemResponseArray[n2];
                    String id = item.getId();
                    Object currentObject = items.get(item.getItemId());
                    ((Map)currentObject).put("id", id);
                    ((Map)currentObject).put("index", item.getIndex());
                    ((Map)currentObject).put("type", item.getType());
                    ((Map)currentObject).put("version", item.getVersion());
                    ((Map)currentObject).put("created", this.isUpdateCreated(item));
                    if (this.isUpdateCreated(item)) {
                        ++created;
                    } else {
                        ++updated;
                    }
                    writeHandler.handleNode(currentObject);
                    ++n2;
                }
                this.getHandler().handle("ESEARCH_INSERT", (long)created);
                this.getHandler().handle("ESEARCH_UPDATE", (long)updated);
                items.clear();
                if (bulkRequest != null && bulkRequest.requests() != null) {
                    bulkRequest.requests().clear();
                }
            }
        }

        @Override
        protected void doHandleNode(Object node, Map source, String key, String currentIndex, String currentType, String currentRouting) throws Exception {
            UpdateRequest updateRequest = new UpdateRequest();
            if (op == Operator.upsert) {
                IndexRequest indexRequest = new IndexRequest();
                indexRequest.source(source, XContentType.JSON);
                updateRequest.upsert(indexRequest);
            }
            updateRequest.id(key);
            updateRequest.index(currentIndex);
            updateRequest.type(currentType);
            updateRequest.routing(currentRouting);
            updateRequest.doc(source, XContentType.JSON);
            if (bulkRequest == null) {
                bulkRequest = new BulkRequest();
            }
            bulkRequest.add(updateRequest);
            items.add(node);
        }
    };
    JsonNodeToObject.JsonNodeToObjectHandler writeHandler;
    private MultiGetRequest multiGetRequest;
    Operator op;
    JsonEventWriter jew;
    protected OutputStreamTransformer.OutputStreamTransformerStatisticHandler handler;
    boolean parseHit = false;
    int hitLimtSize = -1;

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public ElasticSearchOperation(int batchSize, String index, Operator op, String query, int from, int size, SearchType searchType, int keepAlive, Map<String, Object> props, String pluginClassName, OutputStreamTransformer.OutputStreamTransformerStatisticHandler handler) throws Exception {
        this.handler = handler;
        this.batchSize = batchSize;
        if (batchSize < 1) {
            throw new RuntimeException(Messages.getString("ElasticSearchOperation.0"));
        }
        if (index != null) {
            if (index.contains(",") && op != Operator.search) {
                throw new RuntimeException(op.name() + Messages.getString("ElasticSearchOperation.1"));
            }
            this.indexes = index.split(",");
        } else {
            this.indexes = new String[0];
        }
        this.index = index;
        if (op == Operator.search && (query == null || query.isEmpty())) {
            throw new RuntimeException(op.name() + Messages.getString("ElasticSearchOperation.2"));
        }
        this.op = op;
        this.query = query;
        this.searchFrom = from;
        this.searchSize = size;
        this.searchType = searchType;
        this.keepAlive = keepAlive;
        if (pluginClassName != null && !pluginClassName.isEmpty()) {
            try {
                this.pluginClass = Class.forName(pluginClassName);
            }
            catch (ClassNotFoundException e) {
                this.logger.error("cannot instantiate plugin {}", (Object)pluginClassName, (Object)e);
            }
        }
    }

    public IClient getClient() {
        return this.client;
    }

    public void execute(InputStream is, String encoding, OutputStream os, String outEncoding) throws Exception {
        if (this.op == Operator.delete) {
            this.items = new ArrayList<Object>();
            this.bulk(is, encoding, this.currentDeleteHandler, os, outEncoding);
        } else if (this.op == Operator.get) {
            this.mapItems = new HashMap<String, Object>();
            this.bulk(is, encoding, this.currentGetHandler, os, outEncoding);
        } else if (this.op == Operator.insert) {
            this.items = new ArrayList<Object>();
            this.bulk(is, encoding, this.currentInsertHandler, os, outEncoding);
        } else if (this.op == Operator.update || this.op == Operator.upsert) {
            this.items = new ArrayList<Object>();
            this.bulk(is, encoding, this.currentUpdateHandler, os, outEncoding);
        } else if (this.op == Operator.search) {
            this.items = new ArrayList<Object>();
            this.bulk(is, encoding, this.internalSearchHandler, os, outEncoding);
        }
    }

    public Settings getSettings(String className, Map<String, Object> prop) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> settingClass = Class.forName(className);
        Method settingsBuilderMethod = settingClass.getMethod("settingsBuilder", new Class[0]);
        Class<?> settingsBuilderClass = Class.forName(className + "$Builder");
        Object settingsBuilderObject = settingsBuilderMethod.invoke(null, new Object[0]);
        Method settingsBuilderPutMethodString = settingsBuilderClass.getMethod("put", String.class, String.class);
        Method settingsBuilderPutMethodBoolean = settingsBuilderClass.getMethod("put", String.class, Boolean.TYPE);
        if (prop != null) {
            for (Map.Entry<String, Object> entry : prop.entrySet()) {
                if (entry.getValue() instanceof Boolean) {
                    settingsBuilderPutMethodBoolean.invoke(settingsBuilderObject, entry.getKey(), entry.getValue());
                    continue;
                }
                settingsBuilderPutMethodString.invoke(settingsBuilderObject, entry.getKey(), entry.getValue());
            }
        }
        Method settingsBuilderBuildMethod = settingsBuilderClass.getMethod("build", new Class[0]);
        return (Settings)settingsBuilderBuildMethod.invoke(settingsBuilderObject, new Object[0]);
    }

    private void bulk(InputStream is, String encoding, JsonNodeToObject.JsonNodeToObjectHandler handler, OutputStream os, String outEncoding) throws Exception {
        if (this.already) {
            throw new RuntimeException(Messages.getString("ElasticSearchOperation.7"));
        }
        this.already = true;
        HashMap map = new HashMap();
        try {
            this.jew = new JsonEventWriter(os, outEncoding);
            this.jew.add(JSonEvent.createStartArray());
            this.writeHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){

                public void handleNode(Object node) {
                    try {
                        JsonNode.serialize((Object)node, (JsonEventWriter)ElasticSearchOperation.this.jew);
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void handleEnd() {
                }
            };
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("DECIMAL_AS_DOUBLE", true);
            properties.put("INTEGER_AS_LONG", true);
            if (this.op == Operator.search) {
                boolean foundOneOrMore = JsonUtils.jsonNodeToObject((InputStream)is, (String)encoding, (String)"*/*", (JsonNodeToObject.JsonNodeToObjectHandler)handler, properties);
                if (!foundOneOrMore) {
                    JsonUtils.jsonNodeToObject((InputStream)new ByteArrayInputStream("[{}]".getBytes(encoding)), (String)encoding, (String)"*/*", (JsonNodeToObject.JsonNodeToObjectHandler)handler, properties);
                }
            } else {
                JsonUtils.jsonNodeToObject((InputStream)is, (String)encoding, (String)"*/*", (JsonNodeToObject.JsonNodeToObjectHandler)handler, properties);
            }
        }
        finally {
            try {
                this.jew.add(JSonEvent.createEndArray());
                this.jew.close();
            }
            catch (Exception e) {
                this.logger.debug("unexpected", (Throwable)e);
            }
            this.getClient().close();
        }
    }

    protected static boolean isRestHttpProtocol(String protocol) {
        return protocol.equalsIgnoreCase("HTTP/REST");
    }

    protected void setFields(SearchSourceBuilder ssb, List list) {
        ssb.storedFields(list);
    }

    protected void setFields(SearchSourceBuilder ssb, String o) {
        ssb.storedField(o);
    }

    protected void setPostFilter(SearchSourceBuilder ssb, Map map) throws XMLStreamException {
        if (map != null) {
            JsonNode jn = JsonNode.parse((Object)map);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonNode.serialize((JsonNode)jn, (OutputStream)baos, (String)StandardCharsets.UTF_8.toString());
            String str = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            WrapperQueryBuilder qb = QueryBuilders.wrapperQuery((String)str);
            ssb.postFilter((QueryBuilder)qb);
        }
    }

    protected void setQuery(SearchSourceBuilder ssb, Map map) throws XMLStreamException {
        if (map != null) {
            JsonNode jn = JsonNode.parse((Object)map);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonNode.serialize((JsonNode)jn, (OutputStream)baos, (String)StandardCharsets.UTF_8.toString());
            String str = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            WrapperQueryBuilder qb = QueryBuilders.wrapperQuery((String)str);
            ssb.query((QueryBuilder)qb);
        }
    }

    protected void setTimeout(SearchSourceBuilder ssb, Object timeout) {
        if (timeout != null) {
            if (timeout instanceof Integer) {
                ssb.timeout(TimeValue.timeValueMillis((long)((Integer)timeout).longValue()));
            } else if (timeout instanceof BigInteger) {
                ssb.timeout(TimeValue.timeValueMillis((long)((BigInteger)timeout).longValue()));
            } else {
                ssb.timeout(TimeValue.timeValueMillis((long)Long.valueOf((String)timeout)));
            }
        }
    }

    protected SearchSourceBuilder getSearchSourceBuilder(SearchRequest request) {
        SearchSourceBuilder source = new SearchSourceBuilder();
        request.source(source);
        return source;
    }

    protected SearchType getSearchType() {
        return SearchType.DEFAULT;
    }

    protected OutputStreamTransformer.OutputStreamTransformerStatisticHandler getHandler() {
        return this.handler;
    }

    protected boolean isDeletedFound(BulkItemResponse item) throws Exception {
        return ((DeleteResponse)item.getResponse()).status() == RestStatus.OK;
    }

    protected boolean isIndexCreated(BulkItemResponse item) throws Exception {
        return item.status() == RestStatus.CREATED;
    }

    protected boolean isUpdateCreated(BulkItemResponse item) throws Exception {
        return item.status() == RestStatus.CREATED;
    }

    protected Object[] getHits(SearchResponse scrollResp) throws Exception {
        SearchHits currentHit = scrollResp.getHits();
        Method method = currentHit.getClass().getMethod("getHits", new Class[0]);
        return (Object[])method.invoke((Object)currentHit, new Object[0]);
    }

    protected abstract HitWrapper getHitWrapper();

    protected abstract int getVersion();

    public void setParseHit(boolean parseHit) {
        this.parseHit = parseHit;
    }

    public void setHitLimtSize(int hitLimtSize) {
        this.hitLimtSize = hitLimtSize;
    }

    private abstract class BaseJsonNodeToObjectHandler
    implements JsonNodeToObject.JsonNodeToObjectHandler {
        private BaseJsonNodeToObjectHandler() {
        }

        public void handleNode(Object node) throws Exception {
            Map map = (Map)node;
            String key = (String)map.get("id");
            String currentIndex = map.getOrDefault("index", ElasticSearchOperation.this.index);
            String currentType = ElasticSearchOperation.this.getVersion() >= 7 ? null : map.getOrDefault("type", ElasticSearchOperation.this.type);
            String currentRouting = (String)map.get("routing");
            if (key == null) {
                throw new RuntimeException(Messages.getString("ElasticSearchOperation.6"));
            }
            Map source = (Map)map.get("document");
            this.doHandleNode(node, source, key, currentIndex, currentType, currentRouting);
            this.batch(false);
        }

        protected abstract void doHandleNode(Object var1, Map var2, String var3, String var4, String var5, String var6) throws Exception;

        public final void handleEnd() throws Exception {
            this.batch(true);
        }

        protected abstract void batch(boolean var1) throws Exception;
    }

    class InternalTransportAddresse {
        String host;
        int port;

        InternalTransportAddresse() {
        }
    }

    static enum Operator {
        get,
        update,
        insert,
        delete,
        search,
        upsert;

    }
}

