/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.elasticsearch;

import com.indy.engine.common.tools.HackedOutputStreamTransformer;
import com.semarchy.xdi.elasticsearch.core.Authentication;
import com.semarchy.xdi.elasticsearch.core.SslStore;
import com.stambia.elasticsearch.ElasticSearchOperation;
import com.stambia.elasticsearch.ElasticSearchOperationV7;
import com.stambia.elasticsearch.Messages;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchType;

public class ElasticSearchOutputStreamTransformer
extends HackedOutputStreamTransformer {
    ElasticSearchOperation esb;

    public String getProperty(String key, boolean mustExists, String defaultValue) {
        String str = this.getProperty(key);
        if (str == null && mustExists && defaultValue == null) {
            throw new RuntimeException(Messages.getString("ElasticSearchOutputStreamTransformer.0") + key + Messages.getString("ElasticSearchOutputStreamTransformer.1"));
        }
        if (str == null) {
            str = defaultValue;
        }
        return str;
    }

    public void interrupt() {
        if (this.esb != null) {
            this.esb.interrupt();
        }
    }

    public void transform(InputStream inputStream, OutputStream outputStream) throws Exception {
        int version = this.getVersion(this.getProperty("version"));
        String transportAddresses = this.getProperty("transportAddresses", version < 5, null);
        String protocol = this.getProperty("protocol", version > 7, "Transport");
        String httpUrl = this.getProperty("httpUrl", false, null);
        String clusterName = this.getProperty("cluster", false, null);
        int batchSize = Integer.valueOf(this.getProperty("batchSize", false, "100"));
        ElasticSearchOperation.Operator operator = ElasticSearchOperation.Operator.valueOf(this.getProperty("operator", false, "get"));
        String index = this.getProperty("indexes", operator != ElasticSearchOperation.Operator.search, null);
        String type = this.getProperty("types", operator != ElasticSearchOperation.Operator.search, null);
        String query = this.getProperty("query", operator == ElasticSearchOperation.Operator.search, null);
        String _from = this.getProperty("searchFrom", false, null);
        int from = _from == null ? 0 : Integer.valueOf(_from);
        String _size = this.getProperty("searchSize", false, null);
        int size = _size == null ? -1 : Integer.valueOf(_size);
        String _searchType = this.getProperty("searchType", false, "AUTO");
        if (_searchType.equals("AUTO")) {
            _searchType = null;
        }
        SearchType searchType = _searchType != null ? SearchType.valueOf((String)_searchType) : null;
        String _keepAlive = this.getProperty("keepAliveTime", false, null);
        String _parseHit = this.getProperty("parseHit", false, "false");
        boolean parseHit = _parseHit != null ? Boolean.valueOf(_parseHit) : false;
        String _hitLimtSize = this.getProperty("hitLimitSize", false, "-1");
        int hitLimtSize = _hitLimtSize != null ? Integer.valueOf(_hitLimtSize) : -1;
        boolean securityEnable = Boolean.valueOf(this.getProperty("securityEnable", false, "false"));
        String securityPluginClass = this.getProperty("securityPluginClass", false, null);
        String keystoreFilepath = this.getProperty("keystoreFilepath", false, null);
        String keystoreType = this.getProperty("keystoreType", false, null);
        String keystorePassword = this.getProperty("keystorePassword", false, null);
        SslStore.Store keyStore = new SslStore.Store(keystoreFilepath, keystoreType, keystorePassword);
        String truststoreFilepath = this.getProperty("truststoreFilepath", false, null);
        String truststoreType = this.getProperty("truststoreType", false, null);
        String truststorePassword = this.getProperty("truststorePassword", false, null);
        SslStore.Store trustStore = new SslStore.Store(truststoreFilepath, truststoreType, truststorePassword);
        boolean enableCertificateValidation = Boolean.valueOf(this.getProperty("enableCertificateValidation", false, "true"));
        SslStore sslStore = new SslStore(keyStore, trustStore, enableCertificateValidation);
        String authenticationMethod = this.getProperty("authenticationMethod", false, null);
        boolean useApiKey = "API Key".equals(authenticationMethod);
        String idMarkup = useApiKey ? "apiKeyId" : "httpUser";
        String secretMarkup = useApiKey ? "apiKeySecret" : "httpPassword";
        String id = this.getProperty(idMarkup, false, null);
        String secret = this.getProperty(secretMarkup, false, null);
        Authentication authentication = new Authentication(useApiKey, id, secret);
        if (!securityEnable) {
            securityPluginClass = null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : this.getProperties()) {
            String key;
            if (entry.getValue() == null || entry.getValue().isEmpty() || !entry.getKey().startsWith("property.") || (key = entry.getKey().substring(9)).startsWith("searchguard.ssl.transport.") && !securityEnable) continue;
            if (entry.getValue().equals("true") || entry.getValue().equals("false")) {
                props.put(key, (boolean)Boolean.valueOf(entry.getValue()));
                continue;
            }
            props.put(key, entry.getValue());
        }
        int keepAlive = _keepAlive == null ? 60000 : Integer.valueOf(_keepAlive);
        this.esb = new ElasticSearchOperationV7(transportAddresses, clusterName, batchSize, index, type, operator, query, from, size, searchType, keepAlive, props, securityPluginClass, httpUrl, authentication, protocol, this.getStatisticHandler(), sslStore);
        this.esb.setParseHit(parseHit);
        this.esb.setHitLimtSize(hitLimtSize);
        this.esb.execute(inputStream, "UTF-8", outputStream, "UTF-8");
    }

    private int getVersion(String versionStr) throws NumberFormatException {
        int version;
        if (versionStr == null || versionStr.isEmpty()) {
            return -1;
        }
        try {
            version = Integer.valueOf(versionStr);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(Messages.getString("ElasticSearchOutputStreamTransformer.2"));
        }
        if (version <= 4) {
            return 2;
        }
        if (version >= 7) {
            return 7;
        }
        return version;
    }
}

