/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.elasticsearch.client;

import com.semarchy.xdi.elasticsearch.core.Authentication;
import com.semarchy.xdi.elasticsearch.core.SslStore;
import com.stambia.elasticsearch.client.HttpRestClient;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;

public class HttpRestClientV7
extends HttpRestClient {
    public static final TimeValue timeValue = new TimeValue(600000L);

    public HttpRestClientV7(String httpUrl, Authentication authentication, SslStore sslStore) throws Exception {
        RestClientBuilder restClientBuilder = HttpRestClient.getRestClientBuilder(httpUrl, authentication, sslStore);
        this.client = new RestHighLevelClient(restClientBuilder);
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws Exception {
        return this.client.search(searchRequest, RequestOptions.DEFAULT);
    }

    @Override
    public SearchResponse scroll(SearchResponse searchResponse) throws Exception {
        String scrollId = searchResponse.getScrollId();
        if (scrollId != null) {
            SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId).scroll(timeValue);
            searchResponse = this.client.scroll(searchScrollRequest, RequestOptions.DEFAULT);
        }
        return searchResponse;
    }

    @Override
    public BulkResponse bulk(BulkRequest bulkRequest) throws Exception {
        return this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
    }

    @Override
    public MultiGetResponse multiGet(MultiGetRequest multiGetRequest) throws Exception {
        return this.client.multiGet(multiGetRequest, RequestOptions.DEFAULT);
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

