/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.elasticsearch.client;

import com.stambia.elasticsearch.client.Messages;
import com.stambia.elasticsearch.client.TransportClient;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;

public class TransportClientV7
extends TransportClient {
    public TransportClientV7(Class plugin, String transportAdresses, String clusterName, Map<String, Object> prop) throws Exception {
        Settings settings = null;
        boolean useXpackTransport = false;
        Settings.Builder b = Settings.builder();
        if (prop != null) {
            for (Map.Entry<String, Object> entry : prop.entrySet()) {
                if (entry.getKey().startsWith("xpack.")) {
                    useXpackTransport = true;
                }
                if (entry.getValue() instanceof String) {
                    b.put(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    b.put(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    b.put(entry.getKey(), ((Double)entry.getValue()).doubleValue());
                    continue;
                }
                if (entry.getValue() instanceof Float) {
                    b.put(entry.getKey(), ((Float)entry.getValue()).floatValue());
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    b.put(entry.getKey(), ((Integer)entry.getValue()).intValue());
                    continue;
                }
                if (entry.getValue() instanceof Path) {
                    b.put(entry.getKey(), (Path)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof TimeValue) {
                    b.put(entry.getKey(), (TimeValue)entry.getValue());
                    continue;
                }
                throw new Exception(Messages.getString("TransportClientV7.0"));
            }
        }
        if (clusterName != null && !clusterName.isEmpty()) {
            b.put("cluster.name", clusterName);
        }
        settings = b.build();
        this.client = plugin != null ? (useXpackTransport ? new PreBuiltXPackTransportClient(settings, new Class[]{plugin}) : new PreBuiltTransportClient(settings, new Class[]{plugin})) : (useXpackTransport ? new PreBuiltXPackTransportClient(settings, new Class[0]) : new PreBuiltTransportClient(settings, new Class[0]));
        String[] stringArray = transportAdresses.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String transportAdresse = stringArray[n2];
            String[] split = transportAdresse.split(":");
            String host = split[0];
            int port = split.length >= 2 ? Integer.valueOf(split[1]) : 9300;
            this.client.addTransportAddress(new TransportAddress(InetAddress.getByName(host), port));
            ++n2;
        }
    }
}

