/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.cmis.action;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ExecuteException;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectToCMIS {
    private static final Logger LOGGER = LogManager.getLogger(ConnectToCMIS.class);

    private ConnectToCMIS() {
    }

    public static Session connectToCMIS(MdNode node) throws ExecuteException, XPathExpressionException {
        return ConnectToCMIS.connectToCMIS(node, node.evaluate("ancestor-or-self::*/@cmisRepositoryId"));
    }

    public static Session connectToCMIS(MdNode node, String repository) throws ExecuteException {
        try {
            String url = node.evaluate("ancestor-or-self::*/@cmisUrl");
            String user = node.evaluate("ancestor-or-self::*/@cmisUser");
            String password = node.evaluate("ancestor-or-self::*/@cmisPassword");
            if (password != null && !password.isEmpty()) {
                try {
                    String decrypt;
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    password = decrypt = semaphoreManager.getStringAsciiInfo(password);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot decrypt password", (Throwable)e);
                }
            }
            SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("org.apache.chemistry.opencmis.user", user);
            parameter.put("org.apache.chemistry.opencmis.password", password);
            parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameter.put("org.apache.chemistry.opencmis.session.repository.id", repository);
            parameter.put("org.apache.chemistry.opencmis.binding.readtimeout", "10000");
            Session session = factory.createSession(parameter);
            return session;
        }
        catch (Exception e) {
            if (e instanceof ExecuteException) {
                throw (ExecuteException)e;
            }
            throw new ExecuteException(e);
        }
    }
}

