/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.cmis.action;

import com.indy.addons.cmis.action.ConnectToCMIS;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocAction
implements IExecute {
    private final Logger logger = LogManager.getLogger(this.getClass());
    Session session;
    Map<String, Integer> names = new HashMap<String, Integer>();

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        try {
            this.reverse(node);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
        return null;
    }

    public void reverse(MdNode node) throws XPathExpressionException, ExecuteException, ReverseException {
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        String url = node.evaluate("ancestor-or-self::*/@cmisUrl");
        String user = node.evaluate("ancestor-or-self::*/@cmisUser");
        String password = node.evaluate("ancestor-or-self::*/@cmisPassword");
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        if (password != null && !password.isEmpty()) {
            try {
                String decrypt;
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                password = decrypt = semaphoreManager.getStringAsciiInfo(password);
            }
            catch (Exception e) {
                this.logger.warn("Error while decrypting password", (Throwable)e);
            }
        }
        parameter.put("org.apache.chemistry.opencmis.user", user);
        parameter.put("org.apache.chemistry.opencmis.password", password);
        parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameter.put("org.apache.chemistry.opencmis.binding.readtimeout", "10000");
        List lr = factory.getRepositories(parameter);
        HashMap<MdNode, MdNode> toReverse = new HashMap<MdNode, MdNode>();
        for (Repository repo : lr) {
            this.session = ConnectToCMIS.connectToCMIS(node, repo.getId());
            MdNode repositoryNode = this.reverseRepository(node);
            repositoryNode.setAttribute("cmisRepositoryId", repo.getId(), false);
            if (repo.getName().isEmpty() || repo.getName() == null) {
                repositoryNode.setName(repo.getId());
            } else {
                repositoryNode.setName(repo.getName());
            }
            nodes.add(repositoryNode);
            toReverse.put(repositoryNode, node.getNodeByName(repositoryNode.getDefType(), repositoryNode.getName()));
        }
        IncrementalReverser ir = new IncrementalReverser((EObject)node, toReverse, Collections.EMPTY_LIST, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
    }

    public MdNode reverseRepository(MdNode parentNode) throws XPathExpressionException {
        MdNode repositoryNode = MdFactoryHelper.createMdNode((String)"com.stambia.cmis.repository");
        repositoryNode.setSubstituteContainer((EObject)parentNode);
        MdNode container = this.reverseTypeContainer(repositoryNode, "cmis:folder");
        repositoryNode.getNode().add((Object)container);
        container = this.reverseTypeContainer(repositoryNode, "cmis:document");
        repositoryNode.getNode().add((Object)container);
        container = this.reverseTypeContainer(repositoryNode, "cmis:secondary");
        repositoryNode.getNode().add((Object)container);
        container = this.reverseTypeContainer(repositoryNode, "cmis:relationship");
        repositoryNode.getNode().add((Object)container);
        return repositoryNode;
    }

    public MdNode reverseTypeContainer(MdNode parentNode, String typeId) throws XPathExpressionException {
        ObjectType rootDocumentType = this.session.getTypeDefinition(typeId);
        MdNode current = this.reverseDocument(parentNode, rootDocumentType.getId(), typeId);
        parentNode.getNode().add((Object)current);
        return current;
    }

    public MdNode reverseDocument(MdNode parentNode, String documentTypeId, String baseTypeId) throws XPathExpressionException {
        MdNode documentNode = MdFactoryHelper.createMdNode((String)"com.stambia.cmis.document");
        documentNode.setSubstituteContainer((EObject)parentNode);
        this.names.clear();
        ObjectType rootDocumentType = this.session.getTypeDefinition(documentTypeId);
        Map propertyDefinitions = rootDocumentType.getPropertyDefinitions();
        int i = 0;
        int namePos = i++;
        int objectIdPos = i++;
        ArrayList<String> str = new ArrayList<String>();
        if (baseTypeId.equals("cmis:document")) {
            str.add("Local Folder Path");
            str.add("Local File Name");
            str.add("Mime Type");
        }
        if (baseTypeId.equals("cmis:document") || baseTypeId.equals("cmis:folder")) {
            str.add("Remote New Name");
            str.add("Remote Folder Path");
            str.add("Remote Folder Id");
            str.add("Remote New Folder Path");
            str.add("Remote New Folder Id");
            str.add("Version State");
            str.add("Operation");
            str.add("Exchange State");
            str.add("Exchange Message");
            str.add("Where Clause");
        }
        Object[] objectArray = str.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            MdNode iproperty = MdFactoryHelper.createMdNode((String)"com.stambia.cmis.document.internalProperty");
            iproperty.setName((String)name);
            iproperty.setPosition(BigInteger.valueOf(i++));
            documentNode.getNode().add((Object)iproperty);
            ++n2;
        }
        List l = (List)parentNode.evaluateMdStringList("ancestor-or-self::object/property/@name");
        for (PropertyDefinition proDef : propertyDefinitions.values()) {
            MdNode property;
            if (l.contains(proDef.getId()) || !baseTypeId.equals("cmis:document") && !baseTypeId.equals("cmis:folder") && (!baseTypeId.equals("cmis:relationship") || !proDef.getId().equals("cmis:targetId") && !proDef.getId().equals("cmis:sourceId")) && (proDef.getId().startsWith("cmis:") || proDef.getId().startsWith("alfcmis:"))) continue;
            if (proDef.getCardinality().toString().equals("MULTI")) {
                property = MdFactoryHelper.createMdNode((String)"com.stambia.cmis.document.property");
                property.setSubstituteContainer((EObject)documentNode);
                property.setName(proDef.getId());
                property.setAttribute("cmisPropertyId", proDef.getId(), false);
                property.setAttribute("cmisName", this.generateName(proDef.getDisplayName()), false);
                property.setAttribute("type", proDef.getPropertyType().toString().toLowerCase(), false);
                property.setAttribute("cmisUpdatability", proDef.getUpdatability().toString().toUpperCase(), false);
                documentNode.getNode().add((Object)property);
                MdNode propertyItem = MdFactoryHelper.createMdNode((String)"com.stambia.cmis.document.propertyItem");
                property.getNode().add((Object)propertyItem);
                propertyItem.setName("item");
            } else {
                property = MdFactoryHelper.createMdNode((String)"com.stambia.cmis.document.property");
                property.setSubstituteContainer((EObject)documentNode);
                property.setName(proDef.getId());
                property.setAttribute("cmisPropertyId", proDef.getId(), false);
                property.setAttribute("cmisName", this.generateName(proDef.getDisplayName()), false);
                property.setAttribute("type", proDef.getPropertyType().toString().toLowerCase(), false);
                property.setAttribute("cmisUpdatability", proDef.getUpdatability().toString().toUpperCase(), false);
                documentNode.getNode().add((Object)property);
            }
            if (proDef.getId().equals("cmis:name")) {
                property.setPosition(BigInteger.valueOf(namePos));
                continue;
            }
            if (proDef.getId().equals("cmis:objectId")) {
                property.setPosition(BigInteger.valueOf(objectIdPos));
                continue;
            }
            property.setPosition(BigInteger.valueOf(i));
        }
        documentNode.setName(rootDocumentType.getId());
        documentNode.setAttribute("cmisName", rootDocumentType.getDisplayName(), false);
        documentNode.setAttribute("cmisObjectTypeId", rootDocumentType.getId(), false);
        documentNode.setAttribute("cmisQueryName", rootDocumentType.getQueryName(), false);
        ItemIterable listTypes = rootDocumentType.getChildren();
        for (ObjectType type : listTypes) {
            this.reverseTypeContainer(documentNode, type.getId());
        }
        return documentNode;
    }

    public String generateName(String currentName) {
        if (this.names.containsKey(currentName)) {
            int nb = this.names.get(currentName) + 1;
            this.names.put(currentName, nb);
            return currentName + " " + nb;
        }
        this.names.put(currentName, 1);
        return currentName;
    }
}

