/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.vertica.export.objects.definitions;

import com.indy.engine.addons.vertica.export.objects.definitions.TableDefinition;

public class TableColumnDefinition {
    private String columnName = "";
    private String datatypeFullString = "";
    private int columnSize = 0;
    private boolean isNullable = true;
    private int ordinalPosition = 0;
    private String defaultValue = "";

    protected void renameTable(String oldSchemaName, String oldTableName, String newSchemaName, String newTableName, TableDefinition baseTable) {
        if (this.defaultValue != null && this.defaultValue.length() > 0) {
            for (TableColumnDefinition columnToReplace : baseTable.getColumns()) {
                String oldColumnPattern = "(^|[\\W])(" + oldTableName + "\\." + columnToReplace.getColumnName() + ")($|[\\W])";
                String newColumnPattern = "$1" + newTableName + "\\." + columnToReplace.getColumnName() + "$3";
                this.defaultValue = this.defaultValue.replaceAll(oldColumnPattern, newColumnPattern);
            }
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public void setColumnSize(String columnSize) {
        this.columnSize = Integer.parseInt(columnSize);
    }

    public String getDatatypeFullString() {
        return this.datatypeFullString;
    }

    public String getDatatypeShortString() {
        if (this.datatypeFullString != null) {
            return this.datatypeFullString.replaceAll("^([a-zA-Z]*).*", "$1");
        }
        return null;
    }

    public void setDatatypeFullString(String datatypeFullString) {
        this.datatypeFullString = datatypeFullString;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isComplexDatatype() {
        return this.getDatatypeShortString().equalsIgnoreCase("ARRAY") || this.getDatatypeShortString().equalsIgnoreCase("ROW");
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }
}

