/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.vertica.export.objects.definitions;

import com.indy.engine.addons.vertica.export.objects.definitions.PrimaryKeyDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.ProjectionDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.TableColumnDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.UniqueKeyDefinition;
import java.util.ArrayList;
import java.util.List;

public class TableDefinition {
    private String schemaName = "";
    private String tableName = "";
    private String partitionExpression = "";
    private List<TableColumnDefinition> columns = new ArrayList<TableColumnDefinition>();
    private List<ProjectionDefinition> projections;
    private PrimaryKeyDefinition primaryKey = null;
    private List<UniqueKeyDefinition> uniqueKeys = new ArrayList<UniqueKeyDefinition>();

    public TableDefinition() {
        this.projections = new ArrayList<ProjectionDefinition>();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTablePath() {
        if (this.getSchemaName() == null || this.getSchemaName().length() == 0) {
            return this.getTableName();
        }
        return this.getSchemaName() + "." + this.getTableName();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addColumn(TableColumnDefinition column) {
        this.columns.add(column);
    }

    public String formatColumnList(List<TableColumnDefinition> colList, String delimiter, boolean includeColName, boolean includeDatatypeFullString, boolean includeDatatypeShortString, boolean includeSize, boolean includeNullable, boolean includeDefault, boolean includeOrdinalPosition) {
        if (colList != null && !colList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < colList.size()) {
                TableColumnDefinition col = colList.get(i);
                if (includeColName) {
                    sb.append(col.getColumnName());
                    sb.append(" ");
                }
                if (includeDatatypeFullString) {
                    sb.append(col.getDatatypeFullString());
                    sb.append(" ");
                }
                if (includeDatatypeShortString) {
                    sb.append(col.getDatatypeShortString());
                    sb.append(" ");
                }
                if (includeSize) {
                    sb.append(col.getColumnSize());
                    sb.append(" ");
                }
                if (includeNullable && !col.isComplexDatatype()) {
                    if (col.isNullable()) {
                        sb.append("NULL");
                    } else {
                        sb.append("NOT NULL");
                    }
                    sb.append(" ");
                }
                if (includeDefault && col.getDefaultValue() != null && col.getDefaultValue().trim().length() > 0) {
                    sb.append("DEFAULT ");
                    sb.append(col.getDefaultValue());
                    sb.append(" ");
                }
                if (includeOrdinalPosition) {
                    sb.append(col.getOrdinalPosition());
                    sb.append(" ");
                }
                if (i < colList.size() - 1) {
                    sb.append(delimiter);
                }
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    public List<TableColumnDefinition> getColumns() {
        return this.getColumns("");
    }

    public List<TableColumnDefinition> getColumns(String ignoredColumnNames) {
        ArrayList<String> ignoredColumnList = new ArrayList<String>();
        String[] ignoredColumnsArray = ignoredColumnNames.split(",");
        if (ignoredColumnsArray != null && ignoredColumnsArray.length > 0) {
            String[] stringArray = ignoredColumnsArray;
            int n = ignoredColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String colName = stringArray[n2];
                if (colName != null && colName.trim().length() > 0) {
                    ignoredColumnList.add(colName.trim());
                }
                ++n2;
            }
        }
        return this.getColumns(ignoredColumnList);
    }

    public List<TableColumnDefinition> getColumns(List<String> ignoredColumnList) {
        ArrayList<TableColumnDefinition> retColumns = new ArrayList<TableColumnDefinition>();
        int i = 0;
        while (i < this.columns.size()) {
            if (!ignoredColumnList.contains(this.columns.get(i).getColumnName())) {
                retColumns.add(this.columns.get(i));
            }
            ++i;
        }
        return retColumns;
    }

    public TableColumnDefinition getColumn(String columnName) {
        for (TableColumnDefinition col : this.columns) {
            if (!columnName.equals(col.getColumnName())) continue;
            return col;
        }
        return null;
    }

    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    public void setPartitionExpression(String partitionExpression) {
        this.partitionExpression = partitionExpression;
    }

    public void addProjection(ProjectionDefinition projection) {
        this.projections.add(projection);
    }

    public List<ProjectionDefinition> getProjections() {
        return new ArrayList<ProjectionDefinition>(this.projections);
    }

    public ProjectionDefinition getProjection(String projectionName) {
        for (ProjectionDefinition prj : this.projections) {
            if (!projectionName.equals(prj.getProjectionName())) continue;
            return prj;
        }
        return null;
    }

    public ProjectionDefinition getProjection(String schemaName, String projectionName) {
        for (ProjectionDefinition prj : this.projections) {
            if (!projectionName.equals(prj.getProjectionName()) || !schemaName.equals(prj.getSchemaName())) continue;
            return prj;
        }
        return null;
    }

    protected void renameTable(String oldSchemaName, String oldTableName, String newSchemaName, String newTableName) {
        if (this.partitionExpression != null && this.partitionExpression.length() > 0) {
            for (TableColumnDefinition columnToReplace : this.columns) {
                String oldColumnPattern = "(^|[\\W])(" + oldTableName + "\\." + columnToReplace.getColumnName() + ")($|[\\W])";
                String newColumnPattern = "$1" + newTableName + "\\." + columnToReplace.getColumnName() + "$3";
                this.partitionExpression = this.partitionExpression.replaceAll(oldColumnPattern, newColumnPattern);
            }
        }
        this.setSchemaName(newSchemaName);
        this.setTableName(newTableName);
    }

    public TableDefinition renameTable(String newSchemaName, String newTableName) {
        String oldTableName = this.getTableName();
        String oldSchemaName = this.getSchemaName();
        this.renameTable(oldSchemaName, oldTableName, newSchemaName, newTableName);
        for (TableColumnDefinition columnToReplace : this.columns) {
            columnToReplace.renameTable(oldSchemaName, oldTableName, newSchemaName, newTableName, this);
        }
        for (ProjectionDefinition projectionToReplace : this.projections) {
            projectionToReplace.renameTable(oldSchemaName, oldTableName, newSchemaName, newTableName, this);
        }
        return this;
    }

    public String getCreateTableDDL(boolean includePartition) {
        return this.getCreateTableDDL(includePartition, "");
    }

    public String getCreateTableDDL(String ignoredColumnList) {
        return this.getCreateTableDDL(false, ignoredColumnList);
    }

    public String getCreateTableDDL(List<String> ignoredColumnList) {
        return this.getCreateTableDDL(false, ignoredColumnList);
    }

    private String getCreateTableDDL(boolean includePartition, String ignoredColumnList) {
        ArrayList<String> columnList = new ArrayList<String>();
        String[] ignoredColumnsArray = ignoredColumnList.split(",");
        if (ignoredColumnsArray != null && ignoredColumnsArray.length > 0) {
            String[] stringArray = ignoredColumnsArray;
            int n = ignoredColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String colName = stringArray[n2];
                if (colName != null && colName.trim().length() > 0) {
                    columnList.add(colName.trim());
                }
                ++n2;
            }
        }
        return this.getCreateTableDDL(includePartition, columnList);
    }

    private String getCreateTableDDL(boolean includePartition, List<String> ignoredColumnList) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.getTablePath());
        sb.append("\n");
        sb.append("(\n");
        sb.append(this.formatColumnList(this.getColumns(ignoredColumnList), ",\n", true, true, false, false, true, true, false));
        sb.append(")");
        sb.append("\n");
        if (includePartition) {
            if (!ignoredColumnList.isEmpty()) {
                throw new RuntimeException("When including partitions is not supported with ignoredColumnList non empty");
            }
            if (this.getPartitionExpression() != null && this.getPartitionExpression().trim().length() > 0) {
                sb.append("PARTITION BY ");
                sb.append(this.getPartitionExpression());
            }
        }
        return sb.toString();
    }

    public String getCreateProjectionsDDL(String statementSeparator) {
        StringBuilder sb = new StringBuilder();
        if (!this.getProjections().isEmpty()) {
            int i = 0;
            while (i < this.getProjections().size()) {
                sb.append(this.getProjections().get(i).getCreateProjectionDDL());
                if (i < this.getProjections().size() - 1) {
                    sb.append(statementSeparator);
                }
                sb.append("\n");
                ++i;
            }
        }
        return sb.toString();
    }

    public String getCreateProjectionsDDL2(String statementSeparator) {
        StringBuilder sb = new StringBuilder();
        if (!this.getProjections().isEmpty()) {
            int i = 0;
            while (i < this.getProjections().size()) {
                sb.append(this.getProjections().get(i).getCreateProjectionDDL2());
                if (i < this.getProjections().size() - 1) {
                    sb.append(statementSeparator);
                }
                sb.append("\n");
                ++i;
            }
        }
        return sb.toString();
    }

    private int getProjectionRanking(ProjectionDefinition projectionDefinition) {
        int ranking = 0;
        if (!projectionDefinition.isSuperProjection()) {
            ranking += 999;
        }
        if (this.columns.size() != projectionDefinition.getColumns().size()) {
            ranking += 999;
        }
        if (projectionDefinition.isTopK()) {
            ranking += 999;
        }
        if (projectionDefinition.hasWhereClause()) {
            ranking += 999;
        }
        if (projectionDefinition.isAggregate()) {
            ranking += 999;
        }
        if (projectionDefinition.hasOverClause()) {
            ranking += 999;
        }
        if (!projectionDefinition.isSegmented()) {
            ++ranking;
        }
        ArrayList<String> tableColumnNames = new ArrayList<String>();
        for (TableColumnDefinition tableColumnDefinition : this.getColumns()) {
            tableColumnNames.add(tableColumnDefinition.getColumnName().trim());
        }
        ArrayList<String> projectionColumnNames = new ArrayList<String>();
        for (String selectExpression : projectionDefinition.getSelectExpressions()) {
            selectExpression = selectExpression.replace(projectionDefinition.getMainTableAlias() + ".", "");
            if ((selectExpression = selectExpression.trim()).contains(" ")) {
                selectExpression = selectExpression.substring(0, selectExpression.indexOf(" "));
            }
            selectExpression = selectExpression.trim();
            projectionColumnNames.add(selectExpression);
        }
        for (String selectExpression : projectionColumnNames) {
            if (tableColumnNames.contains(selectExpression)) {
                tableColumnNames.remove(selectExpression);
                continue;
            }
            ++ranking;
        }
        return ranking += tableColumnNames.size();
    }

    public TableDefinition keepOnlyOneSuperProjection() {
        int currentRanking = Integer.MAX_VALUE;
        ProjectionDefinition currentProjection = null;
        for (ProjectionDefinition projectionDefinition : this.getProjections()) {
            int tmpRanking = this.getProjectionRanking(projectionDefinition);
            if (tmpRanking >= currentRanking) continue;
            currentRanking = tmpRanking;
            currentProjection = projectionDefinition;
        }
        this.projections = new ArrayList<ProjectionDefinition>();
        if (currentProjection != null) {
            this.projections.add(currentProjection);
        }
        return this;
    }

    public TableDefinition setColumnsNull() {
        for (TableColumnDefinition tableColumnDefinition : this.getColumns()) {
            tableColumnDefinition.setNullable(true);
        }
        return this;
    }

    public PrimaryKeyDefinition getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKeyDefinition primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<UniqueKeyDefinition> getUniqueKeys() {
        return new ArrayList<UniqueKeyDefinition>(this.uniqueKeys);
    }

    public void addUniqueKey(UniqueKeyDefinition uniqueKey) {
        this.uniqueKeys.add(uniqueKey);
    }
}

