/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.rdbms.cassandra.reverse;

import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CassandraMetaDataVisitor {
    public List<Keyspace> visit(Metadata md) {
        ArrayList<Keyspace> keySpaces = new ArrayList<Keyspace>();
        Map keyspaces = md.getKeyspaces();
        keyspaces.values().stream().forEach(k -> {
            boolean bl = keySpaces.add(Keyspace.of(k));
        });
        return keySpaces;
    }

    public void visit(Keyspace k) {
        HashSet<Datastore> tables = new HashSet<Datastore>();
        k.md.getTables().values().forEach(t -> {
            boolean bl = tables.add(Datastore.of(t));
        });
        k.md.getViews().values().forEach(t -> {
            boolean bl = tables.add(Datastore.of(t));
        });
        k.tables = tables;
    }

    public void visit(Datastore datastore) {
        if (!datastore.visited) {
            List<ColumnMetadata> fkColsMd = datastore.md.getColumns().values().stream().filter(cMd -> CassandraMetaDataVisitor.isComplexDatatype(cMd.getType()) || CassandraMetaDataVisitor.isUserDefinedDatatype(cMd.getType())).collect(Collectors.toList());
            datastore.md.getColumns().values().stream().filter(cMd -> !fkColsMd.contains(cMd)).forEach(cMd -> {
                boolean bl = datastore.columns.add(Column.of(cMd));
            });
            datastore.md.getPrimaryKey().stream().filter(cMd -> !fkColsMd.contains(cMd)).forEach(cMd -> {
                boolean bl = datastore.pk.add(Column.of(cMd));
            });
            fkColsMd.forEach(c -> {
                boolean bl = datastore.fk.add(Column.of(c));
            });
            datastore.visited = true;
        }
    }

    static boolean isComplexDatatype(DataType t) {
        return t instanceof CustomType || t instanceof ListType || t instanceof MapType || t instanceof SetType || t instanceof TupleType;
    }

    static boolean isUserDefinedDatatype(DataType t) {
        return t instanceof UserDefinedType;
    }

    public static abstract class AbstractDatastore {
        protected DatastoreType type;
        protected Collection<Column> columns = new ArrayList<Column>();
        protected List<Column> pk = new ArrayList<Column>();
        protected List<Column> fk = new ArrayList<Column>();

        public Collection<Column> getColumn() {
            return this.columns;
        }

        public List<Column> getPrimaryKey() {
            return this.pk;
        }

        public List<Column> getForeignKey() {
            return this.fk;
        }

        public DatastoreType getType() {
            return this.type;
        }

        public abstract String getName();
    }

    public static class Column {
        protected ColumnMetadata md;

        public static Column of(ColumnMetadata md) {
            Column col = new Column();
            col.md = md;
            return col;
        }

        public String getType() {
            return this.md.getType().toString();
        }

        public String getName() {
            return this.md.getName().toString();
        }
    }

    public static class Datastore
    extends AbstractDatastore {
        private RelationMetadata md;
        private boolean visited;

        private static Datastore of(TableMetadata md) {
            Datastore res = new Datastore();
            res.md = md;
            res.type = DatastoreType.TABLE;
            return res;
        }

        private static Datastore of(ViewMetadata md) {
            Datastore res = new Datastore();
            res.md = md;
            res.type = DatastoreType.VIEW;
            return res;
        }

        @Override
        public String getName() {
            return this.md.getName().toString();
        }
    }

    public static enum DatastoreType {
        TABLE,
        VIEW;

    }

    public static class Keyspace {
        private Collection<Datastore> tables;
        private KeyspaceMetadata md;

        private static Keyspace of(KeyspaceMetadata md) {
            Keyspace res = new Keyspace();
            res.md = md;
            return res;
        }

        public String getName() {
            return this.md.getName().toString();
        }

        public Collection<Datastore> getDatastore() {
            return this.tables;
        }
    }

    public static class VirtualDatastore
    extends AbstractDatastore {
        String name;

        VirtualDatastore(String name) {
            this.name = name;
            this.type = DatastoreType.TABLE;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

