/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.rdbms.cassandra.reverse;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.indy.addons.rdbms.cassandra.reverse.CassandraMetaDataVisitor;
import java.util.ArrayList;
import java.util.List;

public class ForeignKeysVisitor {
    List<CassandraMetaDataVisitor.VirtualDatastore> satelliteDatastores = new ArrayList<CassandraMetaDataVisitor.VirtualDatastore>();

    public void visit(CassandraMetaDataVisitor.Datastore owner, CassandraMetaDataVisitor.Column col) {
        if (col.md.getType() instanceof SetType) {
            this.visitSet(owner, col);
        } else if (col.md.getType() instanceof ListType) {
            this.visitList(owner, col);
        } else if (col.md.getType() instanceof MapType) {
            this.visitMap(owner, col);
        } else if (col.md.getType() instanceof TupleType) {
            this.visitTuple(owner, col);
        } else if (col.md.getType() instanceof UserDefinedType) {
            this.handleUserDefintedType(owner, col, (UserDefinedType)col.md.getType());
        }
    }

    private void handleUserDefintedType(CassandraMetaDataVisitor.AbstractDatastore owner, CassandraMetaDataVisitor.Column originCol, UserDefinedType udt) {
        int i = 0;
        while (i < udt.getFieldNames().size()) {
            DataType t = (DataType)udt.getFieldTypes().get(i);
            String colName = originCol.getName() + "_" + ((CqlIdentifier)udt.getFieldNames().get(i)).toString();
            owner.columns.add(VirtualColumn.of(colName, t));
            ++i;
        }
    }

    private void visitSet(CassandraMetaDataVisitor.AbstractDatastore owner, CassandraMetaDataVisitor.Column col) {
        SetType type = (SetType)col.md.getType();
        CassandraMetaDataVisitor.VirtualDatastore satellite = new CassandraMetaDataVisitor.VirtualDatastore(owner.getName() + "_vt_" + col.getName());
        owner.getPrimaryKey().forEach(c -> {
            boolean bl = virtualDatastore.pk.add(CassandraMetaDataVisitor.Column.of(c.md));
        });
        VirtualColumn value = null;
        if (CassandraMetaDataVisitor.isComplexDatatype(type.getElementType())) {
            value = VirtualColumn.of(col.getName() + "_value", "varchar");
        } else if (CassandraMetaDataVisitor.isUserDefinedDatatype(type.getElementType())) {
            this.handleUserDefintedType(satellite, col, (UserDefinedType)type.getElementType());
        } else {
            value = VirtualColumn.of(col.getName() + "_value", type.getElementType());
        }
        satellite.columns.addAll(satellite.pk);
        if (value != null) {
            satellite.columns.add(value);
            satellite.pk.add(value);
        }
        this.satelliteDatastores.add(satellite);
    }

    private void visitList(CassandraMetaDataVisitor.AbstractDatastore owner, CassandraMetaDataVisitor.Column col) {
        ListType type = (ListType)col.md.getType();
        CassandraMetaDataVisitor.VirtualDatastore satellite = new CassandraMetaDataVisitor.VirtualDatastore(owner.getName() + "_vt_" + col.getName());
        owner.getPrimaryKey().forEach(c -> {
            boolean bl = virtualDatastore.pk.add(CassandraMetaDataVisitor.Column.of(c.md));
        });
        VirtualColumn index = VirtualColumn.of(col.getName() + "_index", "SQL_INTEGER");
        VirtualColumn value = null;
        if (CassandraMetaDataVisitor.isComplexDatatype(type.getElementType())) {
            value = VirtualColumn.of(col.getName() + "_value", "varchar");
        } else if (CassandraMetaDataVisitor.isUserDefinedDatatype(type.getElementType())) {
            this.handleUserDefintedType(satellite, col, (UserDefinedType)type.getElementType());
        } else {
            value = VirtualColumn.of(col.getName() + "_value", type.getElementType());
        }
        satellite.pk.add(index);
        satellite.columns.addAll(satellite.pk);
        if (value != null) {
            satellite.columns.add(value);
        }
        this.satelliteDatastores.add(satellite);
    }

    private void visitMap(CassandraMetaDataVisitor.AbstractDatastore owner, CassandraMetaDataVisitor.Column col) {
        MapType type = (MapType)col.md.getType();
        CassandraMetaDataVisitor.VirtualDatastore satellite = new CassandraMetaDataVisitor.VirtualDatastore(owner.getName() + "_vt_" + col.getName());
        owner.getPrimaryKey().forEach(c -> {
            boolean bl = virtualDatastore.pk.add(CassandraMetaDataVisitor.Column.of(c.md));
        });
        VirtualColumn key = null;
        VirtualColumn value = null;
        if (CassandraMetaDataVisitor.isComplexDatatype(type.getKeyType())) {
            key = VirtualColumn.of(col.getName() + "_key", "varchar");
            satellite.pk.add(key);
        } else if (CassandraMetaDataVisitor.isUserDefinedDatatype(type.getKeyType())) {
            this.handleUserDefintedType(satellite, col, (UserDefinedType)type.getKeyType());
        } else {
            key = VirtualColumn.of(col.getName() + "_key", type.getKeyType());
            satellite.pk.add(key);
        }
        satellite.columns.addAll(satellite.pk);
        if (CassandraMetaDataVisitor.isComplexDatatype(type.getValueType())) {
            value = VirtualColumn.of(col.getName() + "_value", "varchar");
            satellite.columns.add(value);
        } else if (CassandraMetaDataVisitor.isUserDefinedDatatype(type.getValueType())) {
            this.handleUserDefintedType(satellite, col, (UserDefinedType)type.getValueType());
        } else {
            value = VirtualColumn.of(col.getName() + "_value", type.getValueType());
            satellite.columns.add(value);
        }
        this.satelliteDatastores.add(satellite);
    }

    private void visitTuple(CassandraMetaDataVisitor.AbstractDatastore owner, CassandraMetaDataVisitor.Column col) {
        owner.columns.add(VirtualColumn.of(col.getName(), "varchar"));
    }

    static class VirtualColumn
    extends CassandraMetaDataVisitor.Column {
        String name;
        String type;

        VirtualColumn() {
        }

        static VirtualColumn of(String name, DataType type) {
            VirtualColumn v = new VirtualColumn();
            v.name = name;
            v.type = type.toString();
            return v;
        }

        static VirtualColumn of(String name, String type) {
            VirtualColumn v = new VirtualColumn();
            v.name = name;
            v.type = type;
            return v;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }
}

