/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.rdbms.cassandra.reverse;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.indy.addons.rdbms.cassandra.reverse.CassandraMetaDataVisitor;
import com.indy.addons.rdbms.cassandra.reverse.ForeignKeysVisitor;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;

public class Reverser {
    public static final String SERVER_DEFTYPE = "com.stambia.rdbms.server";
    public static final String SERVER_ATTRIBUTE_NODES = "nodes";
    public static final String SERVER_ATTRIBUTE_MODULE = "module";
    public static final String SERVER_ATTRIBUTE_DATACENTER = "physicalName";
    public static final String SERVER_ATTRIBUTE_USERNAME = "user";
    public static final String SERVER_ATTRIBUTE_PASSWORD = "password";
    public static final String SCHEMA_DEFTYPE = "com.stambia.rdbms.schema";
    public static final String SCHEMA_ATTRIBUTE_PHYSICAL_NAME = "name";
    public static final String DATASTORE_DEFTYPE = "com.stambia.rdbms.datastore";
    public static final String DATASTORE_ATTRIBUTE_TYPE = "type";
    public static final String DATASTORE_ATTRIBUTE_PHYSICAL_NAME = "name";
    public static final String COLUMN_DEFTYPE = "com.stambia.rdbms.column";
    public static final String COLUMN_ATTRIBUTE_PHYSICAL_NAME = "name";
    public static final String COLUMN_ATTRIBUTE_DATATYPE = "type";
    public static final String COLUMN_ATTRIBUTE_NULLABLE = "nullable";
    public static final String PK_DEFTYPE = "com.stambia.rdbms.pk";
    public static final String COLREF_DEFTYPE = "com.stambia.rdbms.colref";
    public static final String COLREF_ATTRIBUTE_REF = "ref";
    public static final String DEFAULT_CHECK_REQUEST = "SELECT now() FROM system.local;";
    private CqlSession session;
    private CassandraMetaDataVisitor visitor = new CassandraMetaDataVisitor();
    private Map<String, CassandraMetaDataVisitor.Keyspace> keySpaces = new HashMap<String, CassandraMetaDataVisitor.Keyspace>();
    private MdNode substituteContainer;
    private ColRefResolver referenceResolver;

    public Reverser(MdNode substituteContainer) {
        this.substituteContainer = substituteContainer;
    }

    public CqlSession getSession() {
        return this.session;
    }

    public void connect(String nodes, String datacenter, String user, String password) {
        this.keySpaces = null;
        ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(nodes.split(",")));
        ArrayList<InetSocketAddress> list2 = new ArrayList<InetSocketAddress>();
        for (String item : list1) {
            InetSocketAddress isa = item.indexOf(":") > -1 ? new InetSocketAddress(item.substring(0, item.indexOf(":")), (int)Integer.valueOf(item.substring(item.indexOf(":") + 1))) : new InetSocketAddress(item, 9042);
            list2.add(isa);
        }
        try {
            CqlSessionBuilder b = (CqlSessionBuilder)CqlSession.builder().addContactPoints(list2);
            if (user != null && !user.isEmpty()) {
                b = (CqlSessionBuilder)b.withAuthCredentials(user, password);
            }
            if (datacenter != null && !datacenter.isEmpty()) {
                b = (CqlSessionBuilder)b.withLocalDatacenter(datacenter);
            }
            this.session = (CqlSession)b.build();
            this.session.execute(DEFAULT_CHECK_REQUEST);
        }
        catch (AllNodesFailedException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Connection failed : Datacenter is missing", e);
        }
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public Collection<CassandraMetaDataVisitor.Keyspace> getKeySpaces() {
        if (this.keySpaces == null) {
            this.keySpaces = new HashMap<String, CassandraMetaDataVisitor.Keyspace>();
            this.visitor.visit(this.session.getMetadata()).stream().forEach(k -> {
                CassandraMetaDataVisitor.Keyspace keyspace = this.keySpaces.put(k.getName(), (CassandraMetaDataVisitor.Keyspace)k);
            });
        }
        return this.keySpaces.values();
    }

    public Collection<CassandraMetaDataVisitor.Datastore> getDatastores(String keyspace) {
        CassandraMetaDataVisitor.Keyspace k = this.keySpaces.get(keyspace);
        if (k == null) {
            throw new IllegalStateException(String.format("The Keyspace %s does not exist.", keyspace));
        }
        if (k.getDatastore() == null) {
            this.visitor.visit(k);
        }
        return k.getDatastore();
    }

    public CassandraMetaDataVisitor.Datastore getDatastore(String keyspace, String dataStoreName) {
        CassandraMetaDataVisitor.Keyspace k = this.keySpaces.get(keyspace);
        Optional<CassandraMetaDataVisitor.Datastore> dataStore = k.getDatastore().stream().filter(t -> t.getName().equals(dataStoreName)).findAny();
        if (!dataStore.isEmpty()) {
            CassandraMetaDataVisitor.Datastore item = dataStore.get();
            this.visitor.visit(item);
            return item;
        }
        return null;
    }

    public MdNode createNewServerNode(String name, String nodes, String module, String datacenter, String username, String password, String keyspace) {
        MdNode server = MdFactory.eINSTANCE.createMdNode();
        server.setSubstituteContainer((EObject)this.substituteContainer);
        server.setDefType(SERVER_DEFTYPE);
        server.setName(name);
        server.setAttribute(SERVER_ATTRIBUTE_NODES, nodes, false);
        server.setAttribute(SERVER_ATTRIBUTE_MODULE, module, false);
        server.setAttribute(SERVER_ATTRIBUTE_DATACENTER, datacenter, false);
        server.setAttribute(SERVER_ATTRIBUTE_USERNAME, username, false);
        server.setAttribute(SERVER_ATTRIBUTE_PASSWORD, password, false);
        MdNode schema = MdFactory.eINSTANCE.createMdNode();
        server.getNode().add((Object)schema);
        schema.setDefType(SCHEMA_DEFTYPE);
        schema.setName(datacenter);
        schema.setAttribute("name", keyspace, false);
        return server;
    }

    private MdNode createColumnMd(MdNode ds, CassandraMetaDataVisitor.AbstractDatastore dataStore, CassandraMetaDataVisitor.Column c) {
        MdNode mdCol = MdFactory.eINSTANCE.createMdNode();
        ds.getNode().add((Object)mdCol);
        mdCol.setDefType(COLUMN_DEFTYPE);
        mdCol.setName(c.getName());
        mdCol.setAttribute("name", c.getName(), false);
        mdCol.setAttribute("type", c.getType(), false);
        if (!dataStore.getPrimaryKey().contains(c)) {
            mdCol.setAttribute(COLUMN_ATTRIBUTE_NULLABLE, Boolean.TRUE.toString(), false);
        }
        return mdCol;
    }

    private MdNode createDatastore(CassandraMetaDataVisitor.AbstractDatastore datastore) {
        MdNode ds = MdFactory.eINSTANCE.createMdNode();
        ds.setSubstituteContainer((EObject)this.substituteContainer);
        ds.setDefType(DATASTORE_DEFTYPE);
        ds.setName(datastore.getName());
        ds.setAttribute("name", datastore.getName(), false);
        ds.setAttribute("type", datastore.getType().name(), false);
        HashMap<String, MdNode> mdColPerName = new HashMap<String, MdNode>();
        for (CassandraMetaDataVisitor.Column c : datastore.getColumn()) {
            MdNode mdCol = this.createColumnMd(ds, datastore, c);
            mdColPerName.put(mdCol.getName(), mdCol);
        }
        MdNode pk = null;
        for (CassandraMetaDataVisitor.Column c : datastore.getPrimaryKey()) {
            if (pk == null) {
                pk = MdFactory.eINSTANCE.createMdNode();
                pk.setDefType(PK_DEFTYPE);
                ds.getNode().add((Object)pk);
            }
            MdNode colRef = MdFactory.eINSTANCE.createMdNode();
            colRef.setDefType(COLREF_DEFTYPE);
            pk.getNode().add((Object)colRef);
            colRef.setRefAttribute(COLREF_ATTRIBUTE_REF, (EObject)mdColPerName.get(c.getName()), false);
        }
        return ds;
    }

    public List<MdNode> createNewDatastoreNodes(String keyspace, Collection<String> tableNames) {
        this.referenceResolver = new ColRefResolver();
        ArrayList<MdNode> res = new ArrayList<MdNode>();
        ForeignKeysVisitor fkVisitor = new ForeignKeysVisitor();
        for (String s : tableNames) {
            CassandraMetaDataVisitor.Datastore dataStore = this.getDatastore(keyspace, s);
            for (CassandraMetaDataVisitor.Column c : dataStore.getForeignKey()) {
                fkVisitor.visit(dataStore, c);
            }
            MdNode ds = this.createDatastore(dataStore);
            res.add(ds);
        }
        for (CassandraMetaDataVisitor.VirtualDatastore d : fkVisitor.satelliteDatastores) {
            res.add(this.createDatastore(d));
        }
        return res;
    }

    public AttributeRefResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    private class ColRefResolver
    implements AttributeRefResolver {
        private ColRefResolver() {
        }

        private List<Object> resolvePKReference(MdNode pkNode, MdNode referencedColumn) {
            MdNode datastore = (MdNode)pkNode.eContainer();
            MdNode res = datastore.getNodeByName(Reverser.COLUMN_DEFTYPE, referencedColumn.getName());
            if (res != null) {
                return Collections.singletonList(res);
            }
            return Collections.emptyList();
        }

        public List<Object> resolve(MdNode context, Attribute attribute) {
            MdNode contextParent;
            if (attribute.getDefType().equals("com.stambia.rdbms.colref.ref") && (contextParent = (MdNode)context.eContainer()).getDefType().equals(Reverser.PK_DEFTYPE)) {
                return this.resolvePKReference(contextParent, (MdNode)attribute.getRef());
            }
            return Collections.emptyList();
        }
    }
}

