/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.rdbms.cassandra.wizard;

import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.addons.rdbms.cassandra.wizard.Bean;
import com.indy.addons.rdbms.cassandra.wizard.Controller;
import com.indy.addons.rdbms.cassandra.wizard.Messages;
import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.wizard.ModuleWizard;
import com.indy.md.ui.editor.reverse.MdDiffBuilder;
import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import com.indy.md.ui.editor.ui.MdWizard;
import com.stambia.md.DocumentRoot;
import com.stambia.md.Element;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraWizard
extends MdWizard {
    static Image delIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"/icons/full/obj16/delete_obj.png").createImage();
    static Image addIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"/icons/full/obj16/add_obj.png").createImage();
    private Controller controller;
    private Bean bean = new Bean();
    private SchemaPage schemaPage;
    private TablePage tablePage;
    private WizardPage selectivePage;
    private MdDiffNodeUI diffNodeUI;
    private Map<String, Boolean> deleteReverseOptions = new HashMap<String, Boolean>();
    Logger logger = LoggerFactory.getLogger(CassandraWizard.class);

    public CassandraWizard() {
        this.init();
    }

    public CassandraWizard(boolean creation) {
        super(creation);
        this.init();
    }

    private void init() {
        this.setWindowTitle(Messages.CassandraWizard_title);
        this.setNeedsProgressMonitor(true);
        this.deleteReverseOptions.put("com.stambia.rdbms.datastore", true);
    }

    public void setNode(MdNode node) {
        this.controller = new Controller(node);
        this.controller.setBean(this.bean);
        this.controller.loadBean();
    }

    protected final void setController(Controller controller) {
        this.controller = controller;
    }

    public MdNode getNode() {
        return this.controller.getNode();
    }

    public void addPages() {
        this.addPage((IWizardPage)new CassandraPage());
        this.schemaPage = new SchemaPage();
        this.tablePage = new TablePage();
        this.selectivePage = new WizardPage("DiffPage"){

            public void createControl(Composite parent) {
                TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
                CassandraWizard.this.diffNodeUI = new MdDiffNodeUI(widgetFactory);
                Composite main = widgetFactory.createComposite(parent, 0);
                main.setLayout((Layout)new GridLayout());
                ((GridLayout)main.getLayout()).verticalSpacing = 0;
                CassandraWizard.this.diffNodeUI.createSearchBar(main).setLayoutData((Object)new GridData(4, 1, true, false));
                CassandraWizard.this.diffNodeUI.createOptionComposite(main).setLayoutData((Object)new GridData(4, 1, true, false));
                CassandraWizard.this.diffNodeUI.createToolbar(main).setLayoutData((Object)new GridData(4, 1, true, false));
                ((GridLayout)main.getLayout()).verticalSpacing = 0;
                main.setLayoutData((Object)new GridData(1808));
                CheckboxTreeViewer diffViewer = CassandraWizard.this.diffNodeUI.createViewer(main);
                diffViewer.getControl().setLayoutData((Object)new GridData(1808));
                this.setControl((Control)main);
            }
        };
        this.addPage((IWizardPage)this.schemaPage);
        this.addPage((IWizardPage)this.tablePage);
        this.addPage((IWizardPage)this.selectivePage);
        this.selectivePage.setDescription(Messages.CassandraWizard_selectiveReversePageDescription);
        this.selectivePage.setTitle(Messages.CassandraWizard_selectiveReversePageTitle);
        IWizardContainer c = this.getContainer();
        if (c instanceof WizardDialog) {
            ((WizardDialog)c).setMinimumPageSize(0, 300);
            ((WizardDialog)c).addPageChangingListener(new IPageChangingListener(){

                public void handlePageChanging(final PageChangingEvent event) {
                    if (event.getTargetPage() == CassandraWizard.this.selectivePage) {
                        try {
                            CassandraWizard.this.getContainer().run(true, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) {
                                    String nodes = (this).CassandraWizard.this.controller.getBean().getNodes();
                                    if (nodes == null || nodes.length() == 0) {
                                        event.doit = false;
                                        return;
                                    }
                                    monitor.beginTask("Reverse in progress", -1);
                                    HashSet ignoredAttributeComparison = new HashSet();
                                    HashMap nodeMatchingMap = new HashMap();
                                    try {
                                        MdDiffNode diffNode = new MdDiffNode(null, CassandraWizard.this.isCreation() ? null : CassandraWizard.this.getNode(), (this).CassandraWizard.this.controller.createReversedMdNode(), ignoredAttributeComparison, false);
                                        MdDiffBuilder.buildTree((IncrementalReverser.DefaulteverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, (MdDiffNode)diffNode, Collections.emptySet(), ignoredAttributeComparison, nodeMatchingMap);
                                        Display.getDefault().syncExec(() -> (this).CassandraWizard.this.diffNodeUI.getViewerHelper().setInput((Object)new Object[]{diffNode}));
                                    }
                                    catch (Exception ex) {
                                        StatusManager.getManager().handle((IStatus)new Status(4, CassandraWizard.class, Messages.CassandraWizard_nextPageError, (Throwable)ex), 5);
                                        event.doit = false;
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            if (ex instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            StatusManager.getManager().handle((IStatus)new Status(4, CassandraWizard.class, Messages.CassandraWizard_nextPageError, (Throwable)ex), 5);
                            event.doit = false;
                        }
                    }
                }
            });
        }
    }

    protected MdNode computeDiffStateResult(Map<MdNode, MdNode> reversedMap) throws Exception {
        VisitHandler handler = new VisitHandler();
        handler.newToOldMap = reversedMap;
        ArrayList<String> toDelete = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : this.deleteReverseOptions.entrySet()) {
            if (this.deleteReverseOptions.get(entry.getKey()) != Boolean.TRUE) continue;
            toDelete.add(entry.getKey());
        }
        MdDiffNodeUI.DiffState diffState = this.diffNodeUI.computeDiffState((MdDiffNodeUI.IVisitorHandler)handler, toDelete);
        return diffState.getResultingMdNode();
    }

    public boolean performFinish() {
        MdNode originalServiceNode = this.getNode();
        while (originalServiceNode.eContainer() instanceof MdNode) {
            originalServiceNode = (MdNode)originalServiceNode.eContainer();
        }
        DocumentRoot root = (DocumentRoot)originalServiceNode.eContainer();
        HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
        try {
            MdNode result = this.getContainer().getCurrentPage() == this.selectivePage ? this.computeDiffStateResult(reversedMap) : this.controller.createReversedMdNode();
            reversedMap.put(result, this.getNode());
            ArrayList excludeAttributeToUpdate = new ArrayList();
            TreeIterator it = result.eAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!(o instanceof MdNode)) continue;
                ((MdNode)o).setSubstituteContainer(null);
            }
            result.setSubstituteContainer(this.getNode().eContainer());
            IncrementalReverser ir = new IncrementalReverser((EObject)root, reversedMap, excludeAttributeToUpdate, true, this.controller.getReverser().getReferenceResolver(), this.deleteReverseOptions, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
            return true;
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, CassandraWizard.class, Messages.CassandraWizard_reverseError, (Throwable)e));
            return false;
        }
    }

    private class CassandraPage
    extends WizardPage {
        private Text name;
        private CCombo module;
        private Text datacenter;
        private Label connectStatus;
        private Text userName;
        private Text password;
        private Button connect;
        private Button disconnect;
        private TableViewer nodesViewer;

        protected CassandraPage() {
            super(Messages.CassandraWizard_connectionPageName);
            this.setTitle(this.getName());
            this.setDescription(Messages.CassandraWizard_connectionPageDescription);
        }

        public boolean isPageComplete() {
            return CassandraWizard.this.controller.isConnected();
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(Messages.CassandraWizard_serverName);
            this.name = new Text(composite, 2048);
            this.name.setLayoutData((Object)new GridData(4, 1, true, false));
            label = new Label(composite, 64);
            label.setText(Messages.CassandraWizard_module);
            label.setLayoutData((Object)new GridData());
            Composite ctr = new Composite(composite, 0);
            ctr.setLayout((Layout)new GridLayout(2, false));
            ((GridLayout)ctr.getLayout()).marginWidth = 0;
            ((GridLayout)ctr.getLayout()).marginHeight = 0;
            ctr.setLayoutData((Object)new GridData(4, 1, true, false));
            this.module = new CCombo(ctr, 2048);
            List<String> l = CassandraWizard.this.controller.getModuleNames();
            this.module.setItems(l.toArray(new String[l.size()]));
            int i = 0;
            while (i < l.size()) {
                if (this.module.getItem(i).equals(CassandraWizard.this.bean.getModule())) {
                    this.module.select(i);
                }
                ++i;
            }
            this.module.setLayoutData((Object)new GridData(4, 1, true, false));
            Button create = new Button(ctr, 8);
            create.setText(Messages.CassandraWizard_moduleButton);
            create.setLayoutData((Object)new GridData(3, 1, false, false));
            create.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String moduleName = ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.getBean().getModule();
                    IModuleService.IModule m = null;
                    try {
                        m = ((IModuleService)PlatformUI.getWorkbench().getService(IModuleService.class)).getModule(moduleName);
                    }
                    catch (Exception ex) {
                        ((CassandraPage)CassandraPage.this).CassandraWizard.this.logger.warn("unexpected", (Throwable)ex);
                    }
                    ModuleWizard z = new ModuleWizard(((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.getBean().getModuleFilters(), m == null ? null : m.getDescriptor(), false, false);
                    WizardDialog d = new WizardDialog(CassandraPage.this.getShell(), (IWizard)z);
                    d.setPageSize(800, 600);
                    if (d.open() == 0) {
                        try {
                            List<String> l = ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.getModuleNames();
                            CassandraPage.this.module.setItems(l.toArray(new String[l.size()]));
                            CassandraPage.this.module.setText(z.getResult().getName());
                            CassandraPage.this.module.notifyListeners(13, new Event());
                        }
                        catch (Exception ex) {
                            ((CassandraPage)CassandraPage.this).CassandraWizard.this.logger.warn("unexpected", (Throwable)ex);
                            MessageDialog.openError((Shell)CassandraPage.this.getShell(), (String)"Create Module", (String)("Failed to create the module : " + ex.getMessage()));
                        }
                    }
                }
            });
            label = new Label(composite, 64);
            label.setText(Messages.CassandraWizard_serverNodes);
            label.setLayoutData((Object)new GridData());
            ToolBar toolbar = new ToolBar(composite, 0x800000);
            toolbar.setLayoutData((Object)new GridData(4, 1, true, false));
            ToolItem add = new ToolItem(toolbar, 8);
            add.setToolTipText(Messages.CassandraWizard_addServerNodeTooltip);
            add.setImage(addIcon);
            add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Controller.NodeInfo info = ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.getNodeHelper().addNode();
                    CassandraPage.this.nodesViewer.refresh();
                    CassandraPage.this.nodesViewer.reveal((Object)info);
                }
            });
            ToolItem del = new ToolItem(toolbar, 8);
            del.setImage(delIcon);
            del.setToolTipText(Messages.CassandraWizard_removeServerNodeTooltip);
            del.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CassandraPage.this.nodesViewer.getStructuredSelection().forEach(n -> ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.getNodeHelper().removeNode((Controller.NodeInfo)n));
                    CassandraPage.this.nodesViewer.refresh();
                }
            });
            this.nodesViewer = new TableViewer(composite, 68096);
            this.nodesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            GridData gd = new GridData(4, 4, true, true, 2, 1);
            gd.minimumHeight = 100;
            this.nodesViewer.getControl().setLayoutData((Object)gd);
            this.nodesViewer.getTable().setHeaderVisible(true);
            this.nodesViewer.getTable().setLinesVisible(true);
            TableViewerColumn col = new TableViewerColumn(this.nodesViewer, 16384);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((Controller.NodeInfo)element).hostName;
                }
            });
            col.getColumn().setText(Messages.CassandraWizard_serverNodeHostName);
            col.getColumn().setWidth(200);
            col.setEditingSupport(new EditingSupport((ColumnViewer)this.nodesViewer){

                protected void setValue(Object element, Object value) {
                    ((Controller.NodeInfo)element).hostName = (String)value;
                    CassandraPage.this.nodesViewer.refresh(element);
                }

                protected Object getValue(Object element) {
                    return ((Controller.NodeInfo)element).hostName;
                }

                protected CellEditor getCellEditor(Object element) {
                    return new TextCellEditor((Composite)CassandraPage.this.nodesViewer.getTable());
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
            TableViewerColumn col2 = new TableViewerColumn(this.nodesViewer, 16384);
            col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((Controller.NodeInfo)element).port;
                }
            });
            col2.getColumn().setText(Messages.CassandraWizard_serverNodePort);
            col2.getColumn().setWidth(50);
            col2.setEditingSupport(new EditingSupport((ColumnViewer)this.nodesViewer){

                protected void setValue(Object element, Object value) {
                    ((Controller.NodeInfo)element).port = (String)value;
                    CassandraPage.this.nodesViewer.refresh(element, true);
                }

                protected Object getValue(Object element) {
                    return ((Controller.NodeInfo)element).port;
                }

                protected CellEditor getCellEditor(Object element) {
                    TextCellEditor editor = new TextCellEditor((Composite)CassandraPage.this.nodesViewer.getTable());
                    editor.setValidator(value -> value != null && ((String)value).matches("[0-9]+") ? null : Messages.CassandraWizard_invalidPortFormatMessage);
                    return editor;
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
            label = new Label(composite, 64);
            label.setLayoutData((Object)new GridData());
            label.setText(Messages.CassandraWizard_serverDatacenter);
            this.datacenter = new Text(composite, 2048);
            this.datacenter.setLayoutData((Object)new GridData(4, 1, true, false));
            label = new Label(composite, 64);
            label.setLayoutData((Object)new GridData());
            label.setText(Messages.CassandraWizard_serverUsername);
            this.userName = new Text(composite, 2048);
            this.userName.setLayoutData((Object)new GridData(4, 1, true, false));
            label = new Label(composite, 64);
            label.setLayoutData((Object)new GridData());
            label.setText(Messages.CassandraWizard_serverPassword);
            this.password = new Text(composite, 0x400800);
            this.password.setLayoutData((Object)new GridData(4, 1, true, false));
            Composite connectionComposite = new Composite(composite, 0);
            connectionComposite.setLayoutData((Object)new GridData(2, 1, true, false, 2, 1));
            connectionComposite.setLayout((Layout)new GridLayout());
            this.connectStatus = new Label(connectionComposite, 0);
            this.connectStatus.setText(Messages.CassandraWizard_connectionStatusDisconnected);
            this.connectStatus.setLayoutData((Object)new GridData(4, 1, true, false));
            this.connect = new Button(connectionComposite, 8);
            this.connect.setText(Messages.CassandraWizard_connectButton);
            this.connect.setLayoutData((Object)new GridData(4, 1, true, false));
            this.connect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Collection nodes;
                    Object object = CassandraPage.this.nodesViewer.getInput();
                    if (object instanceof Collection && !(nodes = (Collection)object).isEmpty()) {
                        CassandraPage.this.doConnect(CassandraPage.this.getNodesFromTable(nodes));
                    }
                }
            });
            this.disconnect = new Button(connectionComposite, 8);
            this.disconnect.setText(Messages.CassandraWizard_discconnectButton);
            this.disconnect.setEnabled(false);
            this.disconnect.setLayoutData((Object)new GridData(4, 1, true, false));
            this.disconnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CassandraPage.this.doConnect(null);
                }
            });
            this.setControl((Control)composite);
            this.fillData();
            this.hookListeners();
        }

        private String getNodesFromTable(Collection<Controller.NodeInfo> nodes) {
            return nodes.stream().map(Controller.NodeInfo::toString).collect(Collectors.joining(","));
        }

        private void doConnect(final String node) {
            try {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                if (node != null) {
                                    ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.getBean().setNodes(node);
                                    ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.connect();
                                } else {
                                    ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.disconnect();
                                }
                            }
                            catch (Exception e1) {
                                throw new InvocationTargetException(e1);
                            }
                        }
                    });
                    CassandraWizard.this.schemaPage.schemaViewer.setInput(CassandraWizard.this.controller.getReverser().getKeySpaces().stream().map(k -> k.getName()).sorted().collect(Collectors.toList()));
                }
                catch (Exception e1) {
                    if (e1 instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    StatusManager.getManager().handle((IStatus)new Status(4, CassandraWizard.class, e1.getCause().getMessage(), e1.getCause().getCause()), 7);
                    if (CassandraWizard.this.controller.isConnected()) {
                        this.disconnect.setEnabled(true);
                        this.connect.setEnabled(false);
                        this.connectStatus.setText(Messages.CassandraWizard_connectionStatusConnected);
                    } else {
                        this.disconnect.setEnabled(false);
                        this.connect.setEnabled(true);
                        this.connectStatus.setText(Messages.CassandraWizard_connectionStatusDisconnected);
                    }
                    ((WizardDialog)this.getContainer()).updateButtons();
                }
            }
            finally {
                if (CassandraWizard.this.controller.isConnected()) {
                    this.disconnect.setEnabled(true);
                    this.connect.setEnabled(false);
                    this.connectStatus.setText(Messages.CassandraWizard_connectionStatusConnected);
                } else {
                    this.disconnect.setEnabled(false);
                    this.connect.setEnabled(true);
                    this.connectStatus.setText(Messages.CassandraWizard_connectionStatusDisconnected);
                }
                ((WizardDialog)this.getContainer()).updateButtons();
            }
        }

        private void fillData() {
            this.name.setText(CassandraWizard.this.controller.getBean().getName());
            this.nodesViewer.setInput(CassandraWizard.this.controller.getNodeHelper().getNodes());
            this.datacenter.setText(CassandraWizard.this.controller.getBean().getDatacenter());
            this.userName.setText(CassandraWizard.this.controller.getBean().getUsername());
            this.password.setText(CassandraWizard.this.controller.getBean().getPassword());
            this.module.setText(CassandraWizard.this.controller.getBean().getModule());
        }

        private void hookListeners() {
            this.name.addModifyListener(e -> CassandraWizard.this.controller.getBean().setName(this.name.getText()));
            this.datacenter.addModifyListener(e -> CassandraWizard.this.controller.getBean().setDatacenter(this.datacenter.getText()));
            this.userName.addModifyListener(e -> CassandraWizard.this.controller.getBean().setUsername(this.userName.getText()));
            this.password.addModifyListener(e -> CassandraWizard.this.controller.getBean().setPassword(this.password.getText()));
            this.module.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((CassandraPage)CassandraPage.this).CassandraWizard.this.controller.getBean().setModule(CassandraPage.this.module.getText());
                }
            });
            this.module.addModifyListener(e -> CassandraWizard.this.controller.getBean().setModule(this.module.getText()));
        }
    }

    private class SchemaPage
    extends WizardPage {
        ComboViewer schemaViewer;
        boolean loadingKeystore;

        public SchemaPage() {
            super(Messages.CassandraWizard_schemaPageName);
            this.loadingKeystore = false;
            super.setTitle(Messages.CassandraWizard_schemaPageName);
            super.setDescription(Messages.CassandraWizard_schemaPageDescription);
        }

        public boolean isPageComplete() {
            return CassandraWizard.this.controller.getBean().getKeyspace() != null;
        }

        public void createControl(Composite parent) {
            ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite((Composite)parent);
            Composite composite = new Composite((Composite)scrolled, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(composite, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.CassandraWizard_schemaName);
            this.schemaViewer = new ComboViewer(composite, 2056);
            this.schemaViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.schemaViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.schemaViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.schemaViewer.addSelectionChangedListener(e -> this.loadDatastores((String)this.schemaViewer.getStructuredSelection().getFirstElement()));
            ScrolledCompositeWizardHelper.adaptToContent((ScrolledComposite)scrolled, (Composite)composite);
            this.setControl((Control)scrolled);
        }

        private void loadDatastores(String keyspace) {
            if (this.loadingKeystore) {
                return;
            }
            this.loadingKeystore = true;
            CassandraWizard.this.controller.getBean().setKeyspace(keyspace);
            List input = null;
            try {
                input = CassandraWizard.this.controller.getReverser().getDatastores(CassandraWizard.this.controller.getBean().getKeyspace()).stream().map(d -> d.getName()).collect(Collectors.toList());
                CassandraWizard.this.tablePage.viewer.setInput(input);
            }
            catch (Exception ex) {
                CassandraWizard.this.tablePage.viewer.setInput(Collections.emptyList());
                StatusManager.getManager().handle((IStatus)new Status(4, CassandraWizard.class, Messages.CassandraWizard_errorListDatastores, (Throwable)ex), 5);
            }
            ((WizardDialog)this.getContainer()).updateButtons();
            this.loadingKeystore = false;
        }
    }

    private class TablePage
    extends WizardPage {
        CheckboxTableViewer viewer;

        public TablePage() {
            super(Messages.CassandraWizard_datastoreSelectionPageTitle);
            super.setTitle(Messages.CassandraWizard_datastoreSelectionPageTitle);
            super.setDescription(Messages.CassandraWizard_datastoreSelectionPageDescription);
        }

        public void createControl(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout());
            Composite tb = new Composite(main, 0);
            tb.setLayoutData((Object)new GridData(4, 1, true, false));
            tb.setLayout((Layout)new GridLayout(3, true));
            Button selectAll = new Button(tb, 8);
            selectAll.setText(Messages.CassandraWizard_selectAll);
            selectAll.setLayoutData((Object)new GridData(4, 1, true, false));
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TablePage.this.viewer.setAllChecked(true);
                    ((TablePage)TablePage.this).CassandraWizard.this.controller.getBean().getDatastores().clear();
                    ((TablePage)TablePage.this).CassandraWizard.this.controller.getBean().getDatastores().addAll((Collection)TablePage.this.viewer.getInput());
                    ((WizardDialog)TablePage.this.getContainer()).updateButtons();
                }
            });
            Button deselectAll = new Button(tb, 8);
            deselectAll.setText(Messages.CassandraWizard_deselectAll);
            deselectAll.setLayoutData((Object)new GridData(4, 1, true, false));
            deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TablePage.this.viewer.setAllChecked(false);
                    ((TablePage)TablePage.this).CassandraWizard.this.controller.getBean().getDatastores().clear();
                    ((WizardDialog)TablePage.this.getContainer()).updateButtons();
                }
            });
            Button selectExisting = new Button(tb, 8);
            selectExisting.setText(Messages.CassandraWizard_selectExisting);
            selectExisting.setLayoutData((Object)new GridData(4, 1, true, false));
            selectExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TablePage.this.viewer.setAllChecked(false);
                    ((TablePage)TablePage.this).CassandraWizard.this.controller.getBean().getDatastores().clear();
                    MdNode schema = ((TablePage)TablePage.this).CassandraWizard.this.controller.getNode().getNodeByName("com.stambia.rdbms.schema", ((TablePage)TablePage.this).CassandraWizard.this.controller.getBean().getDatacenter());
                    if (schema != null) {
                        List<String> l = schema.getNode().stream().filter(n -> "com.stambia.rdbms.datastore".equals(n.getDefType())).map(Element::getName).collect(Collectors.toList());
                        l.forEach(s -> {
                            boolean bl = TablePage.this.viewer.setChecked(s, true);
                        });
                        ((TablePage)TablePage.this).CassandraWizard.this.controller.getBean().getDatastores().addAll(l);
                    }
                    ((WizardDialog)TablePage.this.getContainer()).updateButtons();
                }
            });
            this.viewer = CheckboxTableViewer.newCheckList((Composite)main, (int)68096);
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.viewer.setComparator(new ViewerComparator());
            this.viewer.addCheckStateListener(e -> {
                if (e.getChecked()) {
                    CassandraWizard.this.controller.getBean().getDatastores().add((String)e.getElement());
                } else {
                    CassandraWizard.this.controller.getBean().getDatastores().remove(e.getElement());
                }
                ((WizardDialog)this.getContainer()).updateButtons();
            });
            this.setControl((Control)main);
        }

        public boolean isPageComplete() {
            return true;
        }
    }

    private class VisitHandler
    implements MdDiffNodeUI.IVisitorHandler {
        Map<MdNode, MdNode> newToOldMap;

        private VisitHandler() {
        }

        public void handleVisited(MdDiffNode diff, MdNode createdNode) {
            MdNode n = diff.getState() == MdDiffNode.State.NEW ? diff.getNewNode() : diff.getOldNode();
        }
    }
}

