/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.sapS4hana.designer.ui;

import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.semarchy.xdi.component.sapS4hana.designer.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EditableViewerUI {
    private List<IElement> input;
    private Label labelRowNumber = null;
    private TableViewer viewer;
    private ToolItem deleteIt;
    private List<IContentListener> listeners = new ArrayList<IContentListener>();

    private void handleAddRow(Collection<ColumnInfo> columns) {
        Element e = null;
        e = new Element(columns, new HashMap<String, String>());
        this.input.add(e);
        this.viewer.refresh();
        this.viewer.reveal((Object)e);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)e));
        this.notifyContentListeners(this.input.size());
    }

    private void handleDeleteRow() {
        this.input.removeAll(((IStructuredSelection)this.viewer.getSelection()).toList());
        this.viewer.refresh();
        this.notifyContentListeners(this.input.size());
    }

    public void setInput(List<IElement> input) {
        this.input = input;
        this.viewer.setInput(this.input);
        this.notifyContentListeners(input.size());
        if (this.labelRowNumber != null) {
            this.labelRowNumber.setText(Messages.bind((String)Messages.EditableViewerUI_1, (Object)input.size()));
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public Composite createControl(Composite parent, List<ColumnInfo> columns, Mode mode, boolean enableEdition) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        final HashMap<String, ColumnInfo> colsMap = new HashMap<String, ColumnInfo>();
        if (enableEdition && mode == Mode.TABLE) {
            ToolBar tb = new ToolBar(main, 0x800100);
            tb.setLayoutData((Object)new GridData());
            ToolItem it = new ToolItem(tb, 8);
            it.setToolTipText(Messages.EditableViewerUI_2);
            it.setImage(AbstractUnboundedControl.addIcon);
            it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableViewerUI.this.handleAddRow(colsMap.values());
                }
            });
            ToolItem it2 = new ToolItem(tb, 8);
            it2.setToolTipText(Messages.EditableViewerUI_3);
            it2.setImage(AbstractUnboundedControl.delIcon);
            it2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableViewerUI.this.handleDeleteRow();
                }
            });
            it2.setEnabled(false);
            this.deleteIt = it2;
        }
        this.viewer = new TableViewer(main, 68354);
        if (enableEdition && mode == Mode.TABLE) {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (EditableViewerUI.this.deleteIt != null) {
                        EditableViewerUI.this.deleteIt.setEnabled(!event.getSelection().isEmpty());
                    }
                }
            });
        }
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        if (Mode.LIST == mode) {
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

                public Object[] getElements(Object inputElement) {
                    List l = (List)inputElement;
                    ArrayList<String[]> res = new ArrayList<String[]>();
                    if (!l.isEmpty()) {
                        for (Object o : l) {
                            for (ColumnInfo s : ((IElement)o).getColumnInfo()) {
                                String[] e = new String[]{s.header, ((Element)o).datas.get(s.header)};
                                res.add(e);
                            }
                        }
                    }
                    return res.toArray(new Object[res.size()]);
                }
            });
        } else {
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        }
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        if (mode == Mode.TABLE) {
            for (ColumnInfo inf : columns) {
                colsMap.put(inf.header, inf);
                final ColumnInfo header = inf;
                TableViewerColumn c = new TableViewerColumn(this.viewer, 16384);
                c.getColumn().setText(inf.header);
                c.getColumn().setWidth(100);
                if (inf.tooltip != null) {
                    c.getColumn().setToolTipText(inf.tooltip);
                }
                c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return ((IElement)element).getText(header.header);
                    }
                });
                if (!enableEdition) continue;
                c.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

                    protected void setValue(Object element, Object value) {
                        ((IElement)element).setText(header.header, value.toString());
                        EditableViewerUI.this.viewer.refresh(element);
                    }

                    protected Object getValue(Object element) {
                        return ((IElement)element).getText(header.header);
                    }

                    protected CellEditor getCellEditor(Object element) {
                        switch (header.type) {
                            case BOOLEAN: {
                                return new CheckboxCellEditor((Composite)EditableViewerUI.this.viewer.getTable(), 0);
                            }
                        }
                        return new TextCellEditor((Composite)EditableViewerUI.this.viewer.getTable());
                    }

                    protected boolean canEdit(Object element) {
                        return true;
                    }
                });
            }
            if (!enableEdition) {
                this.labelRowNumber = new Label(main, 0);
                this.labelRowNumber.setLayoutData((Object)new GridData(3, 4, true, false));
            }
        } else {
            TableViewerColumn c = new TableViewerColumn(this.viewer, 16384);
            c.getColumn().setText(Messages.EditableViewerUI_4);
            c.getColumn().setWidth(100);
            c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((String[])element)[0];
                }

                public String getToolTipText(Object element) {
                    if (!EditableViewerUI.this.input.isEmpty()) {
                        for (ColumnInfo c : EditableViewerUI.this.input.get(0).getColumnInfo()) {
                            if (c.tooltip == null || !c.header.equals(((String[])element)[0])) continue;
                            return c.tooltip;
                        }
                    }
                    return super.getToolTipText(element);
                }
            });
            c = new TableViewerColumn(this.viewer, 16384);
            c.getColumn().setText(Messages.EditableViewerUI_5);
            c.getColumn().setWidth(250);
            c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((String[])element)[1];
                }
            });
            if (enableEdition) {
                c.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

                    protected void setValue(Object element, Object value) {
                        String[] e = (String[])element;
                        e[1] = value.toString();
                        EditableViewerUI.this.input.get(0).setText(e[0], e[1]);
                        EditableViewerUI.this.viewer.refresh(element);
                    }

                    protected Object getValue(Object element) {
                        String[] e = (String[])element;
                        return e[1];
                    }

                    protected CellEditor getCellEditor(Object element) {
                        return new TextCellEditor((Composite)EditableViewerUI.this.viewer.getTable());
                    }

                    protected boolean canEdit(Object element) {
                        return true;
                    }
                });
            }
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        }
        return main;
    }

    public void addContentListener(IContentListener listener) {
        this.listeners.add(listener);
    }

    private void notifyContentListeners(int rownumbers) {
        for (IContentListener l : this.listeners) {
            if (rownumbers < 0) continue;
            l.handleContentChanged(rownumbers);
        }
    }

    public static class ColumnInfo
    implements Serializable {
        private static final long serialVersionUID = 6813246585087159428L;
        String header;
        String tooltip;
        DataType type;
        String maxSize;

        public ColumnInfo() {
        }

        public ColumnInfo(String header, DataType type, String tooltip) {
            this.header = header;
            this.type = type;
            this.tooltip = tooltip;
        }
    }

    static enum DataType {
        STRING,
        BOOLEAN,
        INTEGER;

    }

    public static class Element
    implements IElement,
    Serializable {
        private static final long serialVersionUID = 7347735439446067757L;
        private Map<String, String> datas = new HashMap<String, String>();
        private Map<String, ColumnInfo> _columnInfos;
        private Collection<ColumnInfo> columnInfos;

        public Element() {
        }

        public Element(Collection<ColumnInfo> columnInfos, Map<String, String> datas) {
            this.columnInfos = new ArrayList<ColumnInfo>(columnInfos);
            this._columnInfos = new HashMap<String, ColumnInfo>();
            this.datas = datas;
        }

        @Override
        public String getText(String columnName) {
            String s = this.datas.get(columnName);
            if (s == null) {
                return "";
            }
            return s;
        }

        @Override
        public void setText(String columnName, String value) {
            this.datas.put(columnName, value);
        }

        @Override
        public Collection<ColumnInfo> getColumnInfo() {
            return this.columnInfos;
        }

        @Override
        public Object getValueForSAP(String header) {
            if (this._columnInfos.get(header) == null) {
                for (ColumnInfo c : this.columnInfos) {
                    this._columnInfos.put(c.header, c);
                }
            }
            ColumnInfo i = this._columnInfos.get(header);
            switch (i.type) {
                case BOOLEAN: {
                    return Boolean.valueOf(this.datas.get(header));
                }
                case INTEGER: {
                    return Integer.valueOf(this.datas.get(header));
                }
            }
            return this.datas.get(header);
        }
    }

    public static interface IContentListener {
        public void handleContentChanged(int var1);
    }

    public static interface IElement {
        public String getText(String var1);

        public void setText(String var1, String var2);

        public Collection<ColumnInfo> getColumnInfo();

        public Object getValueForSAP(String var1);
    }

    static enum Mode {
        TABLE,
        LIST;

    }
}

