/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.delivery.repository.aws.s3.impl;

import com.indy.engine.core.repository.CommonDeliveryRepositoryStore;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.runtime.utils.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;

public class AmazonS3Storage
extends CommonDeliveryRepositoryStore {
    public static final String AWS_TYPE = "Amazon S3";
    public static final String AWS_REGION = "awsRegion";
    public static final String BUCKET_NAME = "bucket";
    public static final String PATH_ATTR = "path";
    public static final String FILE_EXTENSION = ".deliv";
    private String region = null;
    private String bucket = null;
    private String path = null;
    private S3Client service;
    private long refreshDelay = 1000L;

    public AmazonS3Storage(IPluginFactory.IPluginConfiguration conf, AwsCredentialsProvider credentials) {
        super(conf);
        this.region = conf.getProperty(AWS_REGION);
        this.bucket = conf.getProperty(BUCKET_NAME);
        this.path = conf.getProperty(PATH_ATTR) != null && !conf.getProperty(PATH_ATTR).equals("/") ? conf.getProperty(PATH_ATTR) : "";
        this.service = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(credentials)).region(Region.of((String)this.region))).build();
    }

    public String getType() {
        return AWS_TYPE;
    }

    protected String getPath() {
        return this.path;
    }

    public List<S3Object> getList() {
        ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket).prefix(this.path).build();
        ListObjectsV2Iterable listObjectsV2Iterable = this.service.listObjectsV2Paginator(listObjectsV2Request);
        ArrayList<S3Object> s3ObjectsList = new ArrayList<S3Object>();
        for (ListObjectsV2Response page : listObjectsV2Iterable) {
            s3ObjectsList.addAll(page.contents());
        }
        return s3ObjectsList;
    }

    public ResponseInputStream<GetObjectResponse> getObject(String key) {
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(key).build();
        return this.service.getObject(getObjectRequest);
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo createDelivery(String deliveryFileName, File file, File cacheFolder) throws IOException {
        if (!deliveryFileName.endsWith(FILE_EXTENSION)) {
            throw new IOException("Delivery file name must end with .deliv");
        }
        String deliveryPath = this.getDeliveryPath(deliveryFileName);
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(deliveryPath).build();
        this.service.putObject(putObjectRequest, Paths.get(file.getPath(), new String[0]));
        IDeliveryRepositoryPlugin.DeliveryInfo info = new IDeliveryRepositoryPlugin.DeliveryInfo();
        info.setName(deliveryFileName);
        info.setFile(this.getFile(deliveryPath, (InputStream)this.getObject(deliveryPath), cacheFolder));
        return info;
    }

    private File getFile(String fileName, InputStream is, File cacheFolder) throws IOException {
        File f = new File(cacheFolder, fileName);
        f.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return f;
    }

    private String getDeliveryPath(String deliveryFileName) {
        StringBuilder sb = new StringBuilder(this.path);
        if (!"/".equals(this.path) && !this.path.isEmpty()) {
            sb.append("/");
        }
        sb.append(deliveryFileName);
        return sb.toString();
    }

    public void removeDelivery(String deliveryName) throws IOException {
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            throw new IOException("File does not end with .deliv, it is not a delivery");
        }
        String deliveryPath = this.getDeliveryPath(deliveryName);
        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(deliveryPath).build();
        this.service.deleteObject(deleteObjectRequest);
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }
}

