/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.sap.ui;

import com.indy.addons.sap.properties.SapConnectionComposite;
import com.indy.addons.sap.reverse.SAPFactoryProvider;
import com.indy.addons.sap.ui.BapiControler;
import com.indy.addons.sap.ui.EditableViewerUI;
import com.indy.connector.sap.core.ISAPReverseAPI;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BapiInvoker {
    ISAPReverseAPI sapAPI;
    ISAPReverseAPI.ISAPConnection connection;
    ISAPReverseAPI.IJCoFunction function;
    BapiControler controler;
    private MdNode sapServer;

    public BapiInvoker(MdNode bapi, BapiControler controler) {
        this.controler = controler;
        this.sapServer = bapi;
        while (!this.sapServer.getDefType().equals("com.stambia.appl.sap.server")) {
            this.sapServer = (MdNode)this.sapServer.eContainer();
        }
    }

    private void init() throws Exception {
        if (this.connection == null || this.function == null) {
            SapConnectionComposite.connect(this.sapServer, true, true);
            String moduleName = null;
            try {
                moduleName = this.sapServer.evaluate("@module");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sapAPI = SAPFactoryProvider.INSTANCE.getReverseFactory(moduleName).createAPI(this.connection);
            this.function = this.sapAPI.createFunction(this.controler.getBapiName().toUpperCase());
        }
    }

    public void prepare(List<EditableViewerUI.IElement> parametersData, Map<String, EditableViewerUI.IElement> structureDatas, Map<String, List<EditableViewerUI.IElement>> tableData) throws Exception {
        this.init();
        ISAPReverseAPI.IJCoParameterList paramList = this.function.getImportParameterList();
        paramList.clear();
        for (EditableViewerUI.IElement e : parametersData) {
            for (EditableViewerUI.ColumnInfo i : e.getColumnInfo()) {
                Iterator<EditableViewerUI.IElement> o = e.getValueForSAP(i.header);
                if (o == null) {
                    o = "";
                }
                paramList.setValue(i.header, (Object)o);
            }
        }
        for (String k : tableData.keySet()) {
            ISAPReverseAPI.IJCoTable table = this.function.getTableParameterList().getTable(k);
            table.clear();
            table.appendRows(tableData.get(k).size());
            for (EditableViewerUI.IElement e : tableData.get(k)) {
                for (EditableViewerUI.ColumnInfo i : e.getColumnInfo()) {
                    Object o = e.getValueForSAP(i.header);
                    if (o == null) continue;
                    table.setValue(i.header, o);
                }
                table.nextRow();
            }
        }
        for (String k : structureDatas.keySet()) {
            ISAPReverseAPI.IJCoStructure structure = this.function.getImportParameterList().getStructure(k);
            structure.clear();
            List<EditableViewerUI.IElement> l = tableData.get(k);
            if (l == null) continue;
            for (EditableViewerUI.IElement e : l) {
                for (EditableViewerUI.ColumnInfo i : e.getColumnInfo()) {
                    Object o = e.getValueForSAP(i.header);
                    if (o == null) continue;
                    structure.setValue(i.header, o);
                }
            }
        }
    }

    public void cancel() throws Exception {
        SapConnectionComposite.disConnect(this.sapServer);
        this.function = null;
    }

    public void invoke() throws Exception {
        this.function.execute();
    }

    private List<EditableViewerUI.IElement> getTablesData(String tableName, Collection<EditableViewerUI.ColumnInfo> cols) {
        ArrayList<EditableViewerUI.IElement> res = new ArrayList<EditableViewerUI.IElement>();
        ISAPReverseAPI.IJCoTable t = this.function.getTableParameterList().getTable(tableName);
        t.firstRow();
        if (t.getNumRows() > 0) {
            do {
                HashMap<String, String> datas = new HashMap<String, String>();
                for (EditableViewerUI.ColumnInfo i : cols) {
                    datas.put(i.header, String.valueOf(t.getValue(i.header)));
                }
                res.add(new EditableViewerUI.Element(cols, datas));
            } while (t.nextRow());
        }
        return res;
    }

    private List<EditableViewerUI.IElement> getStructureData(String tableName, Collection<EditableViewerUI.ColumnInfo> cols) {
        ArrayList<EditableViewerUI.IElement> res = new ArrayList<EditableViewerUI.IElement>();
        ISAPReverseAPI.IJCoStructure t = this.function.getExportParameterList().getStructure(tableName);
        HashMap<String, String> datas = new HashMap<String, String>();
        for (EditableViewerUI.ColumnInfo i : cols) {
            datas.put(i.header, String.valueOf(t.getValue(i.header)));
        }
        res.add(new EditableViewerUI.Element(cols, datas));
        return res;
    }

    public Map<String, List<EditableViewerUI.IElement>> getOutputTablesDatas() {
        HashMap<String, List<EditableViewerUI.IElement>> res = new HashMap<String, List<EditableViewerUI.IElement>>();
        for (String tname : this.controler.getTables().keySet()) {
            res.put(tname, this.getTablesData(tname, (Collection<EditableViewerUI.ColumnInfo>)this.controler.getTables().get(tname)));
        }
        return res;
    }

    public Map<String, List<EditableViewerUI.IElement>> getOutputStructureDatas() {
        HashMap<String, List<EditableViewerUI.IElement>> res = new HashMap<String, List<EditableViewerUI.IElement>>();
        for (String tname : this.controler.getOutputStructures().keySet()) {
            res.put(tname, this.getStructureData(tname, (Collection<EditableViewerUI.ColumnInfo>)this.controler.getOutputStructures().get(tname)));
        }
        return res;
    }

    public List<EditableViewerUI.IElement> getOutputParameterDatas() {
        ArrayList<EditableViewerUI.IElement> res = new ArrayList<EditableViewerUI.IElement>();
        HashMap<String, String> datas = new HashMap<String, String>();
        if (!this.controler.getOutputParametersColumns().isEmpty()) {
            ISAPReverseAPI.IJCoParameterFieldIterator it = this.function.getExportParameterList().getParameterFieldIterator();
            while (it.hasNextField()) {
                ISAPReverseAPI.IJCoField f = it.nextField();
                datas.put(f.getName(), f.getString());
            }
            res.add(new EditableViewerUI.Element(this.controler.outputParametersColumns, datas));
        }
        return res;
    }
}

