/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.microsoft.excel.wizard;

import com.indy.addons.microsoft.excel.Messages;
import com.indy.addons.microsoft.excel.wizard.Constant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExcelWizardBean {
    private PATH_TYPE pathType = PATH_TYPE.LEGACY;
    private String fileFolderPath = "";
    private Style columnNameStyle = Style.PRESERVE;
    private List<DefinedName> definedNames = new ArrayList<DefinedName>();
    private static PATH_TYPE lastPathType;
    private static String lastFile;

    protected PATH_TYPE getPathType() {
        return this.pathType;
    }

    protected void setPathType(PATH_TYPE pathType) {
        this.pathType = pathType;
        lastPathType = pathType;
    }

    protected String getFileFolderPath() {
        return this.fileFolderPath;
    }

    protected void setFileFolderPath(String path) {
        int index;
        this.fileFolderPath = path;
        lastFile = path;
        String separator = System.getProperty("file.separator");
        if (lastFile.contains(separator)) {
            index = lastFile.lastIndexOf(separator);
            lastFile = lastFile.substring(index + 1);
        }
        if (lastFile.endsWith(".xlsx")) {
            index = lastFile.length() - Constant.EXCEL_EXTENSION_LENGTH;
            lastFile = lastFile.substring(0, index);
        }
    }

    protected Style getColumnNameStyle() {
        return this.columnNameStyle;
    }

    protected void setColumnNameStyle(String columnNameStyle) {
        this.columnNameStyle = Style.stringValues().contains(columnNameStyle) ? Style.valueOf(columnNameStyle) : null;
    }

    protected List<DefinedName> getDefinedNames() {
        return this.definedNames;
    }

    protected void addDefinedName(DefinedName definedName) {
        this.definedNames.add(definedName);
    }

    protected static class DefinedName {
        private String name = Messages.default_name;
        private String file = Messages.default_file;
        private String sheet = Messages.default_sheet;
        private String area = Messages.default_area;

        public DefinedName() {
            if (lastPathType != null && lastPathType == PATH_TYPE.FILE) {
                this.file = lastFile;
            }
        }

        protected String getName() {
            return this.name;
        }

        protected String getFile() {
            return this.file;
        }

        protected String getSheet() {
            return this.sheet;
        }

        protected String getArea() {
            return this.area;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected void setFile(String file) {
            this.file = file;
        }

        protected void setSheet(String sheet) {
            this.sheet = sheet;
        }

        protected void setArea(String area) {
            this.area = area;
        }
    }

    protected static enum PATH_TYPE {
        FOLDER,
        FILE,
        LEGACY;

    }

    protected static enum Style {
        FLAT,
        PRESERVE,
        NORMALIZE;


        protected static Set<String> stringValues() {
            HashSet<String> values = new HashSet<String>();
            Style[] styleArray = Style.values();
            int n = styleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Style pathType = styleArray[n2];
                values.add(pathType.toString());
                ++n2;
            }
            return values;
        }
    }
}

