/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb;

import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.UtilsService;
import com.stambia.mongodb.Messages;
import com.stambia.mongodb.MongoDBOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.UnaryOperator;

public class MongoDBOutputStreamTransformer
extends OutputStreamTransformer {
    MongoDBOperation mdb;
    UnaryOperator<String> resolveExtValue = t -> {
        try {
            return new SecretValueImpl(t, arg_0 -> ((ISecretService)UtilsService.getSecretService()).decryptString(arg_0), arg_0 -> ((ISecretService)UtilsService.getSecretService()).encryptString(arg_0)).resolveStringSecretValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    };

    public String getProperty(String key, boolean mustExists, String defaultValue) {
        String str = this.getProperty(key);
        if ((str == null || str.isEmpty()) && mustExists && defaultValue == null) {
            throw new RuntimeException(Messages.getString("MongoDBOutputStreamTransformer.0") + key + Messages.getString("MongoDBOutputStreamTransformer.1"));
        }
        if (str == null || str.isEmpty()) {
            str = defaultValue;
        }
        return str;
    }

    public void interrupt() {
        if (this.mdb != null) {
            this.mdb.interrupt();
        }
    }

    public void transform(InputStream inputStream, OutputStream outputStream) throws Exception {
        String mongoDbUrl = this.getProperty("mongoDbUrl", false, null);
        String mongoHost = this.getProperty("mongoHost", false, null);
        String mongoPort = this.getProperty("mongoPort", false, null);
        String mongoUser = this.getProperty("mongoUser", false, null);
        String mongoPassword = this.getProperty("mongoPassword", false, null);
        String mongoAuthDatabase = this.getProperty("mongoAuthDatabase", false, null);
        String mongoConnectionMethod = this.getProperty("mongoConnectionMethod", false, "URL");
        MongoDBOperation.Operator operator = MongoDBOperation.Operator.valueOf(this.getProperty("operator", false, "insert"));
        String findQuery = null;
        if (operator == MongoDBOperation.Operator.find) {
            findQuery = this.getProperty("findQuery", true, null);
        }
        String updateKeys = this.getProperty("updateKeys", false, null);
        String database = this.getProperty("database", true, null);
        String collection = this.getProperty("collection", true, null);
        boolean dropCollection = Boolean.valueOf(this.getProperty("dropCollection", false, "false"));
        boolean deleteCollection = Boolean.valueOf(this.getProperty("deleteCollection", false, "false"));
        int batchSize = Integer.valueOf(this.getProperty("batchSize", false, "100"));
        boolean applySkipLimit = Boolean.valueOf(this.getProperty("applySkipLimit", false, "false"));
        boolean useCount = Boolean.valueOf(this.getProperty("useCount", false, "false"));
        if (!mongoConnectionMethod.contentEquals("URL") && !mongoConnectionMethod.contentEquals("UserPassword")) {
            throw new RuntimeException(Messages.getString("MongoDBOutputStreamTransformer.2"));
        }
        if (mongoConnectionMethod.contentEquals("URL") && (mongoDbUrl == null || mongoDbUrl.isEmpty())) {
            throw new RuntimeException(Messages.getString("MongoDBOutputStreamTransformer.3"));
        }
        if (mongoConnectionMethod.contentEquals("UserPassword")) {
            if (mongoHost == null || mongoHost.isEmpty()) {
                throw new RuntimeException(Messages.getString("MongoDBOutputStreamTransformer.4"));
            }
            if (mongoPort == null || mongoPort.isEmpty()) {
                throw new RuntimeException(Messages.getString("MongoDBOutputStreamTransformer.5"));
            }
            if (mongoUser == null || mongoUser.isEmpty()) {
                throw new RuntimeException(Messages.getString("MongoDBOutputStreamTransformer.6"));
            }
            if (mongoPassword == null || mongoPassword.isEmpty()) {
                throw new RuntimeException(Messages.getString("MongoDBOutputStreamTransformer.7"));
            }
        }
        this.mdb = new MongoDBOperation((String)this.resolveExtValue.apply(mongoDbUrl), (String)this.resolveExtValue.apply(mongoHost), (String)this.resolveExtValue.apply(mongoPort), (String)this.resolveExtValue.apply(mongoUser), (String)this.resolveExtValue.apply(mongoPassword), (String)this.resolveExtValue.apply(mongoAuthDatabase), mongoConnectionMethod, database, collection, updateKeys, operator, findQuery, batchSize, dropCollection, deleteCollection, applySkipLimit, useCount){

            @Override
            public OutputStreamTransformer.OutputStreamTransformerStatisticHandler getHandler() {
                return MongoDBOutputStreamTransformer.this.getStatisticHandler();
            }
        };
        this.mdb.execute(inputStream, "UTF-8", outputStream, "UTF-8");
    }
}

