/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.delivery.repository.azure.blob.storage.impl;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobItemProperties;
import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.delivery.repository.azure.blob.storage.impl.AzureBlobStorage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class AzureBlobStorageRepository
implements IDeliveryRepositoryPlugin {
    private final AzureBlobStorage store;
    protected File cacheFolder = null;
    protected final Map<String, DeliveryInfoWrapper> deliveriesInfo = new ConcurrentHashMap<String, DeliveryInfoWrapper>();
    protected static final String FILE_EXTENSION = ".deliv";
    protected static final String PATH_SEPARATOR = "/";
    private long lastRefreshTime = 0L;

    public AzureBlobStorageRepository(IPluginFactory.IPluginConfiguration configuration) {
        this.store = new AzureBlobStorage(configuration);
    }

    public File getDeliveryContent(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) throws Exception {
        if (deliveryInfo.getFile() == null) {
            String deliveryName = deliveryInfo.getName();
            deliveryInfo = this.getDeliveryInfo(deliveryName);
        }
        return deliveryInfo.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfo(boolean refresh) throws Exception {
        if (refresh && System.currentTimeMillis() - this.lastRefreshTime > this.store.getRefreshDelay()) {
            this.lastRefreshTime = System.currentTimeMillis();
            HashMap<String, DeliveryInfoWrapper> currInfos = new HashMap<String, DeliveryInfoWrapper>();
            PagedIterable<BlobItem> results = this.store.listBlobs();
            for (BlobItem item : results) {
                if (!item.getName().endsWith(FILE_EXTENSION)) continue;
                BlobClient delivery = this.store.getBlobClientFromName(item.getName());
                String deliveryName = this.getDeliveryNameFromBlob(delivery);
                IDeliveryRepositoryPlugin.DeliveryInfo info = this.createDeliveryInfo(delivery);
                BlobItemProperties props = item.getProperties();
                currInfos.put(deliveryName, new DeliveryInfoWrapper(info, props.getLastModified().toEpochSecond()));
            }
            List<String> keys = this.getKeysDifference(currInfos);
            for (String key : keys) {
                this.deliveriesInfo.remove(key);
            }
            Map<String, DeliveryInfoWrapper> map = this.deliveriesInfo;
            synchronized (map) {
                for (Map.Entry<String, DeliveryInfoWrapper> entry : currInfos.entrySet()) {
                    DeliveryInfoWrapper currInfo = entry.getValue();
                    DeliveryInfoWrapper oldInfo = this.deliveriesInfo.get(entry.getKey());
                    if (oldInfo != null && oldInfo.getLastUpdateTimestamp().equals(currInfo.getLastUpdateTimestamp())) continue;
                    this.deliveriesInfo.put(entry.getKey(), currInfo);
                }
            }
        }
        return this.getDeliveriesInfoUnwrapped(this.deliveriesInfo);
    }

    private List<String> getKeysDifference(HashMap<String, DeliveryInfoWrapper> currInfos) {
        return currInfos.entrySet().stream().filter(e -> !this.deliveriesInfo.containsKey(e.getKey())).map(Map.Entry::getKey).toList();
    }

    private Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfoUnwrapped(Map<String, DeliveryInfoWrapper> infos) {
        return infos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((DeliveryInfoWrapper)e.getValue()).getInfo()));
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(String deliveryName) throws Exception {
        this.getDeliveriesInfo(true);
        DeliveryInfoWrapper wrapper = this.deliveriesInfo.get(deliveryName);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getInfo();
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo putDelivery(InputStream inputStream, String deliveryName) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo info = null;
        StringBuilder fileName = new StringBuilder(deliveryName);
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            fileName.append(FILE_EXTENSION);
        }
        BlobClient blob = this.store.createDelivery(fileName.toString(), this.getFile(fileName.toString(), inputStream));
        info = this.createDeliveryInfo(blob);
        return info;
    }

    public void removeDelivery(String deliveryName) throws Exception {
        StringBuilder sb = new StringBuilder(deliveryName);
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            sb.append(FILE_EXTENSION);
        }
        this.store.removeDelivery(sb.toString());
        this.deliveriesInfo.remove(deliveryName);
    }

    private IDeliveryRepositoryPlugin.DeliveryInfo createDeliveryInfo(BlobClient blob) throws IOException {
        IDeliveryRepositoryPlugin.DeliveryInfo info = new IDeliveryRepositoryPlugin.DeliveryInfo();
        String deliveryName = this.getDeliveryNameFromBlob(blob);
        info.setName(deliveryName);
        info.setFile(this.getFile(deliveryName, (InputStream)blob.openInputStream()));
        return info;
    }

    private String getDeliveryNameFromBlob(BlobClient blob) {
        return blob.getBlobName().substring(this.store.getPath().length(), blob.getBlobName().lastIndexOf("."));
    }

    private File getFile(String deliveryName, InputStream is) throws IOException {
        File f = new File(this.cacheFolder, deliveryName);
        f.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return f;
    }

    public IDeliveryRepositoryInfo getInfos() {
        return this.store;
    }

    public void setCacheFolder(File cacheFolder) {
        this.cacheFolder = cacheFolder;
    }

    private class DeliveryInfoWrapper {
        private IDeliveryRepositoryPlugin.DeliveryInfo info;
        private long lastUpdateTimestamp;

        public DeliveryInfoWrapper(IDeliveryRepositoryPlugin.DeliveryInfo info, long timestamp) {
            this.info = info;
            this.lastUpdateTimestamp = timestamp;
        }

        public IDeliveryRepositoryPlugin.DeliveryInfo getInfo() {
            return this.info;
        }

        public Long getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }
    }
}

