/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest;

import com.indy.addons.httprest.Messages;
import com.indy.addons.httprest.internal.OpenApiVisitor;
import com.indy.addons.httprest.internal.Utils;
import com.semarchy.xdi.base.core.auth.AuthenticationFactory;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.designer.core.http.ApacheHttpClient;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdAttributeReader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ReverseOpenApiAction
implements IExecute {
    private static final List<String> excludeAttributeToUpdate = new ArrayList<String>();
    private static final Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseModes = new HashMap<String, IncrementalReverser.IReverseMatchingStrategy>();
    private static final OpenAPIV3Parser openAPIParser = new OpenAPIV3Parser();

    public final Object run(Object mdNode, String configuration, Map<String, String> params) throws ExecuteException {
        Utils.logger.debug("START openAPI reverse");
        MdNode rootNode = (MdNode)mdNode;
        try {
            MdNode openApiSchemaNode = null;
            try {
                openApiSchemaNode = ReverseOpenApiAction.createReversedMdNode(rootNode, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OpenAPIException ex) {
                if (MessageDialog.open((int)4, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ReverseOpenApiAction_4, (String)ex.getMessage(), (int)0, (String[])new String[]{Messages.ReverseOpenApiAction_5, Messages.ReverseOpenApiAction_6}) == 0) {
                    openApiSchemaNode = ex.getOpenAPIToMd();
                }
                throw ex;
            }
            ReverseOpenApiAction.incrementalReverse(rootNode, openApiSchemaNode);
        }
        catch (Exception exception) {
            throw new ExecuteException(exception);
        }
        Utils.logger.debug("STOP openAPI reverse");
        return null;
    }

    private static void incrementalReverse(MdNode rootNode, MdNode newRootNode) throws Exception {
        HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
        reversedMap.put(newRootNode, rootNode);
        IncrementalReverser reverser = new IncrementalReverser(rootNode.getSubstituteContainer(), reversedMap, excludeAttributeToUpdate, true, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, reverseModes, true);
        reverser.reverse();
    }

    public static final MdNode createReversedMdNode(MdNode rootNode, IProgressMonitor monitor) throws Exception {
        OpenAPI openAPISchema = null;
        OpenAPIException openAPiError = null;
        try {
            openAPISchema = ReverseOpenApiAction.getSchemaFromOpenApi(rootNode);
        }
        catch (OpenAPIException ex) {
            openAPISchema = ex.openAPI;
            openAPiError = ex;
        }
        MdNode openApiSchemaNode = null;
        try {
            int recursivityLevel = ReverseOpenApiAction.getRecursivityDepth(rootNode);
            openApiSchemaNode = rootNode.copy(1);
            openApiSchemaNode.setSubstituteContainer(rootNode.getSubstituteContainer());
            OpenApiVisitor openApiVisitor = new OpenApiVisitor(openApiSchemaNode, recursivityLevel, monitor);
            openApiVisitor.visit(openAPISchema);
            if (openAPiError != null) {
                throw openAPiError;
            }
            return openApiSchemaNode;
        }
        catch (OpenAPIException ex) {
            ex.openAPIToMd = openApiSchemaNode;
            throw ex;
        }
        catch (Exception ex) {
            throw new Exception(Messages.ReverseOpenApiAction_8, ex);
        }
    }

    private static ApacheHttpClient buildHttpClient(MdNode trustStore, MdNode proxyNode) throws Exception {
        ApacheHttpClient.SslConfig sslConfig = null;
        if (trustStore != null) {
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().setKeyStoreType(MdAttributeReader.readAttribute((String)"type", (MdNode)trustStore)).loadTrustMaterial(new File(MdAttributeReader.readAttribute((String)"filePath", (MdNode)trustStore)), MdAttributeReader.readAttribute((String)"password", (MdNode)trustStore).toCharArray());
            sslConfig = new ApacheHttpClient.SslConfig(sslContextBuilder.build());
        }
        if (proxyNode != null) {
            ApacheHttpClient.ProxyConfig proxyConfig = new ApacheHttpClient.ProxyConfig(MdAttributeReader.readAttribute((String)"host", (MdNode)proxyNode), Integer.parseInt(MdAttributeReader.readAttribute((String)"port", (MdNode)proxyNode)), MdAttributeReader.readAttribute((String)"username", (MdNode)proxyNode), MdAttributeReader.readAttribute((String)"password", (MdNode)proxyNode));
            return ApacheHttpClient.build((ApacheHttpClient.ProxyConfig)proxyConfig, sslConfig);
        }
        return ApacheHttpClient.build(sslConfig);
    }

    static OpenAPI doGetSchemaFromOpenApi(String openApiReverseUrl, MdNode securityNode, MdNode proxyNode, MdNode trustStore) throws Exception {
        SwaggerParseResult swaggerParseResult;
        List messages;
        boolean isNtlm = false;
        HashMap<String, String> headers = new HashMap<String, String>();
        String protocol = "http";
        String openApiAsText = "";
        try {
            String string = protocol = openApiReverseUrl.startsWith("file:") ? "file" : "http";
            if (protocol.equals("file")) {
                String escapedUrl = openApiReverseUrl.replace("\\", "/");
                Path path = Paths.get(URI.create(escapedUrl));
                openApiAsText = FileUtils.readFileToString((File)path.toFile(), (String)StandardCharsets.UTF_8.displayName());
            }
        }
        catch (MalformedURLException e) {
            Utils.logger.warn(String.format("Could not parse protocol from %s. The default http protocol will be used for reverse.", openApiReverseUrl));
        }
        if (!protocol.equals("file")) {
            if (securityNode != null) {
                String props = securityNode.evaluate("./internal:toJavaProperties()");
                Properties p = new Properties();
                p.load(new StringReader(props));
                p.setProperty("type", securityNode.evaluate("name()"));
                isNtlm = "ntlm".equals(securityNode.evaluate("name()"));
                URL reverseURL = new URL(openApiReverseUrl);
                headers.put("Authorization", AuthenticationFactory.getAuthHeader((Map)OAuth2Utils.convertPropertiesToMap((Properties)p), (String)"GET", (URL)reverseURL, null));
            }
            Credentials credentials = null;
            if (isNtlm) {
                credentials = ApacheHttpClient.createNTAuthCredentials((String)MdAttributeReader.readAttribute((String)"userName", (MdNode)securityNode), (char[])MdAttributeReader.readAttribute((String)"password", (MdNode)securityNode).toCharArray(), (String)MdAttributeReader.readAttribute((String)"domain", (MdNode)securityNode));
            }
            ApacheHttpClient httpClient = ReverseOpenApiAction.buildHttpClient(trustStore, proxyNode);
            openApiAsText = (String)httpClient.get(openApiReverseUrl, Collections.emptyMap(), headers, credentials, false, r -> EntityUtils.toString((HttpEntity)r.getEntity()));
        }
        if ((messages = (swaggerParseResult = openAPIParser.readContents(openApiAsText)).getMessages()) != null && !messages.isEmpty()) {
            throw new OpenAPIException(swaggerParseResult);
        }
        OpenAPI openAPISchema = swaggerParseResult.getOpenAPI();
        Utils.logger.debug("Open API schema: {}", (Object)openAPISchema);
        return openAPISchema;
    }

    private static final OpenAPI getSchemaFromOpenApi(MdNode rootNode) throws Exception {
        String openApiReverseUrl = rootNode.evaluate("@reverseUrl");
        Utils.logger.debug("Open API reverse URL: {}", (Object)openApiReverseUrl);
        if (openApiReverseUrl != null && openApiReverseUrl.trim().length() > 0) {
            MdNode securityNode = MdAttributeReader.readAttributeRef((String)"security", (MdNode)rootNode);
            MdNode proxyNode = MdAttributeReader.readAttributeRef((String)"proxy", (MdNode)rootNode);
            MdNode trustStore = MdAttributeReader.readAttributeRef((String)"truststore", (MdNode)rootNode);
            return ReverseOpenApiAction.doGetSchemaFromOpenApi(openApiReverseUrl, securityNode, proxyNode, trustStore);
        }
        throw new Exception(Messages.ReverseOpenApiAction_36);
    }

    private static final int getRecursivityDepth(MdNode rootNode) throws Exception {
        int recursivityLevel;
        String recursivityDepth = MdAttributeReader.readAttribute((String)"recursivityDepth", (MdNode)rootNode);
        Utils.logger.debug("recursivity depth: {}", (Object)recursivityDepth);
        try {
            recursivityLevel = Integer.valueOf(recursivityDepth);
        }
        catch (Exception exception) {
            throw new Exception(Messages.ReverseOpenApiAction_39 + recursivityDepth);
        }
        if (recursivityLevel <= 0) {
            throw new Exception(Messages.ReverseOpenApiAction_40 + recursivityDepth);
        }
        return recursivityLevel;
    }

    public static class OpenAPIException
    extends Exception {
        MdNode openAPIToMd;
        private OpenAPI openAPI;
        private String message;

        public OpenAPIException(SwaggerParseResult result) {
            this.openAPI = result.getOpenAPI();
            StringBuilder b = new StringBuilder();
            for (String s : result.getMessages()) {
                if (b.length() > 0) {
                    b.append("\n");
                }
                b.append(s);
            }
            this.message = Messages.ReverseOpenApiAction_2 + b.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public MdNode getOpenAPIToMd() {
            return this.openAPIToMd;
        }
    }
}

