/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.wizard.AbstractNodeHandler;
import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.RestWizardBean;
import com.indy.addons.httprest.wizard.RestWizardControler;
import com.indy.addons.json.actions.ReverseJsonAction;
import com.indy.addons.xml.XmlStreamReverser;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdAttributeReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.eclipse.emf.ecore.EObject;

public class NodeHandlerWsdl
extends AbstractNodeHandler {
    RestWizardControler controler;
    private final org.apache.logging.log4j.Logger logger = LogManager.getLogger(this.getClass());

    public NodeHandlerWsdl(RestWizardControler controler) {
        this.controler = controler;
    }

    @Override
    public void fillBean(MdNode reversedMdNode) {
        String trustStorePath;
        String keyStorePath;
        String enableHostnameVerification;
        Object resource;
        String endPoint;
        String method;
        Object operationName;
        RestWizardBean bean = this.controler.getBean();
        RestWizardControler.InputHint hint = this.controler.getHint();
        MdNode containerMdNode = (MdNode)reversedMdNode.eContainer();
        String fullURIStr = NodeHandlerWsdl.readAttribute("address", containerMdNode);
        if (fullURIStr == null) {
            fullURIStr = "";
        }
        if ((operationName = NodeHandlerWsdl.readAttribute("address", reversedMdNode)) == null) {
            operationName = "";
        }
        if (fullURIStr.endsWith("/")) {
            if (((String)operationName).startsWith("/")) {
                operationName = ((String)operationName).substring(1);
            }
        } else if (!((String)operationName).startsWith("/")) {
            operationName = "/" + (String)operationName;
        }
        ArrayList<String[]> headers = new ArrayList<String[]>();
        String mediaType = null;
        for (MdNode n : reversedMdNode.getNodeByCode("com.stambia.wsdl.input")) {
            for (MdNode param : n.getNodeByCode("com.stambia.wsdl.part")) {
                String bindingType = NodeHandlerWsdl.readAttribute("bindingType", param);
                if (RestWizardControler.BindingType.HTTP_URL_ENCODED.getCode().equals(bindingType)) {
                    bean.addParameter(param.getName(), hint.parameterValues.get(param.getName()), RestWizardControler.BindingType.HTTP_URL_ENCODED, true, true);
                    continue;
                }
                if (RestWizardControler.BindingType.HTTP_URL_REPLACEMENT.getCode().equals(bindingType)) {
                    bean.addParameter(param.getName(), hint.parameterValues.get(param.getName()), RestWizardControler.BindingType.HTTP_URL_REPLACEMENT, true, true);
                    continue;
                }
                if (RestWizardControler.BindingType.MIME_CONTENT.getCode().equals(bindingType)) {
                    String s = NodeHandlerWsdl.readAttribute("contentType", param);
                    if ("application/x-www-form-urlencoded".equals(s)) {
                        bean.addParameter(param.getName(), hint.parameterValues.get(param.getName()), RestWizardControler.BindingType.MIME_CONTENT, true, true);
                    }
                    mediaType = s;
                    continue;
                }
                if (RestWizardControler.BindingType.HTTP_HEADER.getCode().equals(bindingType)) {
                    bean.addParameter(param.getName(), hint.parameterValues.get(param.getName()), RestWizardControler.BindingType.HTTP_HEADER, true, true);
                    continue;
                }
                if (!RestWizardControler.BindingType.HTTP_METHOD.getCode().equals(bindingType)) continue;
                bean.addParameter(param.getName(), hint.parameterValues.get(param.getName()), RestWizardControler.BindingType.HTTP_METHOD, true, true);
            }
        }
        Attribute att = reversedMdNode.getAttributeByShortCode("httpHeaderProperties");
        if (att != null) {
            String val = att.getValue();
            StringTokenizer tok1 = new StringTokenizer(val, "\n");
            while (tok1.hasMoreTokens()) {
                String t = tok1.nextToken();
                if (t.contains(":")) {
                    String[] p = t.split(":");
                    headers.add(new String[]{p[0].trim(), p[1].trim()});
                    continue;
                }
                headers.add(new String[]{t.trim(), ""});
            }
        }
        if ((method = NodeHandlerWsdl.readAttribute("verb", containerMdNode)) == null || method.isEmpty()) {
            method = "GET";
        }
        if ((endPoint = fullURIStr) == null) {
            endPoint = "";
        }
        if ((resource = operationName) == null) {
            resource = "";
        }
        MdNode rootMdNode = reversedMdNode;
        while (!rootMdNode.getDefType().equals("com.stambia.wsdl.wsdl")) {
            rootMdNode = (MdNode)rootMdNode.eContainer();
        }
        this.controler.setRootMdNode(rootMdNode);
        this.refreshExistingAuthenticationMdNode(rootMdNode);
        boolean isTwitter = false;
        try {
            isTwitter = rootMdNode.evaluate("../name()").equals("twitterProduct");
        }
        catch (XPathExpressionException e2) {
            this.logger.warn("unexpected", (Throwable)e2);
        }
        if (isTwitter) {
            att = rootMdNode.getAttributeByShortCode("httpAuthorization");
            currentSecurityNode = null;
            if (att != null) {
                currentSecurityNode = (MdNode)att.getRef();
            }
            this.controler.setAuthenticationMdNode(currentSecurityNode);
            att = rootMdNode.getAttributeByShortCode("httpProxyAuthorization");
            currentProxySecurityNode = null;
            if (att != null) {
                currentProxySecurityNode = (MdNode)att.getRef();
            }
            this.controler.setAuthenticationProxyMdNode(currentProxySecurityNode);
        } else {
            att = containerMdNode.getAttributeByShortCode("httpAuthorization");
            currentSecurityNode = null;
            if (att != null) {
                currentSecurityNode = (MdNode)att.getRef();
            }
            this.controler.setAuthenticationMdNode(currentSecurityNode);
            att = containerMdNode.getAttributeByShortCode("proxy");
            currentProxySecurityNode = null;
            if (att != null) {
                currentProxySecurityNode = (MdNode)att.getRef();
            }
            this.controler.setAuthenticationProxyMdNode(currentProxySecurityNode);
        }
        String enableCertificateVerification = containerMdNode.getAttributeValueByShortCode("enableCertificateValidation");
        if (enableCertificateVerification != null && !enableCertificateVerification.isEmpty()) {
            bean.setEnableCertificateVerification(Boolean.valueOf(enableCertificateVerification));
        }
        if ((enableHostnameVerification = containerMdNode.getAttributeValueByShortCode("enableHostnameValidation")) != null && !enableHostnameVerification.isEmpty()) {
            bean.setEnableHostnameVerification(Boolean.valueOf(enableHostnameVerification));
        }
        if ((keyStorePath = containerMdNode.getAttributeValueByShortCode("keyStore")) != null && !keyStorePath.isEmpty()) {
            try {
                String keyStoreType = containerMdNode.getAttributeValueByShortCode("keyStoreType");
                String keyStorePassword = MdAttributeReader.readAttribute((String)"keyStorePassword", (MdNode)containerMdNode);
                bean.setKeyStoreParams(new RestWizardBean.StoreParameters(keyStorePath, keyStoreType != null ? keyStoreType : KeyStore.getDefaultType(), keyStorePassword));
            }
            catch (MdAttributeReader.UnknownTechPropertyException e) {
                this.logger.warn((Object)e);
            }
        }
        if ((trustStorePath = containerMdNode.getAttributeValueByShortCode("trustStore")) != null && !trustStorePath.isEmpty()) {
            try {
                String trustStoreType = containerMdNode.getAttributeValueByShortCode("trustStoreType");
                String trustStorePassword = MdAttributeReader.readAttribute((String)"trustStorePassword", (MdNode)containerMdNode);
                bean.setTrustStoreParams(new RestWizardBean.StoreParameters(trustStorePath, trustStoreType != null ? trustStoreType : KeyStore.getDefaultType(), trustStorePassword));
            }
            catch (MdAttributeReader.UnknownTechPropertyException e) {
                this.logger.warn((Object)e);
            }
        }
        bean.setHttpInputContentType(mediaType);
        bean.setHttpMethod(method);
        bean.setHttpEndpoint(endPoint);
        bean.setHttpResourcePath((String)resource);
        bean.getHeaders().addAll(headers);
    }

    @Override
    public List<MdNode> getNewNode(MdNode originalMdNode, RestWizardControler.InvocationInput invocationInput) {
        MdNode operationNode = null;
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        MdNode newServiceNode = this.createMdNode(originalMdNode, invocationInput);
        nodes.add(newServiceNode);
        operationNode = (MdNode)((MdNode)newServiceNode.getNode().get(0)).getNodeByCode("com.stambia.wsdl.operation").get(0);
        String outputName = null;
        String outputPartName = null;
        String outputRootName = null;
        RestWizardControler.InvokeResult lastResult = this.controler.getLastResult();
        List l = originalMdNode.getNodeByCode("com.stambia.wsdl.output");
        if (l != null && !l.isEmpty()) {
            MdNode outputNode = (MdNode)l.get(0);
            outputName = outputNode.getName();
            l = outputNode.getNodeByCode("com.stambia.wsdl.part");
            if (l != null && !l.isEmpty()) {
                MdNode outputPartNode = null;
                for (MdNode n : l) {
                    if (!RestWizardControler.BindingType.MIME_CONTENT.getCode().equals(NodeHandlerWsdl.readAttribute("bindingType", n))) continue;
                    outputPartNode = n;
                    break;
                }
                if (outputPartNode != null) {
                    outputPartName = outputPartNode.getName();
                    if (!outputPartNode.getNode().isEmpty()) {
                        outputRootName = ((MdNode)outputPartNode.getNode().get(0)).getName();
                    }
                }
            }
        }
        if (outputPartName == null) {
            outputPartName = "result";
        }
        if (outputRootName == null) {
            outputRootName = "root";
        }
        if (lastResult != null) {
            MdNode output = MdFactory.eINSTANCE.createMdNode();
            if (lastResult.isError()) {
                output.setDefType("com.stambia.wsdl.fault");
                if (output.getName() == null) {
                    output.setName("fault");
                }
            } else {
                output.setDefType("com.stambia.wsdl.output");
                output.setName(outputName);
            }
            operationNode.getNode().add((Object)output);
            MdNode res = MdFactory.eINSTANCE.createMdNode();
            res.setDefType("com.stambia.wsdl.part");
            res.setName(outputPartName);
            int partCount = 0;
            res.setPosition(BigInteger.valueOf(++partCount));
            output.getNode().add((Object)res);
            res.setAttribute("contentType", lastResult.getContentType(), false);
            if (lastResult.getContentType() != null) {
                Map<String, List<String>> m;
                if (lastResult.getContentType().contains("json")) {
                    MdNode json = MdFactory.eINSTANCE.createMdNode();
                    json.setName(outputRootName);
                    if (lastResult.getDatas().trim().startsWith("{")) {
                        json.setDefType("com.stambia.json.rootObject");
                    } else if (lastResult.getDatas().trim().startsWith("[")) {
                        json.setDefType("com.stambia.json.rootArray");
                    } else {
                        json.setDefType("com.stambia.json.rootValue");
                    }
                    res.getNode().add((Object)json);
                    res.setAttribute("bindingType", "mime:content", false);
                    try {
                        ReverseJsonAction.reverse((MdNode)json, (int)3, (String)lastResult.getDatas(), (boolean)true, (MdNode)originalMdNode);
                    }
                    catch (ExecuteException e) {
                        Logger.getLogger(NodeHandlerWsdl.class.getName()).log(Level.SEVERE, Messages.NodeHandlerWsdl_1, e);
                    }
                } else if (lastResult.getContentType().contains("xml")) {
                    MdNode rootNode = originalMdNode;
                    while (rootNode.eContainer() instanceof MdNode) {
                        rootNode = (MdNode)rootNode.eContainer();
                    }
                    HashMap<String, String> prefixByURI = new HashMap<String, String>();
                    for (MdNode n : rootNode.getNodeByCode("com.stambia.xml.namespace")) {
                        prefixByURI.put(n.getName(), NodeHandlerWsdl.readAttribute("prefix", n));
                    }
                    XmlStreamReverser helper = new XmlStreamReverser(prefixByURI);
                    try {
                        MdNode xmlNode = helper.reverse(res, (InputStream)new ByteArrayInputStream(lastResult.getDatas().getBytes(lastResult.getCharset())));
                        Attribute originalType = xmlNode.getAttributeByShortCode("originalType");
                        xmlNode.setDefType("com.stambia.xml.element");
                        if (originalType != null) {
                            originalType.setDefType("com.stambia.xml.element.originalType");
                        }
                        res.getNode().add((Object)xmlNode);
                        res.setAttribute("bindingType", "mime:content", false);
                        MdNode wsdlNode = originalMdNode;
                        while (wsdlNode.eContainer() instanceof MdNode) {
                            wsdlNode = (MdNode)wsdlNode.eContainer();
                        }
                        for (MdNode namespace : new ArrayList(xmlNode.getNodeByCode("com.stambia.xml.namespace"))) {
                            xmlNode.getNode().remove((Object)namespace);
                            namespace.setSubstituteContainer((EObject)wsdlNode);
                            nodes.add(namespace);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                } else {
                    res.setAttribute("bindingType", "mime:content", false);
                    if (lastResult.getContentType() != null && lastResult.getContentType().trim().toLowerCase().contains("text/")) {
                        res.setAttribute("type", "string", false);
                    }
                }
                if ((m = lastResult.getHeaders()) != null) {
                    for (String k : m.keySet()) {
                        if (k == null) continue;
                        MdNode header = MdFactory.eINSTANCE.createMdNode();
                        header.setDefType("com.stambia.wsdl.part");
                        header.setName(k);
                        header.setPosition(BigInteger.valueOf(++partCount));
                        output.getNode().add((Object)header);
                        header.setAttribute("bindingType", "http:header", false);
                        header.setAttribute("type", "string", false);
                    }
                }
            }
        }
        return nodes;
    }

    private MdNode createMdNode(MdNode originalMdNode, RestWizardControler.InvocationInput input) {
        MdNode originalInput;
        MdNode serviceNode;
        MdNode result = null;
        MdNode originalPortNode = null;
        MdNode originalOperationNode = null;
        MdNode originalServiceNode = null;
        MdNode current = originalMdNode;
        while (current.eContainer() instanceof MdNode && !current.getDefType().equals("com.stambia.wsdl.wsdl")) {
            if (current.getDefType().equals("com.stambia.wsdl.port")) {
                originalPortNode = current;
            } else if (current.getDefType().equals("com.stambia.wsdl.operation")) {
                originalOperationNode = current;
            } else if (current.getDefType().equals("com.stambia.wsdl.service")) {
                originalServiceNode = current;
            }
            current = (MdNode)current.eContainer();
        }
        boolean isTwitter = false;
        try {
            isTwitter = current.evaluate("../name()").equals("twitterProduct");
        }
        catch (XPathExpressionException e2) {
            this.logger.warn("unexpected", (Throwable)e2);
        }
        result = serviceNode = originalServiceNode != null ? originalServiceNode.copy(1) : MdFactory.eINSTANCE.createMdNode();
        serviceNode.setDefType("com.stambia.wsdl.service");
        serviceNode.setSubstituteContainer((EObject)current);
        MdNode portNode = originalPortNode != null ? originalPortNode.copy(1) : MdFactory.eINSTANCE.createMdNode();
        serviceNode.getNode().add((Object)portNode);
        portNode.setDefType("com.stambia.wsdl.port");
        if (isTwitter) {
            current.setRefAttribute("httpAuthorization", (EObject)this.controler.getAuthenticationMdNode(), current.eResource() != null);
            current.setRefAttribute("httpProxyAuthorization", (EObject)this.controler.getAuthenticationProxyMdNode(), current.eResource() != null);
        } else {
            portNode.setRefAttribute("httpAuthorization", (EObject)this.controler.getAuthenticationMdNode(), portNode.eResource() != null);
            portNode.setRefAttribute("httpProxyAuthorization", (EObject)this.controler.getAuthenticationProxyMdNode(), portNode.eResource() != null);
        }
        portNode.setAttribute("address", input.getEndpoint(), false);
        portNode.setAttribute("protocol", "HTTP", false);
        portNode.setAttribute("verb", input.getMethod(), false);
        MdNode operationNode = originalOperationNode != null ? originalOperationNode.copy(1) : MdFactory.eINSTANCE.createMdNode();
        portNode.getNode().add((Object)operationNode);
        operationNode.setDefType("com.stambia.wsdl.operation");
        operationNode.setAttribute("address", input.getResource(), false);
        StringBuffer headers = new StringBuffer();
        for (String[] h : input.getHeaders()) {
            if (headers.length() > 0) {
                headers.append("\n");
            }
            headers.append(h[0]);
            headers.append(":");
            headers.append(h[1]);
        }
        if (headers.length() > 0) {
            operationNode.setAttribute("httpHeaderProperties", headers.toString(), false);
        }
        MdNode inputNode = (originalInput = this.findFirstNode(originalMdNode, "com.stambia.wsdl.input")) != null ? originalInput.copy(1) : MdFactory.eINSTANCE.createMdNode();
        operationNode.getNode().add((Object)inputNode);
        inputNode.setDefType("com.stambia.wsdl.input");
        for (RestWizardBean.Parameter p : input.getParameters()) {
            MdNode originalParam = null;
            if (originalInput != null) {
                originalParam = originalInput.getNodeByName("com.stambia.wsdl.part", p.name);
            }
            MdNode paramNode = originalParam != null ? originalParam.copy(1) : MdFactory.eINSTANCE.createMdNode();
            inputNode.getNode().add((Object)paramNode);
            paramNode.setDefType("com.stambia.wsdl.part");
            paramNode.setName(p.name);
            paramNode.setAttribute("type", "string", false);
            paramNode.setAttribute("bindingType", p.type.getCode(), false);
            if (RestWizardControler.BindingType.MIME_CONTENT != p.type) continue;
            paramNode.setAttribute("contentType", "application/x-www-form-urlencoded", false);
        }
        if (input.input != null && !input.input.trim().isEmpty()) {
            MdNode node = MdFactory.eINSTANCE.createMdNode();
            node.setDefType("com.stambia.wsdl.part");
            if (originalInput != null) {
                boolean nameSet = false;
                for (MdNode n : originalInput.getNode()) {
                    if (!RestWizardControler.BindingType.MIME_CONTENT.getCode().equals(NodeHandlerWsdl.readAttribute("bindingType", n))) continue;
                    node.setName(n.getName());
                    nameSet = true;
                    break;
                }
                if (!nameSet) {
                    node.setName("content");
                }
            }
            if (node.getName() == null || node.getName().isEmpty()) {
                node.setName("content");
            }
            inputNode.getNode().add((Object)node);
            String mimeType = input.getInputContentType();
            if (mimeType != null) {
                node.setAttribute("bindingType", RestWizardControler.BindingType.MIME_CONTENT.getCode(), false);
                node.setAttribute("contentType", mimeType, false);
                if (mimeType.endsWith("/xml") || mimeType.endsWith("+xml")) {
                    MdNode rootNode = originalMdNode;
                    while (rootNode.eContainer() instanceof MdNode) {
                        rootNode = (MdNode)rootNode.eContainer();
                    }
                    HashMap<String, String> prefixByURI = new HashMap<String, String>();
                    for (MdNode n : rootNode.getNodeByCode("com.stambia.xml.namespace")) {
                        prefixByURI.put(n.getName(), NodeHandlerWsdl.readAttribute("prefix", n));
                    }
                    XmlStreamReverser helper = new XmlStreamReverser(prefixByURI);
                    try {
                        MdNode xmlNode = helper.reverse(node, (InputStream)new ByteArrayInputStream(input.input.getBytes()));
                        xmlNode.setDefType("com.stambia.xml.element");
                        Attribute originalType = xmlNode.getAttributeByShortCode("originalType");
                        if (originalType != null) {
                            originalType.setDefType("com.stambia.xml.element.originalType");
                        }
                        node.getNode().add((Object)xmlNode);
                    }
                    catch (Exception e) {
                        this.logger.warn("Error while reversing XML content", (Throwable)e);
                    }
                } else if (mimeType.endsWith("/json") || mimeType.endsWith("+json")) {
                    MdNode json = MdFactory.eINSTANCE.createMdNode();
                    if (input.input.trim().startsWith("{")) {
                        json.setDefType("com.stambia.json.rootObject");
                    } else if (input.input.trim().startsWith("[")) {
                        json.setDefType("com.stambia.json.rootArray");
                    } else {
                        json.setDefType("com.stambia.json.rootValue");
                    }
                    json.setName("result");
                    node.getNode().add((Object)json);
                    try {
                        ReverseJsonAction.reverse((MdNode)json, (int)3, (String)input.input, (boolean)true);
                    }
                    catch (ExecuteException e) {
                        this.logger.warn("Error while reversing JSON content", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void refreshExistingAuthenticationMdNode(MdNode rootMdNode) {
        ArrayList<MdNode> securityNodes = new ArrayList<MdNode>();
        try {
            Collection credentialCollection = (Collection)rootMdNode.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_SECURITY_CREDENTIALS_REF");
            if (credentialCollection != null) {
                securityNodes.addAll(credentialCollection);
            }
        }
        catch (XPathExpressionException e) {
            Logger.getLogger(NodeHandlerWsdl.class.getName()).log(Level.SEVERE, Messages.NodeHandlerWsdl_0, e);
        }
        this.controler.setAuthenticationMdNodes(securityNodes);
    }

    private MdNode findFirstNode(MdNode reversedMdNode, String defType) {
        List l = reversedMdNode.getNodeByCode(defType);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return (MdNode)l.get(0);
    }
}

