/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.ntlm.wizard;

import com.indy.addons.ntlm.wizard.INTLMControler;
import com.indy.addons.ntlm.wizard.NTLMBean;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class Controler
implements INTLMControler {
    public static final String DEF_TYPE_WSDL = "com.stambia.wsdl.ntlm";
    public static final String DEF_TYPE_SECURITY = "com.stambia.security.ntlm";
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected NTLMBean bean = new NTLMBean();
    protected MdNode originalNodeParent;
    protected MdNode original;
    protected String defType;

    public static INTLMControler createControler(String defType, MdNode originalNode, MdNode orginalParent) {
        if (DEF_TYPE_SECURITY.equals(defType)) {
            return new Controler(DEF_TYPE_SECURITY, originalNode, orginalParent);
        }
        if (DEF_TYPE_WSDL.equals(defType)) {
            return new Controler(DEF_TYPE_WSDL, originalNode, orginalParent);
        }
        return null;
    }

    private Controler(String defType, MdNode originalNode, MdNode orginalParent) {
        this.defType = defType;
        this.initBean(originalNode, orginalParent);
        this.original = originalNode;
    }

    @Override
    public MdNode createNewMdNode() {
        MdNode node = this.original == null ? MdFactoryHelper.createMdNode((String)this.defType) : this.original.copy(1);
        node.setName(this.bean.getName());
        Attribute a = node.getAttributeByShortCode("userName");
        if (a == null) {
            a = MdFactoryHelper.createAttribute((String)(this.defType + ".userName"));
            node.getAttribute().add((Object)a);
        }
        a.setValue(this.bean.getUserName());
        a = node.getAttributeByShortCode("password");
        if (a == null) {
            a = MdFactoryHelper.createAttribute((String)(this.defType + ".password"));
            node.getAttribute().add((Object)a);
        }
        try {
            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
            a.setValue(semaphoreManager.setSemaphore(true, this.bean.getPassword()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        a = node.getAttributeByShortCode("domain");
        if (a == null) {
            a = MdFactoryHelper.createAttribute((String)(this.defType + ".domain"));
            node.getAttribute().add((Object)a);
        }
        a.setValue(this.bean.getDomain());
        node.setSubstituteContainer((EObject)this.originalNodeParent);
        return node;
    }

    @Override
    public void initBean(MdNode mdNode, MdNode parent) {
        this.originalNodeParent = parent;
        if (mdNode != null) {
            if (mdNode.getName() != null) {
                this.bean.setName(mdNode.getName());
            }
            try {
                this.bean.setDomain(MdAttributeReader.readAttribute((String)"domain", (MdNode)mdNode, (String)""));
            }
            catch (MdAttributeReader.UnknownTechPropertyException e) {
                this.logger.warn("Error reading domain", (Throwable)e);
            }
            try {
                this.bean.setUserName(MdAttributeReader.readAttribute((String)"userName", (MdNode)mdNode, (String)""));
            }
            catch (MdAttributeReader.UnknownTechPropertyException e) {
                this.logger.warn("Error reading userName", (Throwable)e);
            }
            try {
                this.bean.setPassword(MdAttributeReader.readAttribute((String)"password", (MdNode)mdNode, (String)""));
            }
            catch (MdAttributeReader.UnknownTechPropertyException e) {
                this.logger.warn("Error reading password", (Throwable)e);
            }
        }
    }

    @Override
    public NTLMBean getBean() {
        return this.bean;
    }

    @Override
    public String getNTLMDefType() {
        return this.defType;
    }
}

